@extends('admin.mobile.layouts.app')

@section('title', 'Randevular')

@push('styles')
<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
    }
    
    .filters-card {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 16px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #e5e7eb;
    }
    
    .filter-row {
        display: grid;
        grid-template-columns: 1fr;
        gap: 12px;
        margin-bottom: 12px;
    }
    
    .filter-group {
        display: flex;
        flex-direction: column;
    }
    
    .filter-label {
        font-size: 12px;
        font-weight: 600;
        color: #6b7280;
        margin-bottom: 6px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .filter-input {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 14px;
        background: white;
        -webkit-appearance: none;
    }
    
    .filter-input:focus {
        outline: none;
        border-color: #10b981;
        box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
    }
    
    .sort-select {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 14px;
        background: white;
        -webkit-appearance: none;
    }
    
    .list-item {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #e5e7eb;
        border-left: 4px solid;
        text-decoration: none;
        color: inherit;
        transition: all 0.2s;
        display: block;
    }
    
    .list-item:active {
        transform: translateX(4px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.12);
    }
    
    .list-item.status-confirmed {
        border-left-color: #10b981;
    }
    
    .list-item.status-open {
        border-left-color: #f59e0b;
    }
    
    .list-item.status-completed {
        border-left-color: #6b7280;
    }
    
    .list-item.status-cancelled {
        border-left-color: #ef4444;
    }
    
    .list-item-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 12px;
    }
    
    .customer-info {
        display: flex;
        align-items: center;
        gap: 12px;
        flex: 1;
    }
    
    .customer-avatar {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 700;
        font-size: 16px;
        flex-shrink: 0;
    }
    
    .customer-details {
        flex: 1;
    }
    
    .customer-name {
        font-size: 16px;
        font-weight: 700;
        color: #111827;
        margin-bottom: 4px;
    }
    
    .customer-meta {
        font-size: 13px;
        color: #6b7280;
    }
    
    .status-badge {
        padding: 6px 12px;
        border-radius: 8px;
        font-size: 12px;
        font-weight: 600;
        white-space: nowrap;
    }
    
    .status-badge.confirmed {
        background: #d1fae5;
        color: #065f46;
    }
    
    .status-badge.open {
        background: #fef3c7;
        color: #92400e;
    }
    
    .status-badge.completed {
        background: #e5e7eb;
        color: #374151;
    }
    
    .status-badge.cancelled {
        background: #fee2e2;
        color: #991b1b;
    }
    
    .list-item-body {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 12px;
        margin-top: 12px;
        padding-top: 12px;
        border-top: 1px solid #f3f4f6;
    }
    
    .info-item {
        display: flex;
        flex-direction: column;
    }
    
    .info-label {
        font-size: 11px;
        color: #6b7280;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 4px;
    }
    
    .info-value {
        font-size: 14px;
        font-weight: 600;
        color: #111827;
    }
    
    .info-value.amount {
        color: #10b981;
        font-size: 16px;
    }
    
    .info-value.remaining {
        color: #ef4444;
    }
    
    .info-value.paid {
        color: #10b981;
    }
    
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #9ca3af;
    }
    
    .empty-state-icon {
        font-size: 64px;
        margin-bottom: 16px;
        opacity: 0.5;
    }
    
    .empty-state-text {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 8px;
    }
    
    .empty-state-subtext {
        font-size: 14px;
        color: #6b7280;
    }
    
    .btn-primary {
        background: #10b981;
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        border: none;
        min-height: 44px;
    }
    
    .btn-primary:active {
        background: #047857;
        transform: scale(0.98);
    }
    
    .pagination-wrapper {
        margin-top: 24px;
        display: flex;
        justify-content: center;
    }
    
    .action-btn {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        border: none;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        cursor: pointer;
        transition: all 0.2s;
        flex-shrink: 0;
    }
    
    .action-btn-complete {
        background: #10b981;
        color: white;
    }
    
    .action-btn-complete:active {
        background: #059669;
        transform: scale(0.95);
    }
    
    .action-btn-cancel {
        background: #ef4444;
        color: white;
    }
    
    .action-btn-cancel:active {
        background: #dc2626;
        transform: scale(0.95);
    }
</style>
@endpush

@section('content')
<div class="appointments">
    <div class="page-header">
        <h1 class="page-title">Randevular</h1>
        <a href="{{ route('mobile.appointments.create') }}" class="btn-primary">
            <i class="bi bi-plus-circle"></i> Yeni
        </a>
    </div>
    
    <!-- Filtreler -->
    <div class="filters-card">
        <form method="GET" action="{{ route('mobile.appointments.index') }}" id="filterForm">
            <div class="filter-row">
                <div class="filter-group">
                    <label class="filter-label">Tarih</label>
                    <input type="date" name="date" class="filter-input" value="{{ request('date') }}" onchange="document.getElementById('filterForm').submit();">
                </div>
                
                <div class="filter-group">
                    <label class="filter-label">Salon</label>
                    <select name="salon_id" class="filter-input" onchange="document.getElementById('filterForm').submit();">
                        <option value="">Tüm Salonlar</option>
                        @foreach($salons ?? [] as $salon)
                            <option value="{{ $salon->id }}" {{ request('salon_id') == $salon->id ? 'selected' : '' }}>
                                {{ $salon->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <div class="filter-group">
                    <label class="filter-label">Durum</label>
                    <select name="status" class="filter-input" onchange="document.getElementById('filterForm').submit();">
                        <option value="">Tüm Durumlar</option>
                        <option value="open" {{ request('status') == 'open' ? 'selected' : '' }}>Açık</option>
                        <option value="confirmed" {{ request('status') == 'confirmed' ? 'selected' : '' }}>Onaylandı</option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Tamamlandı</option>
                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>İptal</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <label class="filter-label">Sıralama</label>
                    <select name="sort" class="sort-select" onchange="document.getElementById('filterForm').submit();">
                        <option value="date_asc" {{ request('sort') == 'date_asc' ? 'selected' : '' }}>En Yakın Tarih</option>
                        <option value="date_desc" {{ request('sort') == 'date_desc' ? 'selected' : '' }}>Yeniden Eskiye</option>
                        <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }}>A-Z (Müşteri)</option>
                    </select>
                </div>
            </div>
        </form>
    </div>
    
    @if($appointments->count() > 0)
        <div class="list">
            @foreach($appointments as $reservation)
                @php
                    $itemsData = json_decode($reservation->items_data ?? '{}', true);
                    $brideName = $itemsData['bride_name'] ?? null;
                    $groomName = $itemsData['groom_name'] ?? null;
                    // Kalan tutarı remaining_amount'dan al, yoksa hesapla
                    $remaining = $reservation->remaining_amount ?? ($reservation->total_price - ($reservation->deposit_paid ?? 0));
                    // Negatif olamaz
                    $remaining = max(0, $remaining);
                    $dateColumn = \Illuminate\Support\Facades\Schema::hasColumn('appointments', 'date') ? 'date' : 'start_date';
                    $reservationDate = $reservation->$dateColumn ?? $reservation->date ?? $reservation->start_date;
                    $customerInitials = strtoupper(substr($reservation->customer->name ?? '??', 0, 2));
                    $avatarColor = $reservation->customer->avatar_color ?? '#10b981';
                @endphp
                <div class="list-item status-{{ $reservation->status }}">
                    <div class="list-item-header">
                        <a href="{{ route('mobile.appointments.show', $reservation->id) }}" style="flex: 1; text-decoration: none; color: inherit;">
                            <div class="customer-info">
                                <div class="customer-avatar" style="background: {{ $avatarColor }};">
                                    {{ $customerInitials }}
                                </div>
                                <div class="customer-details">
                                    <div class="customer-name">{{ $reservation->customer->name ?? 'Müşteri' }}</div>
                                    <div class="customer-meta">
                                        @if($brideName && $groomName)
                                            <i class="bi bi-heart-fill" style="color: #ec4899; font-size: 10px;"></i>
                                            {{ $brideName }} & {{ $groomName }}
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </a>
                        <div style="display: flex; align-items: center; gap: 8px;">
                            <span class="status-badge {{ $reservation->status }}">
                                @if($reservation->status === 'confirmed')
                                    Onaylandı
                                @elseif($reservation->status === 'open')
                                    Açık
                                @elseif($reservation->status === 'completed')
                                    Tamamlandı
                                @elseif($reservation->status === 'cancelled')
                                    İptal
                                @endif
                            </span>
                            @if($reservation->status !== 'completed' && $reservation->status !== 'cancelled')
                            <button type="button" class="action-btn action-btn-complete" onclick="completeReservation({{ $reservation->id }}, event)" title="Tamamla">
                                <i class="bi bi-check-circle-fill"></i>
                            </button>
                            <button type="button" class="action-btn action-btn-cancel" onclick="cancelReservation({{ $reservation->id }}, event)" title="İptal Et">
                                <i class="bi bi-x-circle-fill"></i>
                            </button>
                            @endif
                        </div>
                    </div>
                    
                    <a href="{{ route('mobile.appointments.show', $reservation->id) }}" style="text-decoration: none; color: inherit;">
                        <div class="list-item-body">
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="bi bi-calendar3"></i> Tarih
                                </div>
                                <div class="info-value">
                                    {{ \Carbon\Carbon::parse($reservationDate)->format('d.m.Y') }}
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="bi bi-clock"></i> Saat
                                </div>
                                <div class="info-value">
                                    {{ $reservation->time ?? '-' }}
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="bi bi-building"></i> Salon
                                </div>
                                <div class="info-value">
                                    {{ $reservation->salon->name ?? '-' }}
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="bi bi-cash-coin"></i> Toplam
                                </div>
                                <div class="info-value amount">
                                    {{ number_format($reservation->total_price, 2, ',', '.') }} ₺
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="bi bi-check-circle"></i> Ödenen
                                </div>
                                <div class="info-value paid">
                                    {{ number_format($reservation->deposit_paid ?? 0, 2, ',', '.') }} ₺
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="bi bi-exclamation-circle"></i> Kalan
                                </div>
                                <div class="info-value remaining">
                                    {{ number_format($remaining, 2, ',', '.') }} ₺
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>
        
        <div class="pagination-wrapper">
            {{ $appointments->links() }}
        </div>
    @else
        <div class="empty-state">
            <div class="empty-state-icon">📅</div>
            <div class="empty-state-text">Henüz randevu yok</div>
            <div class="empty-state-subtext">
                @if(request()->hasAny(['date', 'salon_id', 'status']))
                    Filtrelere uygun randevu bulunamadı
                @else
                    İlk randevuunuzu oluşturun
                @endif
            </div>
            <a href="{{ route('mobile.appointments.create') }}" class="btn-primary" style="margin-top: 20px;">
                <i class="bi bi-plus-circle"></i> Yeni Randevu Oluştur
            </a>
        </div>
    @endif
</div>

@push('scripts')
<script>
function completeReservation(id, event) {
    event.stopPropagation();
    event.preventDefault();
    
    // showConfirmModal kontrolü
    if (typeof showConfirmModal === 'undefined') {
        // Fallback: direkt onayla
        if (!confirm('Randevuu tamamlamak istediğinizden emin misiniz?\n\nKalan tutar kasaya "ödeme yapıldı" olarak eklenecek ve randevu tamamlandı olarak işaretlenecektir.')) {
            return;
        }
        executeComplete(id, event);
    } else {
        showConfirmModal(
            'Randevuu Tamamla',
            'Randevuu tamamlamak istediğinizden emin misiniz?\n\nKalan tutar kasaya "ödeme yapıldı" olarak eklenecek ve randevu tamamlandı olarak işaretlenecektir.',
            function() {
                executeComplete(id, event);
            }
        );
    }
}

function executeComplete(id, event) {
    const btn = event.target.closest('.action-btn-complete');
    if (!btn) return;
    
    const originalHtml = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = '<i class="bi bi-hourglass-split"></i>';
    
    fetch('{{ route("mobile.appointments.complete", ":id") }}'.replace(':id', id), {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => {
        if (!response.ok) {
            return response.json().then(data => {
                throw new Error(data.message || 'Bir hata oluştu.');
            });
        }
        return response.json();
    })
    .then(data => {
        if (data.success) {
            if (typeof showAlertModal !== 'undefined') {
                showAlertModal('Başarılı', data.message || 'Randevu tamamlandı.');
            } else {
                alert(data.message || 'Randevu tamamlandı.');
            }
            setTimeout(() => {
                location.reload();
            }, 1000);
        } else {
            if (typeof showAlertModal !== 'undefined') {
                showAlertModal('Hata', data.message || 'Bir hata oluştu.');
            } else {
                alert(data.message || 'Bir hata oluştu.');
            }
            btn.disabled = false;
            btn.innerHTML = originalHtml;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        if (typeof showAlertModal !== 'undefined') {
            showAlertModal('Hata', 'Bir hata oluştu. Lütfen tekrar deneyin.');
        } else {
            alert('Bir hata oluştu. Lütfen tekrar deneyin.');
        }
        btn.disabled = false;
        btn.innerHTML = originalHtml;
    });
}

function cancelReservation(id, event) {
    event.stopPropagation();
    event.preventDefault();
    
    // showConfirmModal kontrolü
    if (typeof showConfirmModal === 'undefined') {
        // Fallback: direkt onayla
        if (!confirm('Randevuu iptal etmek istediğinize emin misiniz?\n\nRandevu iptal edilecektir.')) {
            return;
        }
        executeCancel(id, event);
    } else {
        showConfirmModal(
            'Randevuu İptal Et',
            'Randevuu iptal etmek istediğinize emin misiniz?\n\nRandevu iptal edilecektir.',
            function() {
                executeCancel(id, event);
            }
        );
    }
}

function executeCancel(id, event) {
    const btn = event.target.closest('.action-btn-cancel');
    if (!btn) return;
    
    const originalHtml = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = '<i class="bi bi-hourglass-split"></i>';
    
    fetch('{{ route("mobile.appointments.cancel", ":id") }}'.replace(':id', id), {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => {
        if (!response.ok) {
            return response.json().then(data => {
                throw new Error(data.message || 'Bir hata oluştu.');
            });
        }
        return response.json();
    })
    .then(data => {
        if (data.success) {
            if (typeof showAlertModal !== 'undefined') {
                showAlertModal('Başarılı', 'Randevu iptal edildi.');
            } else {
                alert('Randevu iptal edildi.');
            }
            setTimeout(() => {
                location.reload();
            }, 1000);
        } else {
            if (typeof showAlertModal !== 'undefined') {
                showAlertModal('Hata', data.message || 'Bir hata oluştu.');
            } else {
                alert(data.message || 'Bir hata oluştu.');
            }
            btn.disabled = false;
            btn.innerHTML = originalHtml;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        if (typeof showAlertModal !== 'undefined') {
            showAlertModal('Hata', 'Bir hata oluştu. Lütfen tekrar deneyin.');
        } else {
            alert('Bir hata oluştu. Lütfen tekrar deneyin.');
        }
        btn.disabled = false;
        btn.innerHTML = originalHtml;
    });
}
</script>
@endpush
@endsection


