@extends('admin.mobile.layouts.app')

@section('title', 'Randevu Detayı')

@push('styles')
<style>
    .back-button {
        background: #e5e7eb;
        color: #4b5563;
        padding: 8px 12px;
        border-radius: 8px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
    }
    
    .back-button:active {
        background: #d1d5db;
        transform: scale(0.98);
    }
    
    .reservation-detail {
        padding-bottom: 20px;
    }
    
    .info-card {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 16px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #e5e7eb;
    }
    
    .info-card-header {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 12px;
        padding-bottom: 12px;
        border-bottom: 2px solid #f3f4f6;
    }
    
    .info-card-header i {
        font-size: 20px;
        color: #10b981;
    }
    
    .info-card-header h6 {
        font-size: 14px;
        font-weight: 700;
        color: #111827;
        margin: 0;
    }
    
    .info-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px 0;
        border-bottom: 1px solid #f3f4f6;
    }
    
    .info-row:last-child {
        border-bottom: none;
    }
    
    .info-label {
        font-size: 13px;
        color: #6b7280;
        font-weight: 600;
    }
    
    .info-value {
        font-size: 14px;
        color: #111827;
        font-weight: 600;
        text-align: right;
    }
    
    .info-value-large {
        font-size: 18px;
        font-weight: 700;
        color: #10b981;
    }
    
    .badge-status {
        padding: 6px 12px;
        border-radius: 8px;
        font-size: 12px;
        font-weight: 600;
        display: inline-block;
    }
    
    .badge-open {
        background: #fff3cd;
        color: #856404;
    }
    
    .badge-confirmed {
        background: #d4edda;
        color: #155724;
    }
    
    .badge-completed {
        background: #e2e3e5;
        color: #383d41;
    }
    
    .badge-cancelled {
        background: #f8d7da;
        color: #721c24;
    }
    
    .customer-avatar {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: bold;
        font-size: 18px;
        flex-shrink: 0;
        margin-right: 12px;
    }
    
    .customer-info {
        flex: 1;
    }
    
    .customer-name {
        font-size: 16px;
        font-weight: 700;
        color: #111827;
        margin-bottom: 4px;
    }
    
    .customer-detail {
        font-size: 13px;
        color: #6b7280;
    }
    
    .price-card {
        background: linear-gradient(135deg, #10b981 0%, #047857 100%);
        border-radius: 12px;
        padding: 20px;
        margin-bottom: 16px;
        color: white;
    }
    
    .price-label {
        font-size: 14px;
        opacity: 0.9;
        margin-bottom: 8px;
    }
    
    .price-value {
        font-size: 24px;
        font-weight: 700;
    }
    
    .transaction-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 0;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .transaction-item:last-child {
        border-bottom: none;
    }
    
    .transaction-date {
        font-size: 12px;
        color: #6b7280;
    }
    
    .transaction-desc {
        font-size: 14px;
        color: #111827;
        flex: 1;
        margin: 0 12px;
    }
    
    .transaction-amount {
        font-size: 16px;
        font-weight: 700;
    }
    
    .transaction-income {
        color: #059669;
    }
    
    .transaction-expense {
        color: #dc2626;
    }
    
    .extra-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px 0;
        border-bottom: 1px solid #f3f4f6;
    }
    
    .extra-item:last-child {
        border-bottom: none;
    }
    
    .extra-name {
        font-size: 14px;
        color: #111827;
        font-weight: 600;
    }
    
    .extra-price {
        font-size: 14px;
        color: #10b981;
        font-weight: 700;
    }
    
    .payment-btn {
        width: 100%;
        padding: 12px;
        background: #10b981;
        color: white;
        border: none;
        border-radius: 8px;
        font-size: 16px;
        font-weight: 600;
        margin-top: 16px;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .payment-btn:active {
        background: #059669;
        transform: scale(0.98);
    }
</style>
@endpush

@section('content')
<div class="reservation-detail">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px;">
        <h1 style="font-size: 24px; font-weight: 700; color: #333;">Randevu Detayı</h1>
        <a href="{{ route('mobile.appointments.index') }}" class="back-button">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    @php
        $itemsData = json_decode($reservation->items_data ?? '{}', true);
        
        // Kalan tutarı remaining_amount'dan al, yoksa hesapla
        $remainingAmount = $reservation->remaining_amount ?? ($reservation->total_price - ($reservation->deposit_paid ?? 0));
        // Negatif olamaz
        $remainingAmount = max(0, $remainingAmount);
        $dateColumn = \Illuminate\Support\Facades\Schema::hasColumn('appointments', 'date') ? 'date' : 'start_date';
        $reservationDate = $reservation->$dateColumn ?? $reservation->date ?? $reservation->start_date;
        $transactions = \App\Models\Transaction::where('reservation_id', $reservation->id)
            ->orderBy('date', 'desc')
            ->orderBy('created_at', 'desc')
            ->get();
        $totalPaid = $transactions->where('type', 'income')->sum('amount');
        
        // Süre hesaplama
        $duration = 0;
        if ($reservation->start_time && $reservation->end_time) {
            try {
                $start = \Carbon\Carbon::parse($reservation->start_time);
                $end = \Carbon\Carbon::parse($reservation->end_time);
                $duration = $start->diffInHours($end);
            } catch (\Exception $e) {
                $duration = 0;
            }
        }
    @endphp
    
    <!-- Müşteri Bilgileri -->
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-person-fill"></i>
            <h6>Müşteri</h6>
        </div>
        <div style="display: flex; align-items: center;">
            <div class="customer-avatar" style="background: {{ $reservation->customer->avatar_color ?? '#10b981' }};">
                {{ $reservation->customer->initials ?? '??' }}
            </div>
            <div class="customer-info">
                <div class="customer-name">{{ $reservation->customer->name ?? 'Müşteri' }}</div>
                @if($reservation->customer->phone)
                    <div class="customer-detail">
                        <i class="bi bi-telephone"></i> {{ $reservation->customer->phone }}
                    </div>
                @endif
                @if($reservation->customer->email)
                    <div class="customer-detail">
                        <i class="bi bi-envelope"></i> {{ $reservation->customer->email }}
                    </div>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Gelin/damat bilgisi kaldırıldı -->
    @if(false)
    <!-- Gelin/damat bilgisi kaldırıldı -->
    
    <!-- Randevu Bilgileri -->
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-info-circle"></i>
            <h6>Randevu Bilgileri</h6>
        </div>
        
        <div class="info-row">
            <span class="info-label"><i class="bi bi-building"></i> Salon</span>
            <span class="info-value">{{ $reservation->salon->name ?? '-' }}</span>
        </div>
        
        <div class="info-row">
            <span class="info-label"><i class="bi bi-calendar3"></i> Tarih</span>
            <span class="info-value">
                {{ \Carbon\Carbon::parse($reservationDate)->format('d.m.Y') }}
                <small style="color: #6b7280; font-weight: normal;">
                    ({{ \Carbon\Carbon::parse($reservationDate)->locale('tr')->isoFormat('dddd') }})
                </small>
            </span>
        </div>
        
        <div class="info-row">
            <span class="info-label"><i class="bi bi-clock"></i> Saat</span>
            <span class="info-value">
                {{ $reservation->start_time ?? '-' }} - {{ $reservation->end_time ?? '-' }}
                @if($duration > 0)
                    <small style="color: #6b7280; font-weight: normal;">({{ $duration }} saat)</small>
                @endif
            </span>
        </div>
        
        @if($reservation->guest_count)
        <div class="info-row">
            <span class="info-label"><i class="bi bi-people-fill"></i> Misafir Sayısı</span>
            <span class="info-value">{{ $reservation->guest_count }} kişi</span>
        </div>
        @endif
        
        <div class="info-row">
            <span class="info-label"><i class="bi bi-info-circle-fill"></i> Durum</span>
            <span class="info-value">
                @if($reservation->status === 'open')
                    <span class="badge-status badge-open">Açık</span>
                @elseif($reservation->status === 'confirmed')
                    <span class="badge-status badge-confirmed">Onaylandı</span>
                @elseif($reservation->status === 'completed')
                    <span class="badge-status badge-completed">Tamamlandı</span>
                @elseif($reservation->status === 'cancelled')
                    <span class="badge-status badge-cancelled">İptal</span>
                @endif
            </span>
        </div>
        
        @if($reservation->code)
        <div class="info-row">
            <span class="info-label"><i class="bi bi-tag-fill"></i> Randevu Kodu</span>
            <span class="info-value">{{ $reservation->code }}</span>
        </div>
        @endif
        
        <div class="info-row">
            <span class="info-label"><i class="bi bi-calendar-check"></i> Oluşturulma</span>
            <span class="info-value">
                {{ $reservation->created_at->format('d.m.Y') }} {{ $reservation->created_at->format('H:i') }}
            </span>
        </div>
    </div>
    
    <!-- Ödeme Bilgileri -->
    <div class="price-card">
        <div class="price-label">Toplam Tutar</div>
        <div class="price-value">{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</div>
    </div>
    
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-cash-coin"></i>
            <h6>Ödeme Bilgileri</h6>
        </div>
        
        <div class="info-row">
            <span class="info-label">Ödenen Kapora</span>
            <span class="info-value" style="color: #10b981;">
                {{ number_format($reservation->deposit_paid ?? 0, 2, ',', '.') }} ₺
            </span>
        </div>
        
        <div class="info-row">
            <span class="info-label">Kalan Bakiye</span>
            <span class="info-value-large" style="color: #ef4444;">
                {{ number_format($remainingAmount, 2, ',', '.') }} ₺
            </span>
        </div>
    </div>
    
    <!-- Ödeme Geçmişi -->
    @if($transactions->count() > 0)
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-receipt"></i>
            <h6>Ödeme Geçmişi</h6>
        </div>
        
        @foreach($transactions as $transaction)
        <div class="transaction-item">
            <div>
                <div class="transaction-date">
                    {{ $transaction->date ? $transaction->date->format('d.m.Y') : '-' }}
                </div>
                <div class="transaction-desc">
                    {{ Str::limit($transaction->description, 40) }}
                </div>
            </div>
            <div class="transaction-amount {{ $transaction->type == 'income' ? 'transaction-income' : 'transaction-expense' }}">
                @if($transaction->type == 'income')
                    +{{ number_format($transaction->amount, 2, ',', '.') }} ₺
                @else
                    -{{ number_format($transaction->amount, 2, ',', '.') }} ₺
                @endif
            </div>
        </div>
        @endforeach
        
        <div class="transaction-item" style="border-top: 2px solid #e5e7eb; margin-top: 8px; padding-top: 12px;">
            <div style="font-weight: 700; color: #111827;">Toplam Ödenen</div>
            <div class="transaction-amount transaction-income">
                {{ number_format($totalPaid, 2, ',', '.') }} ₺
            </div>
        </div>
    </div>
    @endif
    
    <!-- Extralar -->
    @if($reservation->extras && $reservation->extras->count() > 0)
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-plus-circle"></i>
            <h6>Ekstra Hizmetler</h6>
        </div>
        
        @foreach($reservation->extras as $extra)
        <div class="extra-item">
            <div class="extra-name">{{ $extra->name }}</div>
            <div class="extra-price">
                @if(isset($extra->pivot->quantity) && isset($extra->pivot->price))
                    {{ number_format($extra->pivot->quantity * $extra->pivot->price, 2, ',', '.') }} ₺
                @else
                    {{ number_format($extra->price ?? 0, 2, ',', '.') }} ₺
                @endif
            </div>
        </div>
        @endforeach
    </div>
    @endif
    
    <!-- Items Data (Yemekler, Organizasyonlar, Extralar) -->
    @if(!empty($itemsData))
    @php
        $meals = $itemsData['meals'] ?? [];
        $organizations = $itemsData['organizations'] ?? [];
        $extras = $itemsData['extras'] ?? [];
    @endphp
    
    @if(count($meals) > 0)
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-cup-hot"></i>
            <h6>Yemekler</h6>
        </div>
        @foreach($meals as $meal)
        <div class="extra-item">
            <div class="extra-name">
                {{ $meal['name'] ?? 'Yemek' }}
                @if(isset($meal['quantity']) && $meal['quantity'] > 1)
                    <small style="color: #6b7280;">({{ $meal['quantity'] }} adet)</small>
                @endif
            </div>
            <div class="extra-price">
                @if(isset($meal['quantity']) && isset($meal['price']))
                    {{ number_format($meal['quantity'] * $meal['price'], 2, ',', '.') }} ₺
                @elseif(isset($meal['price']))
                    {{ number_format($meal['price'], 2, ',', '.') }} ₺
                @else
                    0,00 ₺
                @endif
            </div>
        </div>
        @endforeach
    </div>
    @endif
    
    @if(count($organizations) > 0)
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-gift"></i>
            <h6>Organizasyon</h6>
        </div>
        @foreach($organizations as $org)
        <div class="extra-item">
            <div class="extra-name">
                {{ $org['name'] ?? 'Organizasyon' }}
                @if(isset($org['quantity']) && $org['quantity'] > 1)
                    <small style="color: #6b7280;">({{ $org['quantity'] }} adet)</small>
                @endif
            </div>
            <div class="extra-price">
                @if(isset($org['quantity']) && isset($org['price']))
                    {{ number_format($org['quantity'] * $org['price'], 2, ',', '.') }} ₺
                @elseif(isset($org['price']))
                    {{ number_format($org['price'], 2, ',', '.') }} ₺
                @else
                    0,00 ₺
                @endif
            </div>
        </div>
        @endforeach
    </div>
    @endif
    
    @if(count($extras) > 0 && !$reservation->extras || $reservation->extras->count() == 0)
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-star"></i>
            <h6>Ekstra Hizmetler</h6>
        </div>
        @foreach($extras as $extra)
        <div class="extra-item">
            <div class="extra-name">{{ $extra['name'] ?? 'Ekstra' }}</div>
            <div class="extra-price">
                {{ number_format($extra['price'] ?? 0, 2, ',', '.') }} ₺
            </div>
        </div>
        @endforeach
    </div>
    @endif
    @endif
    
    <!-- Notlar -->
    @if($reservation->notes)
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-sticky-fill"></i>
            <h6>Notlar</h6>
        </div>
        <div style="color: #374151; font-size: 14px; line-height: 1.6;">
            {{ $reservation->notes }}
        </div>
    </div>
    @endif
    
    <!-- Müşteri Detay Bilgileri -->
    @if($reservation->customer->address)
    <div class="info-card">
        <div class="info-card-header">
            <i class="bi bi-geo-alt"></i>
            <h6>Müşteri Adresi</h6>
        </div>
        <div style="color: #374151; font-size: 14px;">
            {{ $reservation->customer->address }}
        </div>
    </div>
    @endif
    </div>
    
    <!-- SMS Bakiyesi Uyarı Modalı -->
    @if(session('sms_warning'))
    <div class="modal fade" id="smsBalanceWarningModal" tabindex="-1" aria-labelledby="smsBalanceWarningModalLabel" aria-hidden="true" data-bs-backdrop="static">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-warning text-dark">
                    <h5 class="modal-title" id="smsBalanceWarningModalLabel">
                        <i class="bi bi-exclamation-triangle-fill me-2"></i>SMS Bakiyesi Uyarısı
                    </h5>
                </div>
                <div class="modal-body">
                    <p class="mb-3">{{ session('sms_warning') }}</p>
                    <p class="mb-0">SMS göndermeye devam etmek için lütfen bakiye yükleyin.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Daha Sonra</button>
                    <a href="{{ route('sms-packages.index') }}" class="btn btn-primary">
                        <i class="bi bi-currency-dollar me-2"></i>SMS Al
                    </a>
                </div>
            </div>
        </div>
    </div>
    @endif
@endsection

@push('scripts')
@if(session('sms_warning'))
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var smsWarningModal = new bootstrap.Modal(document.getElementById('smsBalanceWarningModal'));
        smsWarningModal.show();
    });
</script>
@endif
@endpush
