<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <title>Kayıt Ol - Salonay</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        @font-face {
            font-family: 'LogoFont';
            src: url('{{ asset("fonts/font.ttf") }}') format('truetype');
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }
        
        html, body {
            height: 100%;
            width: 100%;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            overflow-x: hidden;
        }
        
        body {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 50%, #f472b6 100%);
            min-height: 100vh;
            padding-top: env(safe-area-inset-top);
            padding-bottom: env(safe-area-inset-bottom);
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Animated circles background */
        .bg-circle {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.15);
            animation: float 20s ease-in-out infinite;
        }
        
        .bg-circle-1 {
            width: 300px;
            height: 300px;
            top: -150px;
            right: -150px;
            animation-delay: 0s;
        }
        
        .bg-circle-2 {
            width: 200px;
            height: 200px;
            bottom: -100px;
            left: -100px;
            animation-delay: 5s;
        }
        
        .bg-circle-3 {
            width: 150px;
            height: 150px;
            top: 50%;
            left: 10%;
            animation-delay: 10s;
        }
        
        @keyframes float {
            0%, 100% {
                transform: translate(0, 0) scale(1);
                opacity: 0.3;
            }
            50% {
                transform: translate(50px, -50px) scale(1.1);
                opacity: 0.5;
            }
        }
        
        .register-wrapper {
            width: 100%;
            max-width: 420px;
            padding: 24px;
            position: relative;
            z-index: 10;
        }
        
        .register-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border-radius: 28px;
            padding: 48px 32px;
            box-shadow: 0 25px 50px rgba(236, 72, 153, 0.3), 0 0 0 1px rgba(255, 255, 255, 0.3);
            animation: slideIn 0.5s ease-out;
            max-height: 90vh;
            overflow-y: auto;
        }
        
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(20px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }
        
        .logo-container {
            text-align: center;
            margin-bottom: 32px;
        }
        
        .logo-text {
            font-family: 'LogoFont', 'Poppins', 'Montserrat', 'Inter', sans-serif;
            font-weight: normal;
            font-size: 56px;
            letter-spacing: 3px;
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 30%, #db2777 60%, #be185d 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            text-shadow: 0 4px 20px rgba(236, 72, 153, 0.4), 0 0 40px rgba(236, 72, 153, 0.2);
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            position: relative;
            display: inline-flex;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: logoGradient 3s ease infinite, logoFloat 3s ease-in-out infinite;
            padding: 8px 16px;
            border-radius: 16px;
            overflow: hidden;
            margin-bottom: 20px;
        }
        
        .logo-text::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            transition: left 0.8s ease;
            animation: logoShine 3s ease-in-out infinite;
        }
        
        .logo-text::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(236, 72, 153, 0.8), transparent);
            opacity: 0.8;
            transform: scaleX(0);
            transform-origin: left;
            animation: logoLine 3s ease-in-out infinite;
        }
        
        @keyframes logoGradient {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }
        
        @keyframes logoFloat {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-6px);
            }
        }
        
        @keyframes logoShine {
            0% {
                left: -100%;
            }
            50% {
                left: 100%;
            }
            100% {
                left: 100%;
            }
        }
        
        @keyframes logoLine {
            0%, 100% {
                transform: scaleX(0);
            }
            50% {
                transform: scaleX(1);
            }
        }
        
        .logo-text:hover {
            transform: scale(1.05) translateY(-3px);
            letter-spacing: 4px;
            animation-duration: 1.5s;
        }
        
        .welcome-title {
            font-size: 28px;
            font-weight: 800;
            color: #111827;
            margin-bottom: 8px;
            letter-spacing: -0.5px;
        }
        
        .welcome-subtitle {
            font-size: 15px;
            color: #6b7280;
            font-weight: 500;
        }
        
        .form-container {
            margin-top: 32px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .form-label i {
            color: #ec4899;
            font-size: 18px;
        }
        
        .form-label .required {
            color: #ef4444;
            margin-left: 2px;
        }
        
        .input-container {
            position: relative;
        }
        
        .form-input {
            width: 100%;
            padding: 16px 16px 16px 50px;
            border: 2px solid #e5e7eb;
            border-radius: 14px;
            font-size: 16px;
            background: #ffffff;
            color: #111827;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-family: 'Inter', sans-serif;
            -webkit-appearance: none;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #ec4899;
            box-shadow: 0 0 0 4px rgba(236, 72, 153, 0.1);
            transform: translateY(-1px);
        }
        
        .form-input::placeholder {
            color: #9ca3af;
        }
        
        .input-icon {
            position: absolute;
            left: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: #9ca3af;
            font-size: 20px;
            pointer-events: none;
            transition: color 0.3s ease;
        }
        
        .form-group:focus-within .input-icon {
            color: #ec4899;
        }
        
        .password-toggle-btn {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #9ca3af;
            font-size: 20px;
            cursor: pointer;
            padding: 4px;
            transition: color 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .password-toggle-btn:active {
            color: #ec4899;
        }
        
        .phone-input-group {
            display: flex;
            gap: 10px;
        }
        
        .phone-input-group .input-container {
            flex: 1;
        }
        
        .btn-send-otp {
            padding: 16px 20px;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            color: #ffffff;
            border: none;
            border-radius: 14px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            white-space: nowrap;
            min-width: 110px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3);
        }
        
        .btn-send-otp:active {
            transform: translateY(0);
            box-shadow: 0 2px 8px rgba(236, 72, 153, 0.2);
        }
        
        .btn-send-otp:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .otp-status {
            margin-top: 8px;
            font-size: 13px;
            min-height: 20px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 6px;
        }
        
        .otp-status.success {
            color: #10b981;
        }
        
        .otp-status.error {
            color: #ef4444;
        }
        
        .otp-status i {
            font-size: 16px;
        }
        
        .btn-submit {
            width: 100%;
            padding: 18px;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            color: #ffffff;
            border: none;
            border-radius: 14px;
            font-size: 17px;
            font-weight: 700;
            cursor: pointer;
            margin-top: 8px;
            min-height: 56px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 8px 20px rgba(236, 72, 153, 0.35);
            position: relative;
            overflow: hidden;
        }
        
        .btn-submit::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.25), transparent);
            transition: left 0.6s;
        }
        
        .btn-submit:active::before {
            left: 100%;
        }
        
        .btn-submit:active {
            transform: translateY(0);
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3);
        }
        
        .btn-submit:disabled {
            opacity: 0.7;
            cursor: not-allowed;
            transform: none;
        }
        
        .btn-submit i {
            font-size: 20px;
        }
        
        .error-alert {
            background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
            color: #991b1b;
            padding: 14px 18px;
            border-radius: 12px;
            margin-bottom: 24px;
            font-size: 14px;
            font-weight: 500;
            display: none;
            border: 1px solid #fca5a5;
            animation: shake 0.4s ease;
        }
        
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-8px); }
            75% { transform: translateX(8px); }
        }
        
        .error-alert.show {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .error-alert i {
            font-size: 18px;
        }
        
        .login-link {
            text-align: center;
            margin-top: 32px;
            font-size: 14px;
            color: #6b7280;
        }
        
        .login-link a {
            color: #ec4899;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }
        
        .login-link a:active {
            color: #be185d;
        }
        
        .login-link a i {
            font-size: 14px;
            transition: transform 0.3s ease;
        }
        
        .login-link a:active i {
            transform: translateX(3px);
        }
        
        .loading-spinner {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.95);
            z-index: 9999;
            align-items: center;
            justify-content: center;
            flex-direction: column;
        }
        
        .loading-spinner.show {
            display: flex;
        }
        
        .loading-content {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 20px;
        }
        
        .loading-gif {
            width: 200px;
            height: auto;
            max-height: 200px;
            object-fit: contain;
        }
        
        @media (max-width: 480px) {
            .register-wrapper {
                padding: 16px;
            }
            
            .register-card {
                padding: 36px 24px;
                border-radius: 24px;
            }
            
            .logo-text {
                font-size: 40px;
            }
            
            .welcome-title {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="bg-circle bg-circle-1"></div>
    <div class="bg-circle bg-circle-2"></div>
    <div class="bg-circle bg-circle-3"></div>
    
    <div class="register-wrapper">
        <div class="register-card">
            <div class="logo-container">
                <div class="logo-text">Salonay</div>
                <div class="welcome-title">Hesap Oluştur</div>
                <div class="welcome-subtitle">Yeni hesabınızı oluşturun</div>
            </div>
            
            <div class="error-alert" id="errorAlert">
                <i class="bi bi-exclamation-circle-fill"></i>
                <span id="errorText"></span>
            </div>
            
            <form id="registerForm" class="form-container">
                <div class="form-group">
                    <label class="form-label">
                        <i class="bi bi-person-fill"></i>
                        Ad Soyad <span class="required">*</span>
                    </label>
                    <div class="input-container">
                        <i class="bi bi-person input-icon"></i>
                        <input type="text" name="name" id="name" class="form-input" required autocomplete="name" placeholder="Adınız Soyadınız">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">
                        <i class="bi bi-envelope-fill"></i>
                        E-posta <span class="required">*</span>
                    </label>
                    <div class="input-container">
                        <i class="bi bi-envelope input-icon"></i>
                        <input type="email" name="email" id="email" class="form-input" required autocomplete="email" placeholder="ornek@email.com">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">
                        <i class="bi bi-telephone-fill"></i>
                        Telefon Numarası <span class="required">*</span>
                    </label>
                    <div class="phone-input-group">
                        <div class="input-container" style="flex: 1;">
                            <i class="bi bi-phone input-icon"></i>
                            <input type="tel" name="phone" id="phone" class="form-input" required autocomplete="tel" placeholder="05XX XXX XX XX">
                        </div>
                        <button type="button" class="btn-send-otp" id="sendOtpBtn" onclick="sendOtp()">
                            <i class="bi bi-send"></i> Kod Gönder
                        </button>
                    </div>
                    <div class="otp-status" id="otpStatus"></div>
                </div>
                
                @if(config('app.registration_otp_enabled', false))
                <div class="form-group" id="otpField" style="display: none;">
                    <label class="form-label">
                        <i class="bi bi-shield-check"></i>
                        Doğrulama Kodu <span class="required">*</span>
                    </label>
                    <div class="input-container">
                        <i class="bi bi-key input-icon"></i>
                        <input type="text" name="otp_code" id="otp_code" class="form-input" maxlength="6" placeholder="6 haneli kod">
                    </div>
                </div>
                @endif
                
                <div class="form-group">
                    <label class="form-label">
                        <i class="bi bi-lock-fill"></i>
                        Şifre <span class="required">*</span>
                    </label>
                    <div class="input-container">
                        <i class="bi bi-key input-icon"></i>
                        <input type="password" name="password" id="password" class="form-input" required autocomplete="new-password" placeholder="En az 6 karakter" minlength="6">
                        <button type="button" class="password-toggle-btn" onclick="togglePassword('password')">
                            <i class="bi bi-eye" id="passwordToggleIcon"></i>
                        </button>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">
                        <i class="bi bi-lock-fill"></i>
                        Şifre Tekrar <span class="required">*</span>
                    </label>
                    <div class="input-container">
                        <i class="bi bi-key input-icon"></i>
                        <input type="password" name="password_confirmation" id="password_confirmation" class="form-input" required autocomplete="new-password" placeholder="Şifrenizi tekrar girin">
                        <button type="button" class="password-toggle-btn" onclick="togglePassword('password_confirmation')">
                            <i class="bi bi-eye" id="passwordConfirmationToggleIcon"></i>
                        </button>
                    </div>
                </div>
                
                <button type="submit" class="btn-submit" id="submitBtn">
                    <i class="bi bi-person-plus-fill"></i>
                    <span>Kayıt Ol</span>
                </button>
            </form>
            
            <div class="loading-spinner" id="loadingSpinner">
                <div class="loading-content">
                    <img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" class="loading-gif">
                </div>
            </div>

            <div class="login-link">
                Zaten hesabınız var mı? <a href="{{ route('mobile.login') }}">Giriş Yapın <i class="bi bi-arrow-right"></i></a>
            </div>
        </div>
    </div>

    <script>
        function getCsrfToken() {
            return document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        }
        
        function togglePassword(fieldId) {
            const passwordInput = document.getElementById(fieldId);
            const toggleIcon = document.getElementById(fieldId === 'password' ? 'passwordToggleIcon' : 'passwordConfirmationToggleIcon');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleIcon.classList.remove('bi-eye');
                toggleIcon.classList.add('bi-eye-slash');
            } else {
                passwordInput.type = 'password';
                toggleIcon.classList.remove('bi-eye-slash');
                toggleIcon.classList.add('bi-eye');
            }
        }

        function sendOtp() {
            const phone = document.getElementById('phone').value.trim();
            if (!phone) {
                alert('Lütfen telefon numaranızı giriniz.');
                return;
            }

            const sendBtn = document.getElementById('sendOtpBtn');
            const otpStatus = document.getElementById('otpStatus');
            const otpField = document.getElementById('otpField');
            const originalBtnHtml = sendBtn.innerHTML;
            
            sendBtn.disabled = true;
            sendBtn.innerHTML = '<i class="bi bi-hourglass-split"></i> Gönderiliyor...';
            otpStatus.textContent = '';
            otpStatus.className = 'otp-status';
            
            fetch('{{ route("register.send-otp") }}', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': getCsrfToken(),
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ phone: phone })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    otpStatus.innerHTML = '<i class="bi bi-check-circle-fill"></i> Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                    otpStatus.className = 'otp-status success';
                    if (otpField) {
                        otpField.style.display = 'block';
                        document.getElementById('otp_code').focus();
                    }
                    
                    let countdown = 60;
                    const interval = setInterval(() => {
                        countdown--;
                        sendBtn.innerHTML = `<i class="bi bi-arrow-clockwise"></i> Tekrar (${countdown}s)`;
                        if (countdown <= 0) {
                            clearInterval(interval);
                            sendBtn.disabled = false;
                            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                        }
                    }, 1000);
                } else {
                    otpStatus.innerHTML = '<i class="bi bi-x-circle-fill"></i> ' + (data.message || 'Doğrulama kodu gönderilemedi.');
                    otpStatus.className = 'otp-status error';
                    sendBtn.disabled = false;
                    sendBtn.innerHTML = originalBtnHtml;
                }
            })
            .catch(error => {
                console.error('OTP send error:', error);
                otpStatus.innerHTML = '<i class="bi bi-x-circle-fill"></i> Bağlantı hatası. Lütfen tekrar deneyin.';
                otpStatus.className = 'otp-status error';
                sendBtn.disabled = false;
                sendBtn.innerHTML = originalBtnHtml;
            });
        }

        // OTP kodu sadece rakam girişi
        const otpInput = document.getElementById('otp_code');
        if (otpInput) {
            otpInput.addEventListener('input', function(e) {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
        }

        document.getElementById('registerForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const errorAlert = document.getElementById('errorAlert');
            const errorText = document.getElementById('errorText');
            const submitBtn = document.getElementById('submitBtn');
            const submitBtnSpan = submitBtn.querySelector('span');
            const submitBtnIcon = submitBtn.querySelector('i');
            const loadingSpinner = document.getElementById('loadingSpinner');
            
            errorAlert.classList.remove('show');
            submitBtn.disabled = true;
            submitBtnSpan.textContent = 'Kayıt yapılıyor...';
            submitBtnIcon.className = 'bi bi-hourglass-split';
            loadingSpinner.classList.add('show');
            
            const formData = {
                name: document.getElementById('name').value,
                email: document.getElementById('email').value,
                phone: document.getElementById('phone').value,
                password: document.getElementById('password').value,
                password_confirmation: document.getElementById('password_confirmation').value,
            };
            
            @if(config('app.registration_otp_enabled', false))
            const otpCode = document.getElementById('otp_code')?.value;
            if (otpCode) {
                formData.otp_code = otpCode;
            }
            @endif
            
            try {
                const response = await fetch('{{ route("mobile.register.post") }}', {
                    method: 'POST',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': getCsrfToken(),
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify(formData)
                });
                
                const data = await response.json();
                
                if (data.success) {
                    // Success animation
                    submitBtn.style.background = 'linear-gradient(135deg, #10b981 0%, #059669 100%)';
                    submitBtnSpan.textContent = 'Başarılı!';
                    submitBtnIcon.className = 'bi bi-check-circle-fill';
                    loadingSpinner.classList.remove('show');
                    
                    // Flutter bridge message
                    if (typeof window.FlutterBridge !== 'undefined' && window.FlutterBridge.postMessage) {
                        window.FlutterBridge.postMessage('register_success');
                    } else if (typeof AuthBridge !== 'undefined' && AuthBridge.postMessage) {
                        AuthBridge.postMessage('register_success');
                    } else if (typeof window.AuthBridge !== 'undefined' && window.AuthBridge.postMessage) {
                        window.AuthBridge.postMessage('register_success');
                    } else if (window.flutter_inappwebview && window.flutter_inappwebview.callHandler) {
                        window.flutter_inappwebview.callHandler('AuthBridge', 'register_success');
                    }
                    
                    // Redirect
                    setTimeout(() => {
                        window.location.href = data.redirect || '/admin/mobile/dashboard';
                    }, 500);
                } else {
                    const errorMessage = data.errors 
                        ? (Array.isArray(data.errors) 
                            ? data.errors[0] 
                            : Object.values(data.errors).flat().join(', ')) 
                        : (data.message || 'Kayıt başarısız. Lütfen bilgilerinizi kontrol edin.');
                    
                    errorText.textContent = errorMessage;
                    errorAlert.classList.add('show');
                    submitBtn.disabled = false;
                    submitBtnSpan.textContent = 'Kayıt Ol';
                    submitBtnIcon.className = 'bi bi-person-plus-fill';
                    loadingSpinner.classList.remove('show');
                }
            } catch (error) {
                console.error('Register fetch error:', error);
                errorText.textContent = 'Bağlantı hatası. Lütfen tekrar deneyin.';
                errorAlert.classList.add('show');
                submitBtn.disabled = false;
                submitBtnSpan.textContent = 'Kayıt Ol';
                submitBtnIcon.className = 'bi bi-person-plus-fill';
                loadingSpinner.classList.remove('show');
            }
        });
        
        // FlutterBridge helper
        if (typeof window.FlutterBridge === 'undefined') {
            window.FlutterBridge = {
                postMessage: function(message) {
                    if (typeof AuthBridge !== 'undefined' && AuthBridge.postMessage) {
                        try {
                            AuthBridge.postMessage(message);
                            return true;
                        } catch (e) {}
                    }
                    if (typeof window.AuthBridge !== 'undefined' && window.AuthBridge.postMessage) {
                        try {
                            window.AuthBridge.postMessage(message);
                            return true;
                        } catch (e) {}
                    }
                    if (window.flutter_inappwebview && window.flutter_inappwebview.callHandler) {
                        try {
                            window.flutter_inappwebview.callHandler('AuthBridge', message);
                            return true;
                        } catch (e) {}
                    }
                    return false;
                }
            };
        }
    </script>
</body>
</html>
