@extends('admin.mobile.layouts.app')

@section('title', 'Takvim')

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css" rel="stylesheet">
<style>
    .calendar-page {
        padding-bottom: 20px;
    }
    
    .calendar-header {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        color: white;
        padding: 20px;
        border-radius: 16px;
        margin-bottom: 20px;
    }
    
    .calendar-header h1 {
        font-size: 24px;
        font-weight: 700;
        margin: 0 0 16px 0;
    }
    
    .calendar-controls {
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }
    
    .view-btn {
        padding: 10px 16px;
        background: rgba(255, 255, 255, 0.2);
        color: white;
        border: 1px solid rgba(255, 255, 255, 0.3);
        border-radius: 8px;
        font-size: 13px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .view-btn:active {
        background: rgba(255, 255, 255, 0.3);
        transform: scale(0.95);
    }
    
    .view-btn.active {
        background: white;
        color: #ec4899;
        border-color: white;
    }
    
    .salon-filter {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid rgba(255, 255, 255, 0.3);
        background: rgba(255, 255, 255, 0.15);
        color: white;
        border-radius: 8px;
        font-size: 14px;
        margin-top: 12px;
        -webkit-appearance: none;
    }
    
    .salon-filter::placeholder {
        color: rgba(255, 255, 255, 0.7);
    }
    
    .salon-filter option {
        color: #111827;
    }
    
    .calendar-container {
        background: white;
        border-radius: 16px;
        padding: 16px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #e5e7eb;
        margin-bottom: 20px;
    }
    
    #calendar {
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    }
    
    .fc {
        font-size: 14px;
    }
    
    .fc-toolbar-title {
        font-size: 18px !important;
        font-weight: 700 !important;
        color: #111827 !important;
    }
    
    .fc-button {
        background: #ec4899 !important;
        border: none !important;
        padding: 8px 16px !important;
        border-radius: 8px !important;
        font-size: 13px !important;
        font-weight: 600 !important;
    }
    
    /* Ay değiştirme okları arasına boşluk */
    .fc-toolbar-chunk {
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .fc-prev-button {
        margin-right: 8px !important;
    }
    
    .fc-next-button {
        margin-left: 8px !important;
    }
    
    .fc-today-button {
        margin: 0 8px !important;
    }
    
    /* Liste görünümü */
    .list-view-container {
        display: none;
        background: white;
        border-radius: 16px;
        padding: 16px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #e5e7eb;
        margin-bottom: 20px;
    }
    
    .list-view-container.active {
        display: block;
    }
    
    .list-view-item {
        background: #f9fafb;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 12px;
        border: 1px solid #e5e7eb;
        transition: all 0.2s;
    }
    
    .list-view-item:active {
        transform: translateX(4px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.12);
        border-color: #ec4899;
    }
    
    .list-view-item-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 8px;
    }
    
    .list-view-item-title {
        font-size: 16px;
        font-weight: 700;
        color: #111827;
        margin-bottom: 4px;
    }
    
    .list-view-item-date {
        font-size: 13px;
        color: #6b7280;
        display: flex;
        align-items: center;
        gap: 6px;
    }
    
    .list-view-item-time {
        font-size: 14px;
        color: #ec4899;
        font-weight: 600;
    }
    
    .list-view-item-details {
        font-size: 13px;
        color: #6b7280;
        margin-top: 8px;
    }
    
    .list-view-item-details span {
        display: block;
        margin-bottom: 4px;
    }
    
    .fc-button:active {
        background: #be185d !important;
        transform: scale(0.95);
    }
    
    .fc-button-primary:not(:disabled):active,
    .fc-button-primary:not(:disabled).fc-button-active {
        background: #be185d !important;
    }
    
    .fc-daygrid-day {
        border-color: #e5e7eb !important;
    }
    
    .fc-daygrid-day-number {
        color: #111827 !important;
        font-weight: 600 !important;
        padding: 8px !important;
    }
    
    .fc-day-today {
        background: #fce7f3 !important;
    }
    
    .fc-day-today .fc-daygrid-day-number {
        color: #ec4899 !important;
        font-weight: 700 !important;
    }
    
    .fc-event {
        border-radius: 6px !important;
        padding: 4px 8px !important;
        font-size: 12px !important;
        font-weight: 600 !important;
        border: none !important;
        cursor: pointer;
    }
    
    .fc-event:active {
        opacity: 0.8;
        transform: scale(0.98);
    }
    
    .fc-daygrid-event {
        margin: 2px 0 !important;
    }
    
    .new-reservation-btn {
        position: fixed;
        bottom: 80px;
        right: 16px;
        width: 56px !important;
        height: 56px !important;
        min-width: 56px !important;
        max-width: 56px !important;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        color: white;
        border: none;
        border-radius: 50%;
        font-size: 24px;
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.4);
        cursor: pointer;
        transition: all 0.2s;
        z-index: 999;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0 !important;
        margin: 0 !important;
    }
    
    .new-reservation-btn:active {
        transform: scale(0.9);
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3);
    }
    
    .stats-summary {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 12px;
        margin-bottom: 20px;
    }
    
    .stat-mini {
        background: white;
        border-radius: 12px;
        padding: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #e5e7eb;
        text-align: center;
    }
    
    .stat-mini-value {
        font-size: 20px;
        font-weight: 700;
        color: #111827;
        margin-bottom: 4px;
    }
    
    .stat-mini-label {
        font-size: 11px;
        color: #6b7280;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
</style>
@endpush

@section('content')
<div class="calendar-page">
    <div class="calendar-header">
        <h1>Randevu Takvimi</h1>
        <div class="calendar-controls">
            <button class="view-btn active" onclick="changeView('dayGridMonth', this)">Ay</button>
            <button class="view-btn" onclick="changeView('timeGridWeek', this)">Hafta</button>
            <button class="view-btn" onclick="changeView('timeGridDay', this)">Gün</button>
            <button class="view-btn" onclick="toggleListView(this)">Liste</button>
        </div>
        <select id="salonFilter" class="salon-filter" onchange="filterBySalon()">
            <option value="">Tüm Salonlar</option>
            @foreach($salons ?? [] as $salon)
                <option value="{{ $salon->id }}">{{ $salon->name }}</option>
            @endforeach
        </select>
    </div>
    
    <!-- İstatistikler -->
    <div class="stats-summary">
        <div class="stat-mini">
            <div class="stat-mini-value" id="todayCount">0</div>
            <div class="stat-mini-label">Bugün</div>
        </div>
        <div class="stat-mini">
            <div class="stat-mini-value" id="weekCount">0</div>
            <div class="stat-mini-label">Bu Hafta</div>
        </div>
    </div>
    
    <!-- Liste Görünümü -->
    <div class="list-view-container" id="listViewContainer">
        <div id="listViewContent">
            <!-- Liste içeriği JavaScript ile doldurulacak -->
        </div>
    </div>
    
    <!-- Takvim -->
    <div class="calendar-container" id="calendarContainer">
        <div id="calendar"></div>
    </div>
    
    <!-- Yeni Randevu Butonu -->
    <a href="javascript:void(0)" onclick="openNewReservationFromCalendar()" class="new-reservation-btn">
        <i class="bi bi-plus"></i>
    </a>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/locales/tr.js"></script>
<script>
    let calendar;
    let currentView = 'dayGridMonth';
    let selectedSalonId = '';
    
    let isListView = false;
    let allEvents = [];
    
    document.addEventListener('DOMContentLoaded', function() {
        const calendarEl = document.getElementById('calendar');
        
        calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            locale: 'tr',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: ''
            },
            height: 'auto',
            events: function(fetchInfo, successCallback, failureCallback) {
                const start = fetchInfo.startStr;
                const end = fetchInfo.endStr;
                const salonId = selectedSalonId || '';
                
                fetch(`{{ route('mobile.calendar.feed') }}?start=${start}&end=${end}&salon_id=${salonId}`, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    credentials: 'same-origin'
                })
                .then(response => response.json())
                .then(data => {
                    allEvents = data; // Tüm eventleri sakla
                    successCallback(data);
                    updateStats(data);
                    // Liste görünümü aktifse güncelle
                    if (isListView) {
                        renderListView();
                    }
                })
                .catch(error => {
                    console.error('Calendar feed error:', error);
                    failureCallback(error);
                });
            },
            eventClick: function(info) {
                if (info.event.url) {
                    window.location.href = info.event.url;
                }
            },
            dateClick: function(info) {
                // Tıklanan günün tarihini al
                const clickedDate = info.dateStr; // YYYY-MM-DD formatında
                // Desktop'tan çağrılıyorsa modal aç, mobil'de sayfa aç
                const isDesktop = window.innerWidth > 1024;
                if (isDesktop && typeof openNewReservationModal === 'function') {
                    openNewReservationModal(clickedDate);
                } else {
                    window.location.href = '{{ route("mobile.appointments.create") }}?date=' + clickedDate;
                }
            },
            dayMaxEvents: 3,
            moreLinkClick: 'popover',
            eventDisplay: 'block',
            eventTimeFormat: {
                hour: '2-digit',
                minute: '2-digit',
                hour12: false
            }
        });
        
        calendar.render();
    });
    
    function changeView(view, buttonElement) {
        // Liste görünümünden çık
        if (isListView) {
            isListView = false;
            document.getElementById('listViewContainer').classList.remove('active');
            document.getElementById('calendarContainer').style.display = 'block';
        }
        
        currentView = view;
        calendar.changeView(view);
        
        // Update active button
        document.querySelectorAll('.view-btn').forEach(btn => {
            btn.classList.remove('active');
        });
        if (buttonElement) {
            buttonElement.classList.add('active');
        } else {
            // Fallback: İlk butonu aktif yap
            const buttons = document.querySelectorAll('.view-btn');
            if (buttons.length > 0) {
                buttons[0].classList.add('active');
            }
        }
    }
    
    function filterBySalon() {
        selectedSalonId = document.getElementById('salonFilter').value;
        calendar.refetchEvents();
    }
    
    function updateStats(events) {
        const today = new Date().toISOString().split('T')[0];
        const todayEvents = events.filter(e => e.start.startsWith(today));
        
        const weekStart = new Date();
        weekStart.setDate(weekStart.getDate() - weekStart.getDay());
        const weekEnd = new Date(weekStart);
        weekEnd.setDate(weekStart.getDate() + 6);
        
        const weekEvents = events.filter(e => {
            const eventDate = new Date(e.start);
            return eventDate >= weekStart && eventDate <= weekEnd;
        });
        
        document.getElementById('todayCount').textContent = todayEvents.length;
        document.getElementById('weekCount').textContent = weekEvents.length;
    }
    
    function toggleListView(buttonElement) {
        isListView = !isListView;
        
        if (isListView) {
            // Liste görünümüne geç
            document.getElementById('listViewContainer').classList.add('active');
            document.getElementById('calendarContainer').style.display = 'none';
            buttonElement.classList.add('active');
            document.querySelectorAll('.view-btn').forEach(btn => {
                if (btn !== buttonElement && btn.textContent !== 'Liste') {
                    btn.classList.remove('active');
                }
            });
            renderListView();
        } else {
            // Takvim görünümüne geç
            document.getElementById('listViewContainer').classList.remove('active');
            document.getElementById('calendarContainer').style.display = 'block';
            buttonElement.classList.remove('active');
            // İlk butonu aktif yap
            const firstBtn = document.querySelector('.view-btn');
            if (firstBtn && firstBtn.textContent !== 'Liste') {
                firstBtn.classList.add('active');
            }
            // Takvimi yenile
            if (calendar) {
                calendar.refetchEvents();
            }
        }
    }
    
    function renderListView() {
        const listViewContent = document.getElementById('listViewContent');
        
        if (!allEvents || allEvents.length === 0) {
            listViewContent.innerHTML = '<div style="text-align: center; padding: 40px; color: #9ca3af;"><i class="bi bi-calendar-x" style="font-size: 48px; opacity: 0.5; margin-bottom: 16px;"></i><div style="font-size: 16px; font-weight: 600;">Henüz randevu yok</div></div>';
            return;
        }
        
        // Tarihe göre sırala
        const sortedEvents = [...allEvents].sort((a, b) => {
            return new Date(a.start) - new Date(b.start);
        });
        
        let html = '';
        sortedEvents.forEach(event => {
            const startDate = new Date(event.start);
            const dateStr = startDate.toLocaleDateString('tr-TR', { 
                day: 'numeric', 
                month: 'long', 
                year: 'numeric',
                weekday: 'long'
            });
            
            // Time string'i düzelt
            let timeStr = '';
            if (event.extendedProps?.time) {
                timeStr = event.extendedProps.time;
            } else if (event.start) {
                const time = new Date(event.start);
                timeStr = time.toLocaleTimeString('tr-TR', { 
                    hour: '2-digit', 
                    minute: '2-digit',
                    hour12: false
                });
            }
            
            html += `
                <div class="list-view-item" ${event.url ? `onclick="window.location.href='${event.url}'" style="cursor: pointer;"` : ''}>
                    <div class="list-view-item-header">
                        <div>
                            <div class="list-view-item-title">${event.title || 'Randevu'}</div>
                            <div class="list-view-item-date">
                                <i class="bi bi-calendar3"></i> ${dateStr}
                            </div>
                        </div>
                        ${timeStr ? `
                        <div class="list-view-item-time">
                            <i class="bi bi-clock"></i> ${timeStr}
                        </div>
                        ` : ''}
                    </div>
                    ${event.extendedProps?.customer ? `
                        <div class="list-view-item-details">
                            <span><i class="bi bi-person"></i> ${event.extendedProps.customer}</span>
                        </div>
                    ` : ''}
                    ${event.extendedProps?.salon ? `
                        <div class="list-view-item-details">
                            <span><i class="bi bi-building"></i> ${event.extendedProps.salon}</span>
                        </div>
                    ` : ''}
                </div>
            `;
        });
        
        listViewContent.innerHTML = html;
    }
    
    // Desktop'tan çağrıldığında yeni randevu modal aç
    function openNewReservationFromCalendar() {
        const isDesktop = window.innerWidth > 1024;
        if (isDesktop && typeof openNewReservationModal === 'function') {
            openNewReservationModal();
        } else {
            window.location.href = '{{ route("mobile.appointments.create") }}';
        }
    }
</script>
@endpush

