<nav class="bottom-nav">
    <a href="{{ route('mobile.dashboard') }}" class="nav-item {{ request()->is('admin/mobile/dashboard') || request()->is('admin/mobile') ? 'active' : '' }}">
        <div class="nav-item-icon"><i class="bi bi-house-door-fill"></i></div>
        <div class="nav-item-label">Anasayfa</div>
    </a>
    <a href="{{ route('mobile.appointments.index') }}" class="nav-item {{ request()->is('admin/mobile/appointments*') ? 'active' : '' }}">
        <div class="nav-item-icon"><i class="bi bi-calendar-check-fill"></i></div>
        <div class="nav-item-label">Randevular</div>
    </a>
    <a href="{{ route('mobile.calendar.index') }}" class="nav-item {{ request()->is('admin/mobile/calendar*') ? 'active' : '' }}">
        <div class="nav-item-icon"><i class="bi bi-calendar-week-fill"></i></div>
        <div class="nav-item-label">Takvim</div>
    </a>
    <a href="{{ route('mobile.accounting.index') }}" class="nav-item {{ request()->is('admin/mobile/accounting*') ? 'active' : '' }}">
        <div class="nav-item-icon"><i class="bi bi-cash-stack"></i></div>
        <div class="nav-item-label">Kasa</div>
    </a>
    <div class="nav-item nav-menu-trigger {{ request()->is('admin/mobile/settings*') ? 'active' : '' }}" onclick="toggleSettingsMenu(event)">
        <div class="nav-item-icon"><i class="bi bi-list"></i></div>
        <div class="nav-item-label">Menü</div>
    </div>
</nav>

<!-- Settings Menu Dropdown -->
<div class="settings-menu-overlay" id="settingsMenuOverlay" onclick="closeSettingsMenu()"></div>
<div class="settings-menu" id="settingsMenu">
    <div class="settings-menu-header">
        <h3>Menü</h3>
        <button type="button" class="settings-menu-close" onclick="closeSettingsMenu()">
            <i class="bi bi-x-lg"></i>
        </button>
    </div>
    <div class="settings-menu-content">
        <a href="{{ route('mobile.settings.profile') }}" class="settings-menu-item" onclick="closeSettingsMenu()">
            <div class="settings-menu-item-icon"><i class="bi bi-person-circle"></i></div>
            <div class="settings-menu-item-label">Profil</div>
            <i class="bi bi-chevron-right"></i>
        </a>
        <a href="{{ route('mobile.customers.index') }}" class="settings-menu-item" onclick="closeSettingsMenu()">
            <div class="settings-menu-item-icon"><i class="bi bi-people"></i></div>
            <div class="settings-menu-item-label">Müşteriler</div>
            <i class="bi bi-chevron-right"></i>
        </a>
        <a href="{{ route('mobile.settings.invoices.index') }}" class="settings-menu-item" onclick="closeSettingsMenu()">
            <div class="settings-menu-item-icon"><i class="bi bi-receipt"></i></div>
            <div class="settings-menu-item-label">Faturalar</div>
            <i class="bi bi-chevron-right"></i>
        </a>
        @if(env('WPDESTEK'))
        <a href="{{ env('WPDESTEK') }}" target="_blank" class="settings-menu-item" onclick="closeSettingsMenu()">
            <div class="settings-menu-item-icon"><i class="bi bi-whatsapp"></i></div>
            <div class="settings-menu-item-label">WhatsApp Destek</div>
            <i class="bi bi-chevron-right"></i>
        </a>
        @endif
        <a href="{{ route('mobile.logout.get') }}" class="settings-menu-item settings-menu-item-danger" onclick="closeSettingsMenu()">
            <div class="settings-menu-item-icon"><i class="bi bi-box-arrow-right"></i></div>
            <div class="settings-menu-item-label">Çıkış Yap</div>
            <i class="bi bi-chevron-right"></i>
        </a>
    </div>
</div>

<script>
function toggleSettingsMenu(event) {
    event.preventDefault();
    event.stopPropagation();
    const menu = document.getElementById('settingsMenu');
    const overlay = document.getElementById('settingsMenuOverlay');
    
    if (menu.classList.contains('active')) {
        closeSettingsMenu();
    } else {
        menu.classList.add('active');
        overlay.classList.add('active');
        document.body.style.overflow = 'hidden';
    }
}

function closeSettingsMenu() {
    const menu = document.getElementById('settingsMenu');
    const overlay = document.getElementById('settingsMenuOverlay');
    
    menu.classList.remove('active');
    overlay.classList.remove('active');
    document.body.style.overflow = '';
}

// Overlay'e tıklandığında menüyü kapat
document.getElementById('settingsMenuOverlay').addEventListener('click', closeSettingsMenu);
</script>
