@extends('admin.mobile.layouts.app')

@section('title', 'Müşteri Düzenle')

@push('styles')
<style>
    .customer-edit-page {
        padding-bottom: 20px;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
    }
    
    .form-card {
        background: white;
        border-radius: 16px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #e5e7eb;
        margin-bottom: 20px;
    }
    
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        font-size: 14px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 8px;
    }
    
    .form-control {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 16px;
        background: white;
        -webkit-appearance: none;
        transition: all 0.2s;
    }
    
    .form-control:focus {
        outline: none;
        border-color: #10b981;
        box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
    }
    
    .form-control.is-invalid {
        border-color: #dc3545;
    }
    
    .invalid-feedback {
        display: block;
        color: #dc3545;
        font-size: 13px;
        margin-top: 4px;
    }
    
    .btn {
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        border: none;
        min-height: 44px;
        cursor: pointer;
        transition: all 0.2s;
        width: 100%;
    }
    
    .btn-primary {
        background: #10b981;
        color: white;
    }
    
    .btn-primary:active {
        background: #047857;
        transform: scale(0.98);
    }
    
    .btn-secondary {
        background: #f3f4f6;
        color: #111827;
        margin-top: 12px;
    }
    
    .btn-secondary:active {
        background: #e5e7eb;
        transform: scale(0.98);
    }
    
    .alert {
        padding: 12px 16px;
        border-radius: 8px;
        margin-bottom: 16px;
        font-size: 14px;
    }
    
    .alert-success {
        background: #d1fae5;
        color: #065f46;
    }
    
    .alert-danger {
        background: #fee2e2;
        color: #991b1b;
    }
    
    .required {
        color: #dc3545;
    }
</style>
@endpush

@section('content')
<div class="customer-edit-page">
    <div class="page-header">
        <h1 class="page-title">Müşteri Düzenle</h1>
        <a href="{{ route('mobile.customers.show', $customer->id) }}" class="back-button">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    @if(session('success'))
        <div class="alert alert-success">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-circle"></i> {{ session('error') }}
        </div>
    @endif
    
    <form method="POST" action="{{ route('mobile.customers.update', $customer->id) }}">
        @csrf
        @method('PUT')
        
        <div class="form-card">
            <div class="form-group">
                <label class="form-label">Ad Soyad <span class="required">*</span></label>
                <input type="text" 
                       name="name" 
                       class="form-control @error('name') is-invalid @enderror" 
                       value="{{ old('name', $customer->name) }}" 
                       required>
                @error('name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="form-group">
                <label class="form-label">Telefon <span class="required">*</span></label>
                <input type="tel" 
                       name="phone" 
                       class="form-control @error('phone') is-invalid @enderror" 
                       value="{{ old('phone', $customer->phone) }}" 
                       required>
                @error('phone')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="form-group">
                <label class="form-label">E-posta</label>
                <input type="email" 
                       name="email" 
                       class="form-control @error('email') is-invalid @enderror" 
                       value="{{ old('email', $customer->email ?? '') }}">
                @error('email')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="form-group">
                <label class="form-label">Adres</label>
                <textarea name="address" 
                          class="form-control @error('address') is-invalid @enderror" 
                          rows="3">{{ old('address', $customer->address ?? '') }}</textarea>
                @error('address')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="form-group">
                <label class="form-label">Notlar</label>
                <textarea name="notes" 
                          class="form-control @error('notes') is-invalid @enderror" 
                          rows="3">{{ old('notes', $customer->notes ?? '') }}</textarea>
                @error('notes')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-check-circle"></i> Güncelle
            </button>
            
            <a href="{{ route('mobile.customers.show', $customer->id) }}" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> İptal
            </a>
        </div>
    </form>
</div>
@endsection

