@extends('admin.mobile.layouts.app')

@section('title', 'Müşteriler')

@push('styles')
<style>
    .customer-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }
    
    .back-button {
        background: #e5e7eb;
        color: #4b5563;
        padding: 8px 12px;
        border-radius: 8px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
    }
    
    .back-button:active {
        background: #d1d5db;
        transform: scale(0.98);
    }
    
    .add-customer-btn {
        background: #10b981;
        color: white;
        border: none;
        padding: 10px 16px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
    }
    
    .add-customer-btn:active {
        background: #047857;
        transform: scale(0.98);
    }
    
    .modal-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        z-index: 1000;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }
    
    .modal-overlay.active {
        display: flex;
    }
    
    .modal-content {
        background: white;
        border-radius: 16px;
        width: 100%;
        max-width: 400px;
        max-height: 90vh;
        overflow-y: auto;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
    }
    
    .modal-header {
        padding: 20px;
        border-bottom: 1px solid #e5e7eb;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .modal-title {
        font-size: 20px;
        font-weight: 700;
        color: #111827;
    }
    
    .modal-close {
        background: none;
        border: none;
        font-size: 24px;
        color: #6b7280;
        cursor: pointer;
        padding: 0;
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 8px;
        transition: all 0.2s;
    }
    
    .modal-close:active {
        background: #f3f4f6;
    }
    
    .modal-body {
        padding: 20px;
    }
    
    .form-group {
        margin-bottom: 16px;
    }
    
    .form-label {
        display: block;
        font-size: 14px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 6px;
    }
    
    .form-control {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 16px;
        background: white;
        transition: all 0.2s;
    }
    
    .form-control:focus {
        outline: none;
        border-color: #10b981;
        box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
    }
    
    .modal-footer {
        padding: 20px;
        border-top: 1px solid #e5e7eb;
        display: flex;
        gap: 12px;
    }
    
    .btn {
        flex: 1;
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
        min-height: 44px;
    }
    
    .btn-primary {
        background: #10b981;
        color: white;
    }
    
    .btn-primary:active {
        background: #047857;
        transform: scale(0.98);
    }
    
    .btn-secondary {
        background: #f3f4f6;
        color: #111827;
    }
    
    .btn-secondary:active {
        background: #e5e7eb;
        transform: scale(0.98);
    }
    
    .alert {
        padding: 12px 16px;
        border-radius: 8px;
        margin-bottom: 16px;
        font-size: 14px;
    }
    
    .alert-success {
        background: #d1fae5;
        color: #065f46;
    }
    
    .alert-danger {
        background: #fee2e2;
        color: #991b1b;
    }
</style>
@endpush

@section('content')
<div class="customers">
    <div class="customer-header">
        <div style="display: flex; align-items: center; gap: 12px;">
            <a href="{{ route('mobile.settings.index') }}" class="back-button">
                <i class="bi bi-arrow-left"></i> Geri
            </a>
            <h1 style="font-size: 24px; font-weight: 700; color: #333; margin: 0;">Müşteriler</h1>
        </div>
        <button type="button" class="add-customer-btn" onclick="openCustomerModal()">
            <i class="bi bi-plus-circle"></i> Yeni Müşteri
        </button>
    </div>
    
    @if(session('success'))
        <div class="alert alert-success">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-circle"></i> {{ session('error') }}
        </div>
    @endif
    
    <div class="form-group" style="margin-bottom: 20px;">
        <input type="text" id="searchInput" class="form-control" placeholder="Müşteri ara..." style="padding: 12px 16px;">
    </div>
    
    @if($customers->count() > 0)
        <div class="list" id="customerList">
            @foreach($customers as $customer)
            <a href="{{ route('mobile.customers.show', $customer->id) }}" class="list-item customer-item" data-name="{{ strtolower($customer->name) }}" data-phone="{{ $customer->phone }}">
                <div class="list-item-content">
                    <div class="list-item-title">{{ $customer->name }}</div>
                    <div class="list-item-subtitle">{{ $customer->phone }}</div>
                </div>
                <div class="list-item-action">›</div>
            </a>
            @endforeach
        </div>
        
        <div style="margin-top: 20px; text-align: center;">
            {{ $customers->links() }}
        </div>
    @else
        <div class="empty-state">
            <div class="empty-state-icon">👥</div>
            <div class="empty-state-text">Henüz müşteri yok</div>
        </div>
    @endif
</div>

<!-- Müşteri Ekleme Modal -->
<div class="modal-overlay" id="customerModal">
    <div class="modal-content">
        <div class="modal-header">
            <h2 class="modal-title">Yeni Müşteri Ekle</h2>
            <button type="button" class="modal-close" onclick="closeCustomerModal()">&times;</button>
        </div>
        <form id="customerForm" onsubmit="submitCustomerForm(event)">
            <div class="modal-body">
                <div id="customerFormErrors" style="display: none;"></div>
                
                <div class="form-group">
                    <label class="form-label">Ad Soyad <span style="color: #dc3545;">*</span></label>
                    <input type="text" name="name" class="form-control" required placeholder="Müşteri adı">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Telefon <span style="color: #dc3545;">*</span></label>
                    <input type="tel" name="phone" class="form-control" required placeholder="05XX XXX XX XX">
                </div>
                
                <div class="form-group">
                    <label class="form-label">E-posta</label>
                    <input type="email" name="email" class="form-control" placeholder="ornek@email.com">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Adres</label>
                    <textarea name="address" class="form-control" rows="3" placeholder="Müşteri adresi"></textarea>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Notlar</label>
                    <textarea name="notes" class="form-control" rows="3" placeholder="Müşteri hakkında notlar"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeCustomerModal()">İptal</button>
                <button type="submit" class="btn btn-primary" id="customerSubmitBtn">
                    <i class="bi bi-check-circle"></i> Kaydet
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    function openCustomerModal() {
        document.getElementById('customerModal').classList.add('active');
        document.getElementById('customerForm').reset();
        document.getElementById('customerFormErrors').style.display = 'none';
    }
    
    function closeCustomerModal() {
        document.getElementById('customerModal').classList.remove('active');
        document.getElementById('customerForm').reset();
        document.getElementById('customerFormErrors').style.display = 'none';
    }
    
    function submitCustomerForm(e) {
        e.preventDefault();
        const form = document.getElementById('customerForm');
        const submitBtn = document.getElementById('customerSubmitBtn');
        const errorsDiv = document.getElementById('customerFormErrors');
        
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i> Kaydediliyor...';
        errorsDiv.style.display = 'none';
        
        const formData = new FormData(form);
        
        fetch('{{ route("mobile.customers.store") }}', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                closeCustomerModal();
                location.reload();
            } else {
                let errorHtml = '<div class="alert alert-danger"><ul style="margin: 0; padding-left: 20px;">';
                if (data.errors) {
                    Object.values(data.errors).forEach(error => {
                        if (Array.isArray(error)) {
                            error.forEach(msg => errorHtml += '<li>' + msg + '</li>');
                        } else {
                            errorHtml += '<li>' + error + '</li>';
                        }
                    });
                } else if (data.message) {
                    errorHtml += '<li>' + data.message + '</li>';
                }
                errorHtml += '</ul></div>';
                errorsDiv.innerHTML = errorHtml;
                errorsDiv.style.display = 'block';
                submitBtn.disabled = false;
                submitBtn.innerHTML = '<i class="bi bi-check-circle"></i> Kaydet';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            errorsDiv.innerHTML = '<div class="alert alert-danger">Bir hata oluştu. Lütfen tekrar deneyin.</div>';
            errorsDiv.style.display = 'block';
            submitBtn.disabled = false;
            submitBtn.innerHTML = '<i class="bi bi-check-circle"></i> Kaydet';
        });
    }
    
    // Modal dışına tıklanınca kapat
    document.getElementById('customerModal').addEventListener('click', function(e) {
        if (e.target === this) {
            closeCustomerModal();
        }
    });
    
    // Simple search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase();
        const items = document.querySelectorAll('.customer-item');
        
        items.forEach(item => {
            const name = item.dataset.name;
            const phone = item.dataset.phone;
            
            if (name.includes(searchTerm) || phone.includes(searchTerm)) {
                item.style.display = 'flex';
            } else {
                item.style.display = 'none';
            }
        });
    });
</script>
@endsection

