@extends('admin.mobile.layouts.app')

@section('title', 'Müşteri Detayı')

@push('styles')
<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        padding: 0 4px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: var(--text-primary);
        margin: 0;
    }
    
    .header-actions {
        display: flex;
        gap: 8px;
        align-items: center;
    }
    
    .btn-edit {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        color: white;
        padding: 10px 16px;
        border-radius: 10px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.25);
        transition: all 0.2s;
    }
    
    .btn-edit:active {
        transform: scale(0.97);
        box-shadow: 0 2px 6px rgba(236, 72, 153, 0.3);
    }
    
    .btn-back {
        background: var(--bg-light);
        color: var(--text-secondary);
        padding: 10px 14px;
        border-radius: 10px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        border: 1px solid var(--border-color);
        transition: all 0.2s;
    }
    
    .btn-back:active {
        background: #e5e7eb;
        transform: scale(0.97);
    }
    
    .customer-header-card {
        text-align: center;
        padding: 24px 18px;
    }
    
    .customer-avatar {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 700;
        font-size: 36px;
        margin: 0 auto 16px;
        box-shadow: 0 8px 24px rgba(0,0,0,0.15);
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        position: relative;
        overflow: hidden;
    }
    
    .customer-avatar::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    }
    
    .customer-name {
        font-size: 22px;
        font-weight: 700;
        color: var(--text-primary);
        margin-bottom: 20px;
    }
    
    .info-grid {
        display: grid;
        gap: 0;
    }
    
    .info-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 14px 0;
        border-bottom: 1px solid var(--border-color);
        transition: background 0.2s;
    }
    
    .info-item:last-child {
        border-bottom: none;
    }
    
    .info-item:active {
        background: var(--bg-light);
        margin: 0 -18px;
        padding-left: 18px;
        padding-right: 18px;
    }
    
    .info-label {
        font-size: 14px;
        color: var(--text-secondary);
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .info-value {
        font-size: 15px;
        color: var(--text-primary);
        font-weight: 500;
        text-align: right;
        max-width: 60%;
        word-break: break-word;
    }
    
    .info-value a {
        color: var(--primary-color);
        text-decoration: none;
    }
    
    .info-value a:active {
        opacity: 0.8;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 12px;
        margin-bottom: 20px;
    }
    
    .stat-card-mini {
        background: linear-gradient(135deg, rgba(236, 72, 153, 0.1) 0%, rgba(190, 24, 93, 0.05) 100%);
        border-radius: 12px;
        padding: 16px;
        border: 1px solid rgba(236, 72, 153, 0.15);
    }
    
    .stat-label-mini {
        font-size: 12px;
        color: var(--text-secondary);
        font-weight: 600;
        margin-bottom: 8px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .stat-value-mini {
        font-size: 20px;
        font-weight: 700;
        color: var(--primary-color);
    }
    
    .btn-payment {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        color: white;
        padding: 16px 24px;
        border-radius: 12px;
        font-size: 16px;
        font-weight: 600;
        text-decoration: none;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
        width: 100%;
        margin-bottom: 20px;
        box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);
    }
    
    .btn-payment:active {
        transform: scale(0.98);
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.4);
    }
    
    .section-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 16px;
    }
    
    .section-title {
        font-size: 18px;
        font-weight: 700;
        color: var(--text-primary);
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .section-count {
        background: var(--bg-light);
        color: var(--text-secondary);
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 13px;
        font-weight: 600;
    }
    
    .reservation-card {
        background: white;
        border-radius: 14px;
        padding: 16px;
        margin-bottom: 12px;
        border: 1px solid var(--border-color);
        border-left: 4px solid var(--primary-color);
        transition: all 0.2s;
        text-decoration: none;
        color: inherit;
        display: block;
    }
    
    .reservation-card:active {
        transform: translateX(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    
    .reservation-card-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 12px;
    }
    
    .reservation-date-time {
        flex: 1;
    }
    
    .reservation-date {
        font-size: 17px;
        font-weight: 700;
        color: var(--text-primary);
        margin-bottom: 4px;
    }
    
    .reservation-time {
        font-size: 13px;
        color: var(--text-secondary);
        display: flex;
        align-items: center;
        gap: 6px;
    }
    
    .status-badge {
        padding: 6px 12px;
        border-radius: 8px;
        font-size: 12px;
        font-weight: 600;
        white-space: nowrap;
    }
    
    .status-confirmed {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        color: white;
    }
    
    .status-open {
        background: #fef3c7;
        color: #92400e;
    }
    
    .status-cancelled {
        background: #fee2e2;
        color: #991b1b;
    }
    
    .status-completed {
        background: #dbeafe;
        color: #1e40af;
    }
    
    .reservation-details-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
        padding-top: 12px;
        border-top: 1px solid var(--bg-light);
    }
    
    .detail-item {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 13px;
        color: var(--text-secondary);
    }
    
    .detail-item i {
        color: var(--primary-color);
        font-size: 14px;
    }
    
    .transaction-card {
        background: white;
        border-radius: 14px;
        padding: 16px;
        margin-bottom: 12px;
        border: 1px solid var(--border-color);
        border-left: 4px solid;
        transition: all 0.2s;
    }
    
    .transaction-card.income {
        border-left-color: var(--primary-color);
    }
    
    .transaction-card.expense {
        border-left-color: var(--danger-color);
    }
    
    .transaction-card-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 8px;
    }
    
    .transaction-info {
        flex: 1;
    }
    
    .transaction-date {
        font-size: 13px;
        color: var(--text-secondary);
        display: flex;
        align-items: center;
        gap: 6px;
        margin-bottom: 4px;
    }
    
    .transaction-desc {
        font-size: 14px;
        color: var(--text-primary);
        font-weight: 500;
    }
    
    .transaction-amount {
        font-size: 18px;
        font-weight: 700;
        white-space: nowrap;
    }
    
    .transaction-amount.income {
        color: var(--primary-color);
    }
    
    .transaction-amount.expense {
        color: var(--danger-color);
    }
    
    .transaction-footer {
        margin-top: 12px;
        padding-top: 12px;
        border-top: 1px solid var(--bg-light);
    }
    
    .debt-info {
        padding: 10px;
        background: #fef3c7;
        border-radius: 8px;
        font-size: 12px;
        color: #92400e;
        margin-bottom: 8px;
    }
    
    .empty-state {
        text-align: center;
        padding: 40px 20px;
        color: var(--text-secondary);
    }
    
    .empty-state-icon {
        font-size: 48px;
        color: var(--border-color);
        margin-bottom: 12px;
    }
    
    .empty-state-text {
        font-size: 15px;
        font-weight: 500;
    }
    
    .balance-badge {
        padding: 6px 12px;
        border-radius: 8px;
        font-size: 13px;
        font-weight: 600;
    }
    
    .balance-positive {
        background: #fef3c7;
        color: #92400e;
    }
    
    .balance-zero {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        color: white;
    }
    
    .balance-negative {
        background: #fce7f3;
        color: var(--primary-color);
    }
</style>
@endpush

@section('content')
<div class="content">
    <!-- Page Header -->
    <div class="page-header">
        <h1 class="page-title">Müşteri Detayı</h1>
        <div class="header-actions">
            <a href="{{ route('mobile.customers.edit', $customer->id) }}" class="btn-edit">
                <i class="bi bi-pencil"></i> Düzenle
            </a>
            <a href="{{ route('mobile.customers.index') }}" class="btn-back">
                <i class="bi bi-arrow-left"></i>
            </a>
        </div>
    </div>
    
    <!-- Customer Info Card -->
    <div class="card">
        <div class="customer-header-card">
            <div class="customer-avatar" style="background: linear-gradient(135deg, {{ $customer->avatar_color ?? '#ec4899' }} 0%, {{ $customer->avatar_color ?? '#be185d' }} 100%);">
                {{ $customer->initials ?? strtoupper(substr($customer->name, 0, 2)) }}
            </div>
            <h2 class="customer-name">{{ $customer->name }}</h2>
            
            <div class="info-grid">
                <div class="info-item">
                    <span class="info-label">
                        <i class="bi bi-telephone"></i> Telefon
                    </span>
                    <span class="info-value">
                        <a href="tel:{{ $customer->phone }}">{{ $customer->phone ?? '-' }}</a>
                    </span>
                </div>
                
                @if($customer->email)
                <div class="info-item">
                    <span class="info-label">
                        <i class="bi bi-envelope"></i> E-posta
                    </span>
                    <span class="info-value">
                        <a href="mailto:{{ $customer->email }}">{{ $customer->email }}</a>
                    </span>
                </div>
                @endif
                
                <div class="info-item">
                    <span class="info-label">
                        <i class="bi bi-wallet2"></i> Bakiye
                    </span>
                    <span class="info-value">
                        @if($customer->balance > 0)
                            <span class="balance-badge balance-positive">{{ number_format($customer->balance, 2, ',', '.') }} ₺</span>
                        @elseif($customer->balance < 0)
                            <span class="balance-badge balance-negative">{{ number_format(abs($customer->balance), 2, ',', '.') }} ₺</span>
                        @else
                            <span class="balance-badge balance-zero">0,00 ₺</span>
                        @endif
                    </span>
                </div>
                
                @if($customer->birth_date)
                <div class="info-item">
                    <span class="info-label">
                        <i class="bi bi-calendar3"></i> Doğum Tarihi
                    </span>
                    <span class="info-value">{{ \Carbon\Carbon::parse($customer->birth_date)->format('d.m.Y') }}</span>
                </div>
                @endif
                
                @if($customer->address)
                <div class="info-item">
                    <span class="info-label">
                        <i class="bi bi-geo-alt"></i> Adres
                    </span>
                    <span class="info-value">{{ $customer->address }}</span>
                </div>
                @endif
                
                @if($customer->notes)
                <div class="info-item">
                    <span class="info-label">
                        <i class="bi bi-sticky"></i> Notlar
                    </span>
                    <span class="info-value">{{ $customer->notes }}</span>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Statistics Grid -->
    <div class="stats-grid">
        <div class="stat-card-mini">
            <div class="stat-label-mini">Toplam Randevu</div>
            <div class="stat-value-mini">{{ $totalAppointments }}</div>
        </div>
        <div class="stat-card-mini">
            <div class="stat-label-mini">Toplam Tutar</div>
            <div class="stat-value-mini">{{ number_format($totalAmount, 0, ',', '.') }} ₺</div>
        </div>
        <div class="stat-card-mini">
            <div class="stat-label-mini">Ödenen</div>
            <div class="stat-value-mini">{{ number_format($totalPaid, 0, ',', '.') }} ₺</div>
        </div>
        <div class="stat-card-mini">
            <div class="stat-label-mini">Kalan</div>
            <div class="stat-value-mini" style="color: {{ $totalRemaining > 0 ? '#f59e0b' : 'var(--primary-color)' }};">
                {{ number_format($totalRemaining, 0, ',', '.') }} ₺
            </div>
        </div>
    </div>
    
    <!-- Payment Button -->
    @if($totalRemaining > 0)
    <button type="button" class="btn-payment" onclick="openPaymentModal()">
        <i class="bi bi-cash-coin"></i>
        <span>Ödeme Yap ({{ number_format($totalRemaining, 2, ',', '.') }} ₺)</span>
    </button>
    @endif
    
    <!-- Pending Balances -->
    @php
        $appointmentsWithBalance = $appointments->filter(function($r) {
            return $r->remaining_amount > 0 && $r->status != 'cancelled';
        });
    @endphp
    @if($appointmentsWithBalance->count() > 0)
    <div class="card">
        <div class="section-header">
            <div class="section-title">
                <i class="bi bi-exclamation-circle"></i> Kalan Bakiyeler
            </div>
            <span class="section-count">{{ $appointmentsWithBalance->count() }}</span>
        </div>
        <div class="card-body">
            @foreach($appointmentsWithBalance as $reservation)
            <div class="reservation-card" style="border-left-color: #f59e0b;">
                <div class="reservation-card-header">
                    <div class="reservation-date-time">
                        <div class="reservation-date">
                            {{ \Carbon\Carbon::parse($reservation->date)->format('d.m.Y') }}
                        </div>
                        <div class="reservation-time">
                            <i class="bi bi-clock"></i>
                            {{ $reservation->start_time }} - {{ $reservation->end_time }}
                        </div>
                        @if($reservation->salon)
                        <div class="reservation-time" style="margin-top: 4px;">
                            <i class="bi bi-building"></i>
                            {{ $reservation->salon->name }}
                        </div>
                        @endif
                    </div>
                    <span class="balance-badge balance-positive">
                        {{ number_format($reservation->remaining_amount, 2, ',', '.') }} ₺
                    </span>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif
    
    <!-- Appointments -->
    <div class="card">
        <div class="section-header">
            <div class="section-title">
                <i class="bi bi-calendar-check"></i> Randevular
            </div>
            <span class="section-count">{{ $appointments->count() }}</span>
        </div>
        @if($appointments->count() > 0)
        <div class="card-body">
            @foreach($appointments as $reservation)
            <a href="{{ route('mobile.appointments.show', $reservation->id) }}" class="reservation-card">
                <div class="reservation-card-header">
                    <div class="reservation-date-time">
                        <div class="reservation-date">
                            {{ \Carbon\Carbon::parse($reservation->date)->format('d.m.Y') }}
                        </div>
                        <div class="reservation-time">
                            <i class="bi bi-clock"></i>
                            {{ $reservation->start_time }} - {{ $reservation->end_time }}
                        </div>
                    </div>
                    <span class="status-badge 
                        @if($reservation->status == 'confirmed') status-confirmed
                        @elseif($reservation->status == 'open') status-open
                        @elseif($reservation->status == 'cancelled') status-cancelled
                        @else status-completed
                        @endif">
                        @if($reservation->status == 'confirmed') Onaylandı
                        @elseif($reservation->status == 'open') Açık
                        @elseif($reservation->status == 'cancelled') İptal
                        @else Tamamlandı
                        @endif
                    </span>
                </div>
                <div class="reservation-details-grid">
                    @if($reservation->salon)
                    <div class="detail-item">
                        <i class="bi bi-building"></i>
                        <span>{{ $reservation->salon->name }}</span>
                    </div>
                    @endif
                    <div class="detail-item">
                        <i class="bi bi-scissors"></i>
                        <span>
                            @if($reservation->appointmentRequest && $reservation->appointmentRequest->service)
                                {{ $reservation->appointmentRequest->service->name }}
                            @else
                                -
                            @endif
                        </span>
                    </div>
                    <div class="detail-item">
                        <i class="bi bi-cash-stack"></i>
                        <span>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</span>
                    </div>
                    <div class="detail-item">
                        <i class="bi bi-check-circle"></i>
                        <span>Ödenen: {{ number_format($reservation->deposit_paid, 2, ',', '.') }} ₺</span>
                    </div>
                </div>
            </a>
            @endforeach
        </div>
        @else
        <div class="empty-state">
            <div class="empty-state-icon">
                <i class="bi bi-calendar-x"></i>
            </div>
            <div class="empty-state-text">Henüz randevu yok</div>
        </div>
        @endif
    </div>
    
    <!-- Transactions -->
    <div class="card">
        <div class="section-header">
            <div class="section-title">
                <i class="bi bi-receipt"></i> Hesap Bordosu
            </div>
            @php
                $totalIncome = $transactions->where('type', 'income')->sum('amount');
                $totalExpense = $transactions->where('type', 'expense')->sum('amount');
            @endphp
            <div style="display: flex; gap: 6px;">
                <span class="section-count" style="background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%); color: white;">
                    +{{ number_format($totalIncome, 0, ',', '.') }} ₺
                </span>
                @if($totalExpense > 0)
                <span class="section-count" style="background: #fee2e2; color: #991b1b;">
                    -{{ number_format($totalExpense, 0, ',', '.') }} ₺
                </span>
                @endif
            </div>
        </div>
        @if($transactions->count() > 0)
        <div class="card-body">
            @foreach($transactions as $transaction)
            <div class="transaction-card {{ $transaction->type }}">
                <div class="transaction-card-header">
                    <div class="transaction-info">
                        <div class="transaction-date">
                            <i class="bi bi-calendar3"></i>
                            {{ $transaction->date ? \Carbon\Carbon::parse($transaction->date)->format('d.m.Y') : ($transaction->created_at ? $transaction->created_at->format('d.m.Y') : '-') }}
                        </div>
                        @if($transaction->description)
                        <div class="transaction-desc">
                            {{ $transaction->description }}
                        </div>
                        @endif
                    </div>
                    <div class="transaction-amount {{ $transaction->type }}">
                        {{ $transaction->type === 'income' ? '+' : '-' }}{{ number_format($transaction->amount, 2, ',', '.') }} ₺
                    </div>
                </div>
                @if($transaction->type == 'income' && isset($transaction->remaining_debt_after))
                <div class="transaction-footer">
                    <div class="debt-info">
                        <i class="bi bi-info-circle"></i> Bu ödemeden sonra kalan borç: 
                        <strong>{{ number_format($transaction->remaining_debt_after, 2, ',', '.') }} ₺</strong>
                    </div>
                </div>
                @endif
                @if($transaction->reservation)
                <div class="transaction-footer">
                    <a href="{{ route('mobile.appointments.show', $transaction->reservation_id) }}" style="color: var(--primary-color); text-decoration: none; font-size: 13px; font-weight: 500; display: inline-flex; align-items: center; gap: 6px;">
                        <i class="bi bi-calendar-check"></i> 
                        Randevu #{{ $transaction->reservation->code ?? $transaction->reservation_id }}
                    </a>
                </div>
                @endif
            </div>
            @endforeach
        </div>
        @else
        <div class="empty-state">
            <div class="empty-state-icon">
                <i class="bi bi-inbox"></i>
            </div>
            <div class="empty-state-text">Henüz işlem kaydı yok</div>
        </div>
        @endif
    </div>
</div>

<!-- Payment Modal -->
<div class="modal-overlay" id="paymentModal" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1000; align-items: center; justify-content: center; padding: 20px;">
    <div style="background: white; border-radius: 16px; width: 100%; max-width: 400px; max-height: 90vh; overflow-y: auto; box-shadow: 0 20px 25px -5px rgba(0,0,0,0.1);">
        <div style="padding: 20px; border-bottom: 1px solid #e5e7eb; display: flex; justify-content: space-between; align-items: center;">
            <h2 style="font-size: 20px; font-weight: 700; margin: 0;">
                <i class="bi bi-cash-coin"></i> Ödeme Yap
            </h2>
            <button type="button" onclick="closePaymentModal()" style="background: none; border: none; font-size: 24px; color: #6b7280; cursor: pointer; padding: 0; width: 32px; height: 32px; display: flex; align-items: center; justify-content: center; border-radius: 8px;">&times;</button>
        </div>
        <form method="POST" action="{{ route('mobile.accounting.store-income') }}" onsubmit="submitPaymentForm(event)">
            @csrf
            <input type="hidden" name="customer_id" value="{{ $customer->id }}">
            <div style="padding: 20px;">
                <div style="padding: 12px; background: #dbeafe; border-radius: 8px; margin-bottom: 16px; font-size: 13px;">
                    <strong>Müşteri:</strong> {{ $customer->name }}<br>
                    <strong>Kalan Bakiye:</strong> {{ number_format($totalRemaining, 2, ',', '.') }} ₺
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; font-size: 14px; font-weight: 600; margin-bottom: 6px;">
                        Ödeme Tutarı <span style="color: #dc3545;">*</span>
                    </label>
                    <input type="number" name="amount" step="0.01" min="0" value="{{ $totalRemaining > 0 ? $totalRemaining : 0 }}" required style="width: 100%; padding: 12px 16px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 16px;">
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; font-size: 14px; font-weight: 600; margin-bottom: 6px;">
                        Tarih <span style="color: #dc3545;">*</span>
                    </label>
                    <input type="date" name="date" value="{{ date('Y-m-d') }}" required style="width: 100%; padding: 12px 16px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 16px;">
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; font-size: 14px; font-weight: 600; margin-bottom: 6px;">Açıklama</label>
                    <input type="text" name="description" value="Müşteri Ödemesi - {{ $customer->name }}" style="width: 100%; padding: 12px 16px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 16px;">
                </div>
                
                <div id="paymentFormErrors" style="display: none; margin-bottom: 16px;"></div>
            </div>
            <div style="padding: 20px; border-top: 1px solid #e5e7eb; display: flex; gap: 12px;">
                <button type="button" onclick="closePaymentModal()" style="flex: 1; padding: 12px 24px; border-radius: 8px; background: #f3f4f6; color: #111827; border: none; font-size: 14px; font-weight: 600; cursor: pointer;">İptal</button>
                <button type="submit" id="paymentSubmitBtn" style="flex: 1; padding: 12px 24px; border-radius: 8px; background: #ec4899; color: white; border: none; font-size: 14px; font-weight: 600; cursor: pointer;">
                    <i class="bi bi-check-circle"></i> Kaydet
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openPaymentModal() {
    document.getElementById('paymentModal').style.display = 'flex';
}

function closePaymentModal() {
    document.getElementById('paymentModal').style.display = 'none';
    document.getElementById('paymentFormErrors').style.display = 'none';
}

function submitPaymentForm(e) {
    e.preventDefault();
    const form = e.target;
    const submitBtn = document.getElementById('paymentSubmitBtn');
    const errorsDiv = document.getElementById('paymentFormErrors');
    
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i> Kaydediliyor...';
    errorsDiv.style.display = 'none';
    
    const formData = new FormData(form);
    
    fetch(form.action, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            closePaymentModal();
            location.reload();
        } else {
            let errorHtml = '<div style="padding: 12px; background: #fee2e2; border-radius: 8px; color: #991b1b; font-size: 13px;"><ul style="margin: 0; padding-left: 20px;">';
            if (data.errors) {
                Object.values(data.errors).forEach(error => {
                    if (Array.isArray(error)) {
                        error.forEach(msg => errorHtml += '<li>' + msg + '</li>');
                    } else {
                        errorHtml += '<li>' + error + '</li>';
                    }
                });
            } else if (data.message) {
                errorHtml += '<li>' + data.message + '</li>';
            }
            errorHtml += '</ul></div>';
            errorsDiv.innerHTML = errorHtml;
            errorsDiv.style.display = 'block';
            submitBtn.disabled = false;
            submitBtn.innerHTML = '<i class="bi bi-check-circle"></i> Kaydet';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        errorsDiv.innerHTML = '<div style="padding: 12px; background: #fee2e2; border-radius: 8px; color: #991b1b; font-size: 13px;">Bir hata oluştu. Lütfen tekrar deneyin.</div>';
        errorsDiv.style.display = 'block';
        submitBtn.disabled = false;
        submitBtn.innerHTML = '<i class="bi bi-check-circle"></i> Kaydet';
    });
}

// Modal dışına tıklanınca kapat
document.getElementById('paymentModal')?.addEventListener('click', function(e) {
    if (e.target === this) {
        closePaymentModal();
    }
});
</script>
@endsection
