@extends('admin.mobile.layouts.app')
@section('title', 'Anasayfa')

@section('content')
@php
    $user = auth()->user();
    $hour = now()->hour;
    $greeting = $hour < 12 ? 'Günaydın' : ($hour < 18 ? 'İyi Günler' : 'İyi Akşamlar');
@endphp

<div class="d-flex align-items-center justify-content-between mb-4">
    <div>
        <h4 class="fw-800 mb-1" style="font-weight: 800; letter-spacing: -0.5px;">{{ $greeting }}</h4>
        <p class="text-secondary mb-0 fw-600" style="font-size: 14px;">{{ $user->name }}</p>
    </div>
    <div style="width: 48px; height: 48px; border-radius: 16px; background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%); display: flex; align-items: center; justify-content: center; color: #ec4899;">
        <i class="bi bi-person-fill" style="font-size: 24px;"></i>
    </div>
</div>

<div class="card" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; color: white; padding: 24px;">
    <p class="mb-1 opacity-75 fw-600" style="font-size: 13px;">TOPLAM BAKİYE</p>
    <h2 class="fw-800 mb-3" style="font-weight: 800;">{{ number_format($totalBalance ?? 0, 2, ',', '.') }} ₺</h2>
    <div class="d-flex gap-2">
        <a href="{{ route('mobile.appointments.create') }}" class="btn bg-white text-dark flex-grow-1" style="min-height: 44px; border-radius: 12px; font-size: 13px;">
            <i class="bi bi-plus-lg me-2"></i>Randevu
        </a>
        <button onclick="location.reload()" class="btn bg-white bg-opacity-20 text-white" style="min-height: 44px; width: 44px; padding: 0; border-radius: 12px;">
            <i class="bi bi-arrow-clockwise"></i>
        </button>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-6">
        <div class="card mb-0">
            <div class="item-icon bg-success bg-opacity-10 text-success mb-2">
                <i class="bi bi-graph-up-arrow"></i>
            </div>
            <p class="text-secondary mb-1 fw-600" style="font-size: 12px;">GELİR (BUGÜN)</p>
            <h5 class="fw-800 mb-0">{{ number_format($todayIncome ?? 0, 0, ',', '.') }} ₺</h5>
        </div>
    </div>
    <div class="col-6">
        <div class="card mb-0">
            <div class="item-icon bg-danger bg-opacity-10 text-danger mb-2">
                <i class="bi bi-graph-down-arrow"></i>
            </div>
            <p class="text-secondary mb-1 fw-600" style="font-size: 12px;">GİDER (BUGÜN)</p>
            <h5 class="fw-800 mb-0">{{ number_format($todayExpense ?? 0, 0, ',', '.') }} ₺</h5>
        </div>
    </div>
</div>

<div class="section-header">
    <h5 class="section-title">Hızlı İşlemler</h5>
</div>

<div class="d-flex gap-3 mb-4" style="overflow-x: auto; padding: 4px; margin: 0 -4px;">
    <a href="{{ route('mobile.customers.index') }}" class="text-center text-decoration-none" style="min-width: 80px;">
        <div class="item-icon bg-white shadow-sm mx-auto mb-2" style="color: #6366f1;">
            <i class="bi bi-people"></i>
        </div>
        <span class="text-dark fw-600" style="font-size: 12px;">Müşteriler</span>
    </a>
    <a href="{{ route('mobile.calendar.index') }}" class="text-center text-decoration-none" style="min-width: 80px;">
        <div class="item-icon bg-white shadow-sm mx-auto mb-2" style="color: #f59e0b;">
            <i class="bi bi-calendar3"></i>
        </div>
        <span class="text-dark fw-600" style="font-size: 12px;">Takvim</span>
    </a>
    <a href="{{ route('mobile.settings.invoices.index') }}" class="text-center text-decoration-none" style="min-width: 80px;">
        <div class="item-icon bg-white shadow-sm mx-auto mb-2" style="color: #10b981;">
            <i class="bi bi-receipt"></i>
        </div>
        <span class="text-dark fw-600" style="font-size: 12px;">Faturalar</span>
    </a>
    <a href="{{ route('mobile.settings.salons.index') }}" class="text-center text-decoration-none" style="min-width: 80px;">
        <div class="item-icon bg-white shadow-sm mx-auto mb-2" style="color: #ec4899;">
            <i class="bi bi-shop"></i>
        </div>
        <span class="text-dark fw-600" style="font-size: 12px;">Salonlar</span>
    </a>
</div>

<div class="section-header">
    <h5 class="section-title">Yaklaşan Randevular</h5>
    <a href="{{ route('mobile.appointments.index') }}" class="text-p text-decoration-none fw-700" style="font-size: 13px;">Tümü</a>
</div>

@forelse($upcomingAppointments ?? [] as $apt)
    <a href="{{ route('mobile.appointments.show', $apt->id) }}" class="list-item">
        <div class="item-icon bg-p bg-opacity-10 text-p">
            <i class="bi bi-calendar-check"></i>
        </div>
        <div class="flex-grow-1">
            <div class="fw-700" style="font-size: 15px;">{{ $apt->customer->name ?? 'Müşteri' }}</div>
            <div class="text-secondary" style="font-size: 13px;">{{ \Carbon\Carbon::parse($apt->date)->format('d M') }} • {{ $apt->time }}</div>
        </div>
        <i class="bi bi-chevron-right text-secondary"></i>
    </a>
@empty
    <div class="text-center py-4 bg-white rounded-4 border">
        <i class="bi bi-calendar-x text-secondary opacity-20" style="font-size: 48px;"></i>
        <p class="text-secondary mt-2 mb-0 fw-600">Henüz randevu yok</p>
    </div>
@endforelse

@endsection
