@extends('admin.mobile.layouts.app')

@section('title', 'Veri Yüklenemedi')

@push('styles')
<style>
    .error-screen {
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        padding: 24px;
        background: linear-gradient(135deg, #f9fafb 0%, #ffffff 100%);
    }
    
    .error-icon-container {
        width: 120px;
        height: 120px;
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 32px;
        box-shadow: 0 8px 24px rgba(245, 158, 11, 0.2);
        animation: pulse 2s ease-in-out infinite;
    }
    
    @keyframes pulse {
        0%, 100% {
            transform: scale(1);
        }
        50% {
            transform: scale(1.05);
        }
    }
    
    .error-icon {
        font-size: 56px;
        color: #f59e0b;
    }
    
    .error-screen h1 {
        font-size: 28px;
        margin-bottom: 16px;
        font-weight: 700;
        color: #111827;
        line-height: 1.2;
    }
    
    .error-screen p {
        font-size: 16px;
        color: #6b7280;
        margin-bottom: 40px;
        line-height: 1.6;
        max-width: 320px;
    }
    
    .error-actions {
        display: flex;
        flex-direction: column;
        gap: 12px;
        width: 100%;
        max-width: 320px;
    }
    
    .error-screen .btn {
        padding: 16px 32px;
        border-radius: 12px;
        border: none;
        background: linear-gradient(135deg, #10b981 0%, #047857 100%);
        color: #fff;
        text-decoration: none;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
        min-height: 52px;
    }
    
    .error-screen .btn:active {
        transform: scale(0.98);
        box-shadow: 0 2px 8px rgba(16, 185, 129, 0.2);
    }
    
    .error-screen .btn-outline {
        background: white;
        border: 2px solid #10b981;
        color: #10b981;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    
    .error-screen .btn-outline:active {
        background: #f0f9ff;
    }
    
    .error-tips {
        margin-top: 32px;
        padding: 16px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        max-width: 320px;
        width: 100%;
    }
    
    .error-tips-title {
        font-size: 14px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .error-tips-list {
        list-style: none;
        padding: 0;
        margin: 0;
        text-align: left;
    }
    
    .error-tips-list li {
        font-size: 13px;
        color: #6b7280;
        padding: 8px 0;
        padding-left: 24px;
        position: relative;
        line-height: 1.5;
    }
    
    .error-tips-list li:before {
        content: "•";
        position: absolute;
        left: 8px;
        color: #10b981;
        font-weight: bold;
        font-size: 18px;
    }
</style>
@endpush

@section('content')
<div class="error-screen">
    <div class="error-icon-container">
        <i class="bi bi-wifi-off error-icon"></i>
    </div>
    <h1>Veri yüklenemedi</h1>
    <p>İnternet bağlantını kontrol edip tekrar dene. Sorun devam ederse uygulamayı yeniden başlat.</p>
    
    <div class="error-actions">
        <button onclick="location.reload()" class="btn">
            <i class="bi bi-arrow-clockwise"></i>
            Tekrar Dene
        </button>
        <a href="{{ url('/admin/mobile/login') }}" class="btn btn-outline">
            <i class="bi bi-box-arrow-in-right"></i>
            Giriş Sayfasına Dön
        </a>
    </div>
    
    <div class="error-tips">
        <div class="error-tips-title">
            <i class="bi bi-lightbulb"></i>
            İpuçları
        </div>
        <ul class="error-tips-list">
            <li>Wi-Fi veya mobil veri bağlantını kontrol et</li>
            <li>Uçak modunun kapalı olduğundan emin ol</li>
            <li>Uygulamayı kapatıp tekrar aç</li>
            <li>Telefonunu yeniden başlat</li>
        </ul>
    </div>
</div>
@endsection
