@extends('admin.mobile.layouts.app')

@section('title', 'İnternet Bağlantısı Yok')

@push('styles')
<style>
    .error-screen {
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        padding: 24px;
        background: linear-gradient(135deg, #f0f9ff 0%, #ffffff 100%);
    }
    
    .error-icon-container {
        width: 140px;
        height: 140px;
        background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 32px;
        box-shadow: 0 8px 24px rgba(59, 130, 246, 0.2);
        animation: bounce 2s ease-in-out infinite;
        position: relative;
    }
    
    @keyframes bounce {
        0%, 100% {
            transform: translateY(0);
        }
        50% {
            transform: translateY(-10px);
        }
    }
    
    .error-icon {
        font-size: 64px;
        color: #3b82f6;
    }
    
    .error-screen h1 {
        font-size: 28px;
        margin-bottom: 16px;
        font-weight: 700;
        color: #111827;
        line-height: 1.2;
    }
    
    .error-screen p {
        font-size: 16px;
        color: #6b7280;
        margin-bottom: 40px;
        line-height: 1.6;
        max-width: 320px;
    }
    
    .error-actions {
        display: flex;
        flex-direction: column;
        gap: 12px;
        width: 100%;
        max-width: 320px;
    }
    
    .error-screen .btn {
        padding: 16px 32px;
        border-radius: 12px;
        border: none;
        background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        color: #fff;
        text-decoration: none;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        min-height: 52px;
    }
    
    .error-screen .btn:active {
        transform: scale(0.98);
        box-shadow: 0 2px 8px rgba(59, 130, 246, 0.2);
    }
    
    .error-screen .btn-outline {
        background: white;
        border: 2px solid #3b82f6;
        color: #3b82f6;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    
    .error-screen .btn-outline:active {
        background: #eff6ff;
    }
    
    .connection-status {
        margin-top: 32px;
        padding: 16px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        max-width: 320px;
        width: 100%;
    }
    
    .connection-status-title {
        font-size: 14px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }
    
    .connection-indicator {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        margin-top: 12px;
    }
    
    .connection-dot {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background: #9ca3af;
        animation: pulse-dot 1.5s ease-in-out infinite;
    }
    
    .connection-dot:nth-child(1) {
        animation-delay: 0s;
    }
    
    .connection-dot:nth-child(2) {
        animation-delay: 0.3s;
    }
    
    .connection-dot:nth-child(3) {
        animation-delay: 0.6s;
    }
    
    @keyframes pulse-dot {
        0%, 100% {
            opacity: 0.3;
            transform: scale(1);
        }
        50% {
            opacity: 1;
            transform: scale(1.2);
        }
    }
    
    .connection-dot.connected {
        background: #10b981;
        animation: none;
        opacity: 1;
    }
    
    .error-tips {
        margin-top: 24px;
        padding: 16px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        max-width: 320px;
        width: 100%;
    }
    
    .error-tips-title {
        font-size: 14px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .error-tips-list {
        list-style: none;
        padding: 0;
        margin: 0;
        text-align: left;
    }
    
    .error-tips-list li {
        font-size: 13px;
        color: #6b7280;
        padding: 8px 0;
        padding-left: 24px;
        position: relative;
        line-height: 1.5;
    }
    
    .error-tips-list li:before {
        content: "•";
        position: absolute;
        left: 8px;
        color: #3b82f6;
        font-weight: bold;
        font-size: 18px;
    }
</style>
@endpush

@section('content')
<div class="error-screen">
    <div class="error-icon-container">
        <i class="bi bi-wifi-off error-icon"></i>
    </div>
    <h1>İnternet bağlantısı yok</h1>
    <p>İnternet bağlantınızı kontrol edin ve tekrar deneyin. Uygulama çevrimdışı modda çalışamaz.</p>
    
    <div class="error-actions">
        <button onclick="checkConnection()" class="btn" id="retryBtn">
            <i class="bi bi-arrow-clockwise"></i>
            Bağlantıyı Kontrol Et
        </button>
        <a href="{{ url('/admin/mobile/login') }}" class="btn btn-outline">
            <i class="bi bi-box-arrow-in-right"></i>
            Giriş Sayfasına Dön
        </a>
    </div>
    
    <div class="connection-status">
        <div class="connection-status-title">
            <i class="bi bi-wifi"></i>
            Bağlantı Durumu
        </div>
        <div class="connection-indicator" id="connectionIndicator">
            <div class="connection-dot"></div>
            <div class="connection-dot"></div>
            <div class="connection-dot"></div>
        </div>
        <p style="font-size: 12px; color: #6b7280; margin-top: 8px; text-align: center;" id="connectionStatus">
            Kontrol ediliyor...
        </p>
    </div>
    
    <div class="error-tips">
        <div class="error-tips-title">
            <i class="bi bi-lightbulb"></i>
            Çözüm Önerileri
        </div>
        <ul class="error-tips-list">
            <li>Wi-Fi bağlantınızı kontrol edin</li>
            <li>Mobil veri bağlantınızı açın</li>
            <li>Uçak modunun kapalı olduğundan emin olun</li>
            <li>Modemi veya router'ı yeniden başlatın</li>
            <li>Farklı bir ağa bağlanmayı deneyin</li>
        </ul>
    </div>
</div>

<script>
    function checkConnection() {
        const retryBtn = document.getElementById('retryBtn');
        const indicator = document.getElementById('connectionIndicator');
        const status = document.getElementById('connectionStatus');
        
        retryBtn.disabled = true;
        retryBtn.innerHTML = '<i class="bi bi-hourglass-split"></i> Kontrol ediliyor...';
        status.textContent = 'Kontrol ediliyor...';
        
        // Online/offline event listeners
        window.addEventListener('online', function() {
            indicator.innerHTML = '<div class="connection-dot connected"></div><div class="connection-dot connected"></div><div class="connection-dot connected"></div>';
            status.textContent = 'Bağlantı başarılı!';
            status.style.color = '#10b981';
            setTimeout(() => {
                window.location.reload();
            }, 1000);
        });
        
        window.addEventListener('offline', function() {
            indicator.innerHTML = '<div class="connection-dot"></div><div class="connection-dot"></div><div class="connection-dot"></div>';
            status.textContent = 'Bağlantı yok';
            status.style.color = '#ef4444';
        });
        
        // Test connection
        fetch('{{ url("/") }}', { 
            method: 'HEAD',
            cache: 'no-cache',
            mode: 'no-cors'
        })
        .then(() => {
            indicator.innerHTML = '<div class="connection-dot connected"></div><div class="connection-dot connected"></div><div class="connection-dot connected"></div>';
            status.textContent = 'Bağlantı başarılı!';
            status.style.color = '#10b981';
            retryBtn.innerHTML = '<i class="bi bi-check-circle"></i> Bağlandı';
            setTimeout(() => {
                window.location.reload();
            }, 1000);
        })
        .catch(() => {
            indicator.innerHTML = '<div class="connection-dot"></div><div class="connection-dot"></div><div class="connection-dot"></div>';
            status.textContent = 'Bağlantı yok';
            status.style.color = '#ef4444';
            retryBtn.disabled = false;
            retryBtn.innerHTML = '<i class="bi bi-arrow-clockwise"></i> Tekrar Dene';
        });
        
        // Check navigator.onLine
        if (navigator.onLine) {
            setTimeout(() => {
                indicator.innerHTML = '<div class="connection-dot connected"></div><div class="connection-dot connected"></div><div class="connection-dot connected"></div>';
                status.textContent = 'Bağlantı başarılı!';
                status.style.color = '#10b981';
                retryBtn.innerHTML = '<i class="bi bi-check-circle"></i> Bağlandı';
                setTimeout(() => {
                    window.location.reload();
                }, 1000);
            }, 500);
        } else {
            setTimeout(() => {
                indicator.innerHTML = '<div class="connection-dot"></div><div class="connection-dot"></div><div class="connection-dot"></div>';
                status.textContent = 'Bağlantı yok';
                status.style.color = '#ef4444';
                retryBtn.disabled = false;
                retryBtn.innerHTML = '<i class="bi bi-arrow-clockwise"></i> Tekrar Dene';
            }, 500);
        }
    }
    
    // Auto-check on load
    window.addEventListener('load', function() {
        checkConnection();
    });
    
    // Monitor connection status
    window.addEventListener('online', function() {
        document.getElementById('connectionStatus').textContent = 'Bağlantı başarılı!';
        document.getElementById('connectionStatus').style.color = '#10b981';
        setTimeout(() => {
            window.location.reload();
        }, 1000);
    });
    
    window.addEventListener('offline', function() {
        document.getElementById('connectionStatus').textContent = 'Bağlantı yok';
        document.getElementById('connectionStatus').style.color = '#ef4444';
    });
</script>
@endsection

