@extends('admin.mobile.layouts.app')

@section('title', 'Bir Sorun Oluştu')

@push('styles')
<style>
    .error-screen {
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        padding: 24px;
        background: linear-gradient(135deg, #fef2f2 0%, #ffffff 100%);
    }
    
    .error-icon-container {
        width: 120px;
        height: 120px;
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 32px;
        box-shadow: 0 8px 24px rgba(239, 68, 68, 0.2);
        animation: shake 0.5s ease-in-out;
    }
    
    @keyframes shake {
        0%, 100% { transform: translateX(0); }
        25% { transform: translateX(-10px); }
        75% { transform: translateX(10px); }
    }
    
    .error-icon {
        font-size: 56px;
        color: #ef4444;
    }
    
    .error-screen h1 {
        font-size: 28px;
        margin-bottom: 16px;
        font-weight: 700;
        color: #111827;
        line-height: 1.2;
    }
    
    .error-screen p {
        font-size: 16px;
        color: #6b7280;
        margin-bottom: 40px;
        line-height: 1.6;
        max-width: 320px;
    }
    
    .error-actions {
        display: flex;
        flex-direction: column;
        gap: 12px;
        width: 100%;
        max-width: 320px;
    }
    
    .error-screen .btn {
        padding: 16px 32px;
        border-radius: 12px;
        border: none;
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: #fff;
        text-decoration: none;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);
        min-height: 52px;
    }
    
    .error-screen .btn:active {
        transform: scale(0.98);
        box-shadow: 0 2px 8px rgba(239, 68, 68, 0.2);
    }
    
    .error-screen .btn-outline {
        background: white;
        border: 2px solid #ef4444;
        color: #ef4444;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    
    .error-screen .btn-outline:active {
        background: #fef2f2;
    }
    
    .error-details {
        margin-top: 32px;
        padding: 16px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        max-width: 320px;
        width: 100%;
        text-align: left;
    }
    
    .error-details-title {
        font-size: 14px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .error-details-content {
        font-size: 12px;
        color: #6b7280;
        font-family: 'Courier New', monospace;
        background: #f9fafb;
        padding: 12px;
        border-radius: 8px;
        word-break: break-all;
        line-height: 1.5;
    }
    
    .error-details-content code {
        color: #dc2626;
        font-weight: 600;
    }
</style>
@endpush

@section('content')
<div class="error-screen">
    <div class="error-icon-container">
        <i class="bi bi-exclamation-triangle-fill error-icon"></i>
    </div>
    <h1>Bir sorun oluştu</h1>
    <p>Üzgünüz, beklenmeyen bir hata oluştu. Lütfen biraz sonra tekrar deneyin veya sayfayı yenileyin.</p>
    
    <div class="error-actions">
        <button onclick="location.reload()" class="btn">
            <i class="bi bi-arrow-clockwise"></i>
            Sayfayı Yenile
        </button>
        <a href="{{ url('/admin/mobile/dashboard') }}" class="btn btn-outline">
            <i class="bi bi-house-door"></i>
            Ana Sayfaya Dön
        </a>
    </div>
    
    @if(isset($error) && app()->environment('local', 'development'))
        <div class="error-details">
            <div class="error-details-title">
                <i class="bi bi-bug"></i>
                Hata Detayı (Development)
            </div>
            <div class="error-details-content">
                <strong>Hata:</strong><br>
                <code>{{ $error }}</code>
                @if(isset($file))
                    <br><br>
                    <strong>Dosya:</strong> {{ $file }}
                    @if(isset($line))
                        <br>
                        <strong>Satır:</strong> {{ $line }}
                    @endif
                @endif
            </div>
        </div>
    @endif
</div>
@endsection
