@extends('admin.mobile.layouts.app')

@section('title', 'Oturum Süresi Doldu')

@push('styles')
<style>
    .error-screen {
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        padding: 24px;
        background: linear-gradient(135deg, #fef3c7 0%, #ffffff 100%);
    }
    
    .error-icon-container {
        width: 120px;
        height: 120px;
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 32px;
        box-shadow: 0 8px 24px rgba(245, 158, 11, 0.2);
        animation: rotate 3s linear infinite;
    }
    
    @keyframes rotate {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
    
    .error-icon {
        font-size: 56px;
        color: #f59e0b;
        animation: rotate-reverse 3s linear infinite;
    }
    
    @keyframes rotate-reverse {
        from { transform: rotate(360deg); }
        to { transform: rotate(0deg); }
    }
    
    .error-screen h1 {
        font-size: 28px;
        margin-bottom: 16px;
        font-weight: 700;
        color: #111827;
        line-height: 1.2;
    }
    
    .error-screen p {
        font-size: 16px;
        color: #6b7280;
        margin-bottom: 40px;
        line-height: 1.6;
        max-width: 320px;
    }
    
    .error-actions {
        display: flex;
        flex-direction: column;
        gap: 12px;
        width: 100%;
        max-width: 320px;
    }
    
    .error-screen .btn {
        padding: 16px 32px;
        border-radius: 12px;
        border: none;
        background: linear-gradient(135deg, #10b981 0%, #047857 100%);
        color: #fff;
        text-decoration: none;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
        min-height: 52px;
    }
    
    .error-screen .btn:active {
        transform: scale(0.98);
        box-shadow: 0 2px 8px rgba(16, 185, 129, 0.2);
    }
    
    .error-screen .btn-outline {
        background: white;
        border: 2px solid #10b981;
        color: #10b981;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    
    .error-screen .btn-outline:active {
        background: #f0f9ff;
    }
    
    .error-info {
        margin-top: 32px;
        padding: 16px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        max-width: 320px;
        width: 100%;
    }
    
    .error-info-title {
        font-size: 14px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .error-info-text {
        font-size: 13px;
        color: #6b7280;
        line-height: 1.5;
        text-align: left;
    }
</style>
@endpush

@section('content')
<div class="error-screen">
    <div class="error-icon-container">
        <i class="bi bi-clock-history error-icon"></i>
    </div>
    <h1>Oturum süren doldu</h1>
    <p>Güvenlik nedeniyle oturumun sonlandırıldı. Devam etmek için tekrar giriş yapman gerekiyor.</p>
    
    <div class="error-actions">
        <a href="{{ url('/admin/mobile/login') }}" class="btn">
            <i class="bi bi-box-arrow-in-right"></i>
            Giriş Yap
        </a>
        <a href="{{ url('/admin/mobile/dashboard') }}" class="btn btn-outline">
            <i class="bi bi-house-door"></i>
            Panele Git
        </a>
    </div>
    
    <div class="error-info">
        <div class="error-info-title">
            <i class="bi bi-info-circle"></i>
            Neden bu hata oluştu?
        </div>
        <div class="error-info-text">
            Bu hata genellikle sayfayı uzun süre açık bıraktığında, başka bir cihazda giriş yapıldığında veya güvenlik nedeniyle oturumun sonlandırıldığında oluşur.
        </div>
    </div>
</div>
@endsection

