<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="theme-color" content="#ec4899">
    <title>@yield('title', 'Salonay')</title>
    @include('partials.google-ads-tag')
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <style>
        :root {
            --p: #ec4899; --pd: #be185d; --pl: #f472b6;
            --bg: #ffffff; --bg2: #f8fafc;
            --txt: #0f172a; --txt2: #64748b;
            --brd: #f1f5f9;
            --safe-top: env(safe-area-inset-top);
            --safe-bottom: env(safe-area-inset-bottom);
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; -webkit-tap-highlight-color: transparent; font-family: 'Plus Jakarta Sans', sans-serif; }
        html, body { height: 100%; width: 100%; overflow-x: hidden; background: var(--bg2); color: var(--txt); -webkit-font-smoothing: antialiased; overscroll-behavior-y: none; }
        body { padding-top: var(--safe-top); padding-bottom: calc(var(--safe-bottom) + 70px); }
        
        .content { padding: 20px 16px; animation: pageIn 0.4s cubic-bezier(0.4, 0, 0.2, 1); }
        @keyframes pageIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
        
        .card { background: var(--bg); border-radius: 24px; padding: 20px; margin-bottom: 16px; border: 1px solid var(--brd); box-shadow: 0 4px 6px -1px rgba(0,0,0,0.02), 0 2px 4px -2px rgba(0,0,0,0.02); transition: all 0.2s ease; }
        .card:active { transform: scale(0.98); background: var(--bg2); }
        
        .btn { display: inline-flex; align-items: center; justify-content: center; padding: 14px 24px; border-radius: 16px; font-weight: 700; transition: all 0.2s; min-height: 54px; border: none; }
        .btn-p { background: linear-gradient(135deg, var(--p) 0%, var(--pd) 100%); color: white; box-shadow: 0 10px 20px -5px rgba(236, 72, 153, 0.4); }
        .btn-p:active { transform: scale(0.96); box-shadow: 0 5px 10px -3px rgba(236, 72, 153, 0.4); }
        
        .nav-bar { position: fixed; bottom: 0; left: 0; right: 0; height: calc(var(--safe-bottom) + 70px); background: rgba(255,255,255,0.9); backdrop-filter: blur(20px); -webkit-backdrop-filter: blur(20px); border-top: 1px solid var(--brd); display: flex; padding: 0 10px calc(var(--safe-bottom) + 5px); z-index: 9999; }
        .nav-item { flex: 1; display: flex; flex-direction: column; align-items: center; justify-content: center; color: var(--txt2); text-decoration: none; font-size: 11px; font-weight: 600; gap: 4px; }
        .nav-item i { font-size: 24px; transition: all 0.2s; }
        .nav-item.active { color: var(--p); }
        .nav-item.active i { transform: translateY(-2px); color: var(--p); }
        
        .section-header { display: flex; align-items: center; justify-content: space-between; margin-bottom: 16px; padding: 0 4px; }
        .section-title { font-size: 20px; font-weight: 800; color: var(--txt); }
        
        .list-item { background: var(--bg); border-radius: 20px; padding: 16px; margin-bottom: 12px; display: flex; align-items: center; gap: 16px; border: 1px solid var(--brd); text-decoration: none; color: inherit; }
        .list-item:active { transform: scale(0.98); background: var(--bg2); }
        .item-icon { width: 48px; height: 48px; border-radius: 14px; display: flex; align-items: center; justify-content: center; font-size: 20px; flex-shrink: 0; }
        
        .modal-content { border-radius: 32px; border: none; padding: 8px; }
        .form-control { background: var(--bg2); border: 1px solid var(--brd); border-radius: 16px; padding: 14px 18px; font-size: 16px; font-weight: 500; }
        .form-control:focus { border-color: var(--p); box-shadow: 0 0 0 4px rgba(236,72,153,0.1); background: var(--bg); }
        
        ::-webkit-scrollbar { display: none; }
        * { -webkit-user-select: none; user-select: none; }
        input, textarea { -webkit-user-select: text; user-select: text; }
    </style>
    @stack('styles')
</head>
<body>
    <div class="content">
        @yield('content')
    </div>

    <nav class="nav-bar">
        <a href="{{ route('mobile.dashboard') }}" class="nav-item {{ request()->routeIs('mobile.dashboard') ? 'active' : '' }}">
            <i class="bi bi-grid-1x2{{ request()->routeIs('mobile.dashboard') ? '-fill' : '' }}"></i>
            <span>Panel</span>
        </a>
        <a href="{{ route('mobile.appointments.index') }}" class="nav-item {{ request()->routeIs('mobile.appointments.*') ? 'active' : '' }}">
            <i class="bi bi-calendar-event{{ request()->routeIs('mobile.appointments.*') ? '-fill' : '' }}"></i>
            <span>Randevu</span>
        </a>
        <a href="{{ route('mobile.accounting.index') }}" class="nav-item {{ request()->routeIs('mobile.accounting.*') ? 'active' : '' }}">
            <i class="bi bi-wallet2"></i>
            <span>Finans</span>
        </a>
        <a href="{{ route('mobile.settings.index') }}" class="nav-item {{ request()->routeIs('mobile.settings.*') || request()->routeIs('mobile.customers.*') ? 'active' : '' }}">
            <i class="bi bi-person-circle"></i>
            <span>Profil</span>
        </a>
    </nav>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        window.FlutterBridge = {
            postMessage: (m) => {
                if (typeof AuthBridge !== 'undefined') AuthBridge.postMessage(m);
                else if (window.flutter_inappwebview) window.flutter_inappwebview.callHandler('AuthBridge', m);
            }
        };
        document.addEventListener('touchstart', (e) => { this.lastY = e.touches[0].clientY; }, {passive: true});
        document.addEventListener('touchmove', (e) => { 
            let y = e.touches[0].clientY;
            if (y > this.lastY && window.scrollY === 0) e.preventDefault();
        }, {passive: false});
    </script>
    @stack('scripts')
</body>
</html>
