@extends('admin.mobile.layouts.app')

@section('title', 'Ayarlar')

@push('styles')
<style>
    .settings-page {
        padding-bottom: 20px;
    }
    
    .page-header {
        margin-bottom: 24px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
    }
    
    .menu-item {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 16px;
        background: white;
        border-radius: 12px;
        margin-bottom: 12px;
        text-decoration: none;
        color: inherit;
        border: 1px solid #e5e7eb;
        transition: all 0.2s;
        cursor: pointer;
    }
    
    .menu-item:active {
        transform: translateX(4px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.12);
        border-color: #10b981;
    }
    
    .menu-item-content {
        display: flex;
        align-items: center;
        gap: 12px;
        flex: 1;
    }
    
    .menu-item-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        background: #f0f9ff;
        color: #0284c7;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        flex-shrink: 0;
    }
    
    .menu-item-icon.profile { background: #fef3c7; color: #d97706; }
    .menu-item-icon.customers { background: #dbeafe; color: #10b981; }
    .menu-item-icon.invoices { background: #dcfce7; color: #16a34a; }
    .menu-item-icon.whatsapp { background: #dcfce7; color: #16a34a; }
    .menu-item-icon.logout { background: #fee2e2; color: #dc2626; }
    
    .menu-item-text {
        flex: 1;
    }
    
    .menu-item-title {
        font-size: 15px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 4px;
    }
    
    .menu-item-subtitle {
        font-size: 13px;
        color: #6b7280;
    }
    
    .menu-item-arrow {
        font-size: 20px;
        color: #9ca3af;
    }
    
    .alert {
        padding: 12px 16px;
        border-radius: 8px;
        margin-bottom: 16px;
        font-size: 14px;
    }
    
    .alert-success {
        background: #d1fae5;
        color: #065f46;
    }
    
    .alert-danger {
        background: #fee2e2;
        color: #991b1b;
    }
    
    .sms-balance-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: #eff6ff;
        color: #10b981;
        padding: 8px 12px;
        border-radius: 8px;
        font-size: 13px;
        font-weight: 600;
        border: 1px solid #dbeafe;
        margin-bottom: 16px;
    }
    
    .sms-balance-badge i {
        font-size: 16px;
    }
</style>
@endpush

@section('content')
<div class="settings-page">
    <div class="page-header">
        <h1 class="page-title">Ayarlar</h1>
        <div class="sms-balance-badge">
            <i class="bi bi-chat-dots"></i>
            <span>SMS: {{ number_format($user->sms_balance ?? 0, 0, ',', '.') }}</span>
        </div>
    </div>
    
    @if(session('success'))
        <div class="alert alert-success">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-circle"></i> {{ session('error') }}
        </div>
    @endif
    
    <!-- Profil -->
    <a href="{{ route('mobile.settings.profile') }}" class="menu-item">
        <div class="menu-item-content">
            <div class="menu-item-icon profile">
                <i class="bi bi-person"></i>
            </div>
            <div class="menu-item-text">
                <div class="menu-item-title">Profil</div>
                <div class="menu-item-subtitle">Profil bilgilerinizi düzenleyin</div>
            </div>
        </div>
        <div class="menu-item-arrow">›</div>
    </a>
    
    <!-- Müşteriler -->
    <a href="{{ route('mobile.customers.index') }}" class="menu-item">
        <div class="menu-item-content">
            <div class="menu-item-icon customers">
                <i class="bi bi-people"></i>
            </div>
            <div class="menu-item-text">
                <div class="menu-item-title">Müşteriler</div>
                <div class="menu-item-subtitle">Müşterilerinizi görüntüleyin ve yönetin</div>
            </div>
        </div>
        <div class="menu-item-arrow">›</div>
    </a>
    
    <!-- Faturalar -->
    <a href="{{ route('mobile.settings.invoices.index') }}" class="menu-item">
        <div class="menu-item-content">
            <div class="menu-item-icon invoices">
                <i class="bi bi-receipt"></i>
            </div>
            <div class="menu-item-text">
                <div class="menu-item-title">Faturalar</div>
                <div class="menu-item-subtitle">Tüm faturalarınızı görüntüleyin</div>
            </div>
        </div>
        <div class="menu-item-arrow">›</div>
    </a>
    
    <!-- Salon Yönetimi -->
    <a href="{{ route('mobile.settings.salons.index') }}" class="menu-item">
        <div class="menu-item-content">
            <div class="menu-item-icon" style="background: #fef3c7; color: #d97706;">
                <i class="bi bi-building"></i>
            </div>
            <div class="menu-item-text">
                <div class="menu-item-title">Salon Yönetimi</div>
                <div class="menu-item-subtitle">Salonlarınızı yönetin</div>
            </div>
        </div>
        <div class="menu-item-arrow">›</div>
    </a>
    
    <!-- Üyelik Bilgileri -->
    <a href="{{ route('mobile.settings.membership') }}" class="menu-item">
        <div class="menu-item-content">
            <div class="menu-item-icon" style="background: #e0e7ff; color: #6366f1;">
                <i class="bi bi-person-badge"></i>
            </div>
            <div class="menu-item-text">
                <div class="menu-item-title">Üyelik Bilgileri</div>
                <div class="menu-item-subtitle">Üyelik detaylarınızı görüntüleyin</div>
            </div>
        </div>
        <div class="menu-item-arrow">›</div>
    </a>
    
    <!-- WhatsApp Destek -->
    @if(env('WPDESTEK'))
    <a href="{{ env('WPDESTEK') }}" target="_blank" class="menu-item">
        <div class="menu-item-content">
            <div class="menu-item-icon whatsapp">
                <i class="bi bi-whatsapp"></i>
            </div>
            <div class="menu-item-text">
                <div class="menu-item-title">WhatsApp Destek</div>
                <div class="menu-item-subtitle">Destek almak için bize ulaşın</div>
            </div>
        </div>
        <div class="menu-item-arrow">›</div>
    </a>
    @endif
    
    <!-- Çıkış Yap -->
    <div class="menu-item" onclick="handleLogout()" style="border-color: #fee2e2;">
        <div class="menu-item-content">
            <div class="menu-item-icon logout">
                <i class="bi bi-box-arrow-right"></i>
            </div>
            <div class="menu-item-text">
                <div class="menu-item-title" style="color: #dc2626;">Çıkış Yap</div>
                <div class="menu-item-subtitle">Hesabınızdan çıkış yapın</div>
            </div>
        </div>
        <div class="menu-item-arrow" style="color: #dc2626;">›</div>
    </div>
</div>

<!-- Logout Form (Hidden) -->
<form method="POST" action="{{ route('mobile.logout') }}" id="logoutForm" style="display: none;">
    @csrf
</form>

<script>
    function handleLogout() {
        showConfirmModal(
            'Çıkış Yap',
            'Çıkış yapmak istediğinize emin misiniz?',
            function() {
                // Flutter bridge'e mesaj gönder
                if (window.FlutterBridge) {
                    window.FlutterBridge.postMessage('logout');
                }
                
                // Form submit
                document.getElementById('logoutForm').submit();
            }
        );
    }
</script>
@endsection
