@extends('admin.mobile.layouts.app')

@section('title', 'Faturalar')

@push('styles')
<style>
    .invoices-page {
        padding-bottom: 20px;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
        margin: 0;
    }
    
    .back-button {
        background: #e5e7eb;
        color: #4b5563;
        padding: 8px 12px;
        border-radius: 8px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
    }
    
    .back-button:active {
        background: #d1d5db;
        transform: scale(0.98);
    }
    
    .total-amount-card {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        color: white;
        padding: 16px;
        border-radius: 12px;
        margin-bottom: 20px;
    }
    
    .total-amount-label {
        font-size: 14px;
        opacity: 0.9;
        margin-bottom: 4px;
    }
    
    .total-amount-value {
        font-size: 24px;
        font-weight: 700;
    }
    
    .filter-card {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 16px;
        border: 1px solid #e5e7eb;
    }
    
    .filter-group {
        margin-bottom: 12px;
    }
    
    .filter-group:last-child {
        margin-bottom: 0;
    }
    
    .filter-label {
        font-size: 13px;
        font-weight: 600;
        color: #6b7280;
        margin-bottom: 6px;
        display: block;
    }
    
    .form-control, .form-select {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 16px;
        background: white;
    }
    
    .invoice-card {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 12px;
        border: 1px solid #e5e7eb;
        border-left: 4px solid #6b7280;
    }
    
    .invoice-card.paid { border-left-color: #ec4899; }
    .invoice-card.sent { border-left-color: #f472b6; }
    .invoice-card.cancelled { border-left-color: #ef4444; }
    
    .invoice-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 12px;
    }
    
    .invoice-number {
        font-size: 16px;
        font-weight: 700;
        color: #ec4899;
    }
    
    .invoice-date {
        font-size: 12px;
        color: #6b7280;
    }
    
    .invoice-status {
        font-size: 12px;
        padding: 4px 8px;
        border-radius: 6px;
        font-weight: 600;
    }
    
    .badge-info { background: #fce7f3; color: #be185d; }
    .badge-success { background: #fce7f3; color: #be185d; }
    .badge-danger { background: #fee2e2; color: #991b1b; }
    .badge-secondary { background: #f3f4f6; color: #4b5563; }
    
    .invoice-customer {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-bottom: 12px;
    }
    
    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 700;
        font-size: 14px;
    }
    
    .customer-info {
        flex: 1;
    }
    
    .customer-name {
        font-size: 15px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 2px;
    }
    
    .customer-phone {
        font-size: 13px;
        color: #6b7280;
    }
    
    .invoice-amount {
        font-size: 20px;
        font-weight: 700;
        color: #111827;
        margin-bottom: 12px;
    }
    
    .invoice-actions {
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }
    
    .btn-action {
        flex: 1;
        min-width: 80px;
        padding: 10px 12px;
        border-radius: 8px;
        font-size: 13px;
        font-weight: 600;
        text-align: center;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        border: 1px solid #e5e7eb;
        transition: all 0.2s;
    }
    
    .btn-action:active {
        transform: scale(0.98);
    }
    
    .btn-view {
        background: #10b981;
        color: white;
        border-color: #10b981;
    }
    
    .btn-download {
        background: #dc2626;
        color: white;
        border-color: #dc2626;
    }
    
    .btn-delete {
        background: #ef4444;
        color: white;
        border-color: #ef4444;
    }
    
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #6b7280;
    }
    
    .empty-state-icon {
        font-size: 64px;
        margin-bottom: 16px;
        opacity: 0.5;
    }
    
    .empty-state-title {
        font-size: 18px;
        font-weight: 600;
        margin-bottom: 8px;
    }
    
    .empty-state-text {
        font-size: 14px;
    }
</style>
@endpush

@section('content')
<div class="invoices-page">
    <div class="page-header">
        <a href="{{ route('mobile.settings.index') }}" class="back-button">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
        <h1 class="page-title">Faturalar</h1>
    </div>
    
    <!-- Toplam Tutar -->
    <div class="total-amount-card">
        <div class="total-amount-label">Toplam Tutar</div>
        <div class="total-amount-value">{{ number_format($totalAmount ?? 0, 2, ',', '.') }} ₺</div>
    </div>
    
    <!-- Filtreler -->
    <div class="filter-card">
        <form method="GET" action="{{ route('mobile.settings.invoices.index') }}">
            <div class="filter-group">
                <label class="filter-label">Başlangıç Tarihi</label>
                <input type="date" name="start_date" value="{{ request('start_date') }}" class="form-control" onchange="this.form.submit()">
            </div>
            <div class="filter-group">
                <label class="filter-label">Bitiş Tarihi</label>
                <input type="date" name="end_date" value="{{ request('end_date') }}" class="form-control" onchange="this.form.submit()">
            </div>
            <div class="filter-group">
                <label class="filter-label">Sırala</label>
                <select name="sort" class="form-select" onchange="this.form.submit()">
                    <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }}>A-Z (Müşteri)</option>
                    <option value="created_desc" {{ request('sort', 'created_desc') == 'created_desc' ? 'selected' : '' }}>Yeniden Eskiye</option>
                </select>
            </div>
            @if(request('start_date') || request('end_date'))
                <a href="{{ route('mobile.settings.invoices.index') }}" class="btn-action" style="background: #6b7280; color: white; border: none;">
                    <i class="bi bi-x-circle"></i> Filtreleri Temizle
                </a>
            @endif
        </form>
    </div>
    
    <!-- Fatura Listesi -->
    @forelse($invoices as $invoice)
        <div class="invoice-card {{ $invoice->status ?? '' }}">
            <div class="invoice-header">
                <div>
                    <div class="invoice-number">{{ $invoice->invoice_number }}</div>
                    <div class="invoice-date">{{ $invoice->created_at->format('d.m.Y H:i') }}</div>
                </div>
                <div>
                    @if($invoice->status == 'sent')
                        <span class="invoice-status badge-info">
                            <i class="bi bi-send"></i> Gönderildi
                        </span>
                    @elseif($invoice->status == 'paid')
                        <span class="invoice-status badge-success">
                            <i class="bi bi-cash"></i> Ödendi
                        </span>
                    @elseif($invoice->status == 'cancelled')
                        <span class="invoice-status badge-danger">
                            <i class="bi bi-x-circle"></i> İptal
                        </span>
                    @else
                        <span class="invoice-status badge-secondary">
                            <i class="bi bi-file-text"></i> Fatura
                        </span>
                    @endif
                </div>
            </div>
            
            @if($invoice->customer)
                <div class="invoice-customer">
                    <div class="customer-avatar" style="background: {{ $invoice->customer->avatar_color ?? '#10b981' }};">
                        {{ $invoice->customer->initials ?? '??' }}
                    </div>
                    <div class="customer-info">
                        <div class="customer-name">{{ $invoice->customer->name ?? '-' }}</div>
                        <div class="customer-phone">{{ $invoice->customer->phone ?? '-' }}</div>
                    </div>
                </div>
            @endif
            
            @if($invoice->reservation)
                <div style="margin-bottom: 12px; font-size: 13px; color: #6b7280;">
                    <i class="bi bi-calendar"></i> {{ $invoice->reservation->date ? $invoice->reservation->date->format('d.m.Y') : '-' }}
                    @if($invoice->reservation->salon)
                        <span style="margin-left: 8px;">
                            <i class="bi bi-building"></i> {{ $invoice->reservation->salon->name }}
                        </span>
                    @endif
                </div>
            @endif
            
            <div class="invoice-amount">{{ number_format($invoice->total_amount, 2, ',', '.') }} ₺</div>
            
            <div class="invoice-actions">
                @if($invoice->public_url)
                    <button type="button" class="btn-action btn-view" onclick="copyInvoiceLink('{{ $invoice->public_url }}', this)">
                        <i class="bi bi-link-45deg"></i> Linki Kopyala
                    </button>
                @endif
                <button type="button" class="btn-action btn-delete" onclick="deleteInvoice({{ $invoice->id }}, event)">
                    <i class="bi bi-trash"></i> Sil
                </button>
            </div>
        </div>
    @empty
        <div class="empty-state">
            <div class="empty-state-icon">
                <i class="bi bi-receipt"></i>
            </div>
            <div class="empty-state-title">Henüz fatura oluşturulmamış</div>
            <div class="empty-state-text">Randevu oluştururken "Oluştur ve Faturala" butonuna tıklayarak fatura oluşturabilirsiniz.</div>
        </div>
    @endforelse
    
    <!-- Pagination -->
    @if($invoices->hasPages())
        <div style="margin-top: 20px;">
            {{ $invoices->links() }}
        </div>
    @endif
</div>

<script>
    // Fatura linkini kopyala
    function copyInvoiceLink(url, buttonElement) {
        const btn = buttonElement;
        const originalText = btn.innerHTML;
        
        // Clipboard API kullanarak linki kopyala
        if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(url).then(function() {
                // Başarılı - buton metnini değiştir
                btn.innerHTML = '<i class="bi bi-check-circle"></i> Kopyalandı!';
                btn.style.background = '#10b981';
                
                // 2 saniye sonra eski haline dön
                setTimeout(function() {
                    btn.innerHTML = originalText;
                    btn.style.background = '';
                }, 2000);
            }).catch(function(err) {
                console.error('Kopyalama hatası:', err);
                // Fallback: Eski yöntem
                fallbackCopyTextToClipboard(url, btn, originalText);
            });
        } else {
            // Fallback: Eski yöntem
            fallbackCopyTextToClipboard(url, btn, originalText);
        }
    }
    
    // Fallback kopyalama yöntemi (eski tarayıcılar için)
    function fallbackCopyTextToClipboard(text, buttonElement, originalText) {
        const textArea = document.createElement('textarea');
        textArea.value = text;
        textArea.style.position = 'fixed';
        textArea.style.left = '-999999px';
        textArea.style.top = '-999999px';
        document.body.appendChild(textArea);
        textArea.focus();
        textArea.select();
        
        try {
            const successful = document.execCommand('copy');
            if (successful) {
                buttonElement.innerHTML = '<i class="bi bi-check-circle"></i> Kopyalandı!';
                buttonElement.style.background = '#10b981';
                
                setTimeout(function() {
                    buttonElement.innerHTML = originalText;
                    buttonElement.style.background = '';
                }, 2000);
            } else {
                showAlertModal('Hata', 'Link kopyalanamadı. Lütfen manuel olarak kopyalayın.');
            }
        } catch (err) {
            console.error('Kopyalama hatası:', err);
            showAlertModal('Hata', 'Link kopyalanamadı. Lütfen manuel olarak kopyalayın.');
        }
        
        document.body.removeChild(textArea);
    }
    
    function deleteInvoice(invoiceId, event) {
        if (event) {
            event.stopPropagation();
            event.preventDefault();
        }
        
        // Özel onay modal'ı göster
        showConfirmModal(
            'Faturayı Sil',
            'Bu faturayı silmek istediğinize emin misiniz? Bu işlem geri alınamaz.',
            function() {
                const btn = event ? event.target.closest('button') : null;
                const originalText = btn ? btn.innerHTML : '';
                
                if (btn) {
                    btn.disabled = true;
                    btn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;"> Siliniyor...';
                }
                
                const destroyUrl = '{{ url("admin/mobile/settings/invoices") }}/' + invoiceId;
                fetch(destroyUrl, {
                    method: 'DELETE',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        return response.json().then(data => {
                            throw new Error(data.message || 'Bir hata oluştu.');
                        });
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        showAlertModal('Başarılı', 'Fatura başarıyla silindi.', function() {
                            window.location.reload();
                        });
                    } else {
                        showAlertModal('Hata', data.message || 'Fatura silinirken bir hata oluştu.');
                        if (btn) {
                            btn.disabled = false;
                            btn.innerHTML = originalText;
                        }
                    }
                })
                .catch(error => {
                    console.error('Delete Error:', error);
                    showAlertModal('Hata', error.message || 'Bir hata oluştu. Lütfen tekrar deneyin.');
                    if (btn) {
                        btn.disabled = false;
                        btn.innerHTML = originalText;
                    }
                });
            }
        );
    }
</script>
@endsection

