@extends('admin.mobile.layouts.app')

@section('title', 'Üyelik Bilgileri')

@push('styles')
<style>
    .membership-page {
        padding-bottom: 20px;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
        margin: 0;
    }
    
    .back-button {
        background: #e5e7eb;
        color: #4b5563;
        padding: 8px 12px;
        border-radius: 8px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
    }
    
    .back-button:active {
        background: #d1d5db;
        transform: scale(0.98);
    }
    
    .info-card {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 12px;
        border: 1px solid #e5e7eb;
    }
    
    .info-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 0;
        border-bottom: 1px solid #f3f4f6;
    }
    
    .info-item:last-child {
        border-bottom: none;
    }
    
    .info-label {
        font-size: 14px;
        color: #6b7280;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .info-label i {
        font-size: 16px;
        color: #10b981;
    }
    
    .info-value {
        font-size: 15px;
        font-weight: 600;
        color: #111827;
        text-align: right;
    }
    
    .badge-status {
        padding: 4px 12px;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600;
    }
    
    .badge-success {
        background: #d1fae5;
        color: #065f46;
    }
    
    .badge-warning {
        background: #fef3c7;
        color: #92400e;
    }
    
    .badge-danger {
        background: #fee2e2;
        color: #991b1b;
    }
    
    .badge-info {
        background: #dbeafe;
        color: #047857;
    }
    
    .badge-unlimited {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }
    
    .section-title {
        font-size: 18px;
        font-weight: 700;
        color: #111827;
        margin-bottom: 16px;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .section-title i {
        color: #10b981;
        font-size: 20px;
    }
    
    .alert {
        padding: 12px 16px;
        border-radius: 8px;
        margin-bottom: 16px;
        font-size: 14px;
    }
    
    .alert-info {
        background: #eff6ff;
        color: #047857;
        border: 1px solid #dbeafe;
    }
</style>
@endpush

@section('content')
<div class="membership-page">
    <div class="page-header">
        <a href="{{ route('mobile.settings.index') }}" class="back-button">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
        <h1 class="page-title">Üyelik Bilgileri</h1>
    </div>
    
    @if(session('success'))
        <div class="alert alert-success">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-circle"></i> {{ session('error') }}
        </div>
    @endif
    
    <!-- Lisans Bilgileri -->
    <div class="info-card">
        <div class="section-title">
            <i class="bi bi-shield-check"></i>
            Lisans Bilgileri
        </div>
        
        <div class="info-item">
            <div class="info-label">
                <i class="bi bi-shield-check"></i>
                <span>Lisans Durumu</span>
            </div>
            <div class="info-value">
                @if($isUnlimited)
                    <span class="badge-status badge-unlimited">
                        <i class="bi bi-infinity"></i> Sınırsız
                    </span>
                @elseif($licenseExpiresAt)
                    @if($daysRemaining !== null && $daysRemaining < 0)
                        <span class="badge-status badge-danger">
                            <i class="bi bi-x-circle"></i> Süresi Dolmuş
                        </span>
                    @elseif($daysRemaining !== null && $daysRemaining <= 7)
                        <span class="badge-status badge-warning">
                            <i class="bi bi-exclamation-triangle"></i> {{ floor($daysRemaining) }} Gün Kaldı
                        </span>
                    @else
                        <span class="badge-status badge-success">
                            <i class="bi bi-check-circle"></i> Aktif
                        </span>
                    @endif
                @else
                    <span class="badge-status badge-unlimited">
                        <i class="bi bi-infinity"></i> Sınırsız
                    </span>
                @endif
            </div>
        </div>
        
        @if($licenseExpiresAt && !$isUnlimited)
            <div class="info-item">
                <div class="info-label">
                    <i class="bi bi-calendar"></i>
                    <span>Bitiş Tarihi</span>
                </div>
                <div class="info-value">
                    {{ \Carbon\Carbon::parse($licenseExpiresAt)->format('d.m.Y') }}
                </div>
            </div>
            
            @if($daysRemaining !== null)
                <div class="info-item">
                    <div class="info-label">
                        <i class="bi bi-clock"></i>
                        <span>Kalan Süre</span>
                    </div>
                    <div class="info-value">
                        @if($daysRemaining < 0)
                            <span style="color: #dc2626;">{{ abs(floor($daysRemaining)) }} Gün Önce Doldu</span>
                        @else
                            {{ floor($daysRemaining) }} Gün
                        @endif
                    </div>
                </div>
            @endif
        @endif
    </div>
    
    <!-- Kullanıcı Bilgileri -->
    <div class="info-card">
        <div class="section-title">
            <i class="bi bi-person"></i>
            Kullanıcı Bilgileri
        </div>
        
        <div class="info-item">
            <div class="info-label">
                <i class="bi bi-person"></i>
                <span>Kullanıcı Adı</span>
            </div>
            <div class="info-value">{{ $user->name }}</div>
        </div>
        
        <div class="info-item">
            <div class="info-label">
                <i class="bi bi-envelope"></i>
                <span>E-posta</span>
            </div>
            <div class="info-value">{{ $user->email }}</div>
        </div>
        
        @if($user->phone)
            <div class="info-item">
                <div class="info-label">
                    <i class="bi bi-telephone"></i>
                    <span>Telefon</span>
                </div>
                <div class="info-value">{{ $user->phone }}</div>
            </div>
        @endif
        
        <div class="info-item">
            <div class="info-label">
                <i class="bi bi-shield"></i>
                <span>Rol</span>
            </div>
            <div class="info-value">
                @if($user->role === 'super_admin')
                    <span class="badge-status badge-danger">Süper Admin</span>
                @elseif($user->role === 'admin')
                    <span class="badge-status badge-info">Admin</span>
                @else
                    <span class="badge-status badge-info">Randevucu</span>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Bilgilendirme -->
    <div class="alert alert-info">
        <i class="bi bi-info-circle"></i>
        <strong>Lisans Süresi:</strong>
        <p style="margin: 8px 0 0 0; font-size: 13px;">
            @if($isUnlimited)
                Üyeliğiniz sınırsızdır. Süper admin tarafından atanan süreye göre otomatik olarak güncellenir.
            @elseif($licenseExpiresAt)
                Üyeliğiniz süper admin tarafından atanan süreye göre belirlenmiştir.
                @if($daysRemaining !== null && $daysRemaining < 0)
                    <strong style="color: #dc2626;">Lisans süreniz dolmuştur.</strong>
                @elseif($daysRemaining !== null && $daysRemaining <= 7)
                    <strong style="color: #d97706;">Lisans süreniz yakında dolacaktır.</strong>
                @endif
            @else
                Üyeliğiniz sınırsızdır.
            @endif
        </p>
    </div>
</div>
@endsection

