@extends('admin.mobile.layouts.app')

@section('title', 'Profil')

@push('styles')
<style>
    .profile-page {
        padding-bottom: 20px;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
        margin: 0;
    }
    
    .back-button {
        background: #e5e7eb;
        color: #4b5563;
        padding: 8px 12px;
        border-radius: 8px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
    }
    
    .back-button:active {
        background: #d1d5db;
        transform: scale(0.98);
    }
    
    .settings-section {
        margin-bottom: 24px;
    }
    
    .section-header {
        font-size: 18px;
        font-weight: 700;
        color: #111827;
        margin-bottom: 16px;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .section-header i {
        color: #10b981;
        font-size: 20px;
    }
    
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        font-size: 14px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 8px;
    }
    
    .form-control {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 16px;
        background: white;
        -webkit-appearance: none;
        transition: all 0.2s;
    }
    
    .form-control:focus {
        outline: none;
        border-color: #10b981;
        box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
    }
    
    .btn-primary {
        background: #10b981;
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        border: none;
        min-height: 44px;
        width: 100%;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .btn-primary:active {
        background: #047857;
        transform: scale(0.98);
    }
    
    .btn-secondary {
        background: #6b7280;
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        border: none;
        min-height: 44px;
        width: 100%;
        cursor: pointer;
        transition: all 0.2s;
        margin-top: 12px;
    }
    
    .btn-secondary:active {
        background: #4b5563;
        transform: scale(0.98);
    }
    
    .btn-danger {
        background: #dc3545;
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        border: none;
        min-height: 44px;
        width: 100%;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .btn-danger:active {
        background: #c82333;
        transform: scale(0.98);
    }
    
    .action-button {
        background: white;
        border: 1px solid #e5e7eb;
        padding: 16px;
        border-radius: 12px;
        margin-bottom: 12px;
        text-align: left;
        cursor: pointer;
        transition: all 0.2s;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    
    .action-button:active {
        transform: translateX(4px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.12);
        border-color: #10b981;
    }
    
    .action-button-content {
        display: flex;
        align-items: center;
        gap: 12px;
    }
    
    .action-button-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
    }
    
    .action-button-icon.password { background: #fef3c7; color: #d97706; }
    .action-button-icon.phone { background: #dbeafe; color: #10b981; }
    .action-button-icon.delete { background: #fee2e2; color: #dc2626; }
    
    .action-button-text {
        flex: 1;
    }
    
    .action-button-title {
        font-size: 15px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 4px;
    }
    
    .action-button-subtitle {
        font-size: 13px;
        color: #6b7280;
    }
    
    .alert {
        padding: 12px 16px;
        border-radius: 8px;
        margin-bottom: 16px;
        font-size: 14px;
    }
    
    .alert-success {
        background: #d1fae5;
        color: #065f46;
    }
    
    .alert-danger {
        background: #fee2e2;
        color: #991b1b;
    }
    
    .user-avatar {
        border: 3px solid rgba(255, 255, 255, 0.3);
    }
</style>
@endpush

@section('content')
<div class="profile-page">
    <div class="page-header">
        <a href="{{ route('mobile.settings.index') }}" class="back-button">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
        <h1 class="page-title">Profil</h1>
    </div>
    
    @if(session('success'))
        <div class="alert alert-success">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-circle"></i> {{ session('error') }}
        </div>
    @endif
    
    @if($errors->any())
        <div class="alert alert-danger">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    
    <!-- Kullanıcı Profil Kartı -->
    <div class="card settings-section" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border: none; padding: 24px;">
        <div style="display: flex; align-items: center; gap: 16px;">
            <div class="user-avatar" style="width: 80px; height: 80px; border-radius: 50%; background: {{ $user->avatar_color ?? '#10b981' }}; display: flex; align-items: center; justify-content: center; color: white; font-weight: 700; font-size: 32px; flex-shrink: 0; box-shadow: 0 4px 12px rgba(0,0,0,0.15);">
                {{ $user->initials ?? '??' }}
            </div>
            <div style="flex: 1; color: white;">
                <h2 style="margin: 0; font-size: 24px; font-weight: 700; margin-bottom: 4px;">{{ $user->name ?? 'Kullanıcı' }}</h2>
                <p style="margin: 0; font-size: 14px; opacity: 0.9;">{{ $user->email ?? '' }}</p>
                @if($user->phone)
                    <p style="margin: 4px 0 0 0; font-size: 13px; opacity: 0.8;">
                        <i class="bi bi-telephone"></i> {{ $user->phone }}
                    </p>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Profil Bilgileri -->
    <div class="card settings-section">
        <div class="section-header">
            <i class="bi bi-person"></i>
            Profil Bilgileri
        </div>
        <form method="POST" action="{{ route('mobile.settings.profile') }}">
            @csrf
            <div class="form-group">
                <label class="form-label">Ad Soyad</label>
                <input type="text" name="name" class="form-control" value="{{ $user->name ?? '' }}" required>
            </div>
            <div class="form-group">
                <label class="form-label">E-posta</label>
                <input type="email" name="email" class="form-control" value="{{ $user->email ?? '' }}" required>
            </div>
            <button type="submit" class="btn-primary">
                <i class="bi bi-check-circle"></i> Kaydet
            </button>
        </form>
    </div>
    
    <!-- Şifre Değiştir -->
    <div class="card settings-section">
        <button type="button" class="action-button" onclick="openChangePasswordModal()">
            <div class="action-button-content">
                <div class="action-button-icon password">
                    <i class="bi bi-lock"></i>
                </div>
                <div class="action-button-text">
                    <div class="action-button-title">Şifre Değiştir</div>
                    <div class="action-button-subtitle">Hesap şifrenizi değiştirin</div>
                </div>
            </div>
            <div style="color: #9ca3af; font-size: 20px;">›</div>
        </button>
    </div>
    
    <!-- Telefon Değiştir -->
    <div class="card settings-section">
        <button type="button" class="action-button" onclick="openChangePhoneModal()">
            <div class="action-button-content">
                <div class="action-button-icon phone">
                    <i class="bi bi-telephone"></i>
                </div>
                <div class="action-button-text">
                    <div class="action-button-title">Telefon Değiştir</div>
                    <div class="action-button-subtitle">Telefon numaranızı değiştirin</div>
                </div>
            </div>
            <div style="color: #9ca3af; font-size: 20px;">›</div>
        </button>
    </div>
    
    <!-- Hesap Sil -->
    <div class="card settings-section" style="border: 2px solid #dc3545;">
        <button type="button" class="action-button" onclick="openDeleteAccountModal()" style="border-color: #dc3545;">
            <div class="action-button-content">
                <div class="action-button-icon delete">
                    <i class="bi bi-trash"></i>
                </div>
                <div class="action-button-text">
                    <div class="action-button-title" style="color: #dc3545;">Hesabı Sil</div>
                    <div class="action-button-subtitle">Hesabınızı kalıcı olarak silin</div>
                </div>
            </div>
            <div style="color: #dc3545; font-size: 20px;">›</div>
        </button>
    </div>
</div>

<!-- Şifre Değiştir Modal -->
<div class="modal fade" id="changePasswordModal" tabindex="-1" aria-labelledby="changePasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 20px;">
            <div class="modal-header bg-warning text-dark" style="border-radius: 20px 20px 0 0;">
                <h5 class="modal-title" id="changePasswordModalLabel">
                    <i class="bi bi-lock"></i> Şifre Değiştir
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" style="max-height: 70vh; overflow-y: auto; padding-bottom: 20px;">
                <form id="changePasswordForm">
                    <div class="mb-3">
                        <label class="form-label">Mevcut Şifre <span class="text-danger">*</span></label>
                        <input type="password" name="current_password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Yeni Şifre <span class="text-danger">*</span></label>
                        <input type="password" name="password" class="form-control" required minlength="8">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Yeni Şifre (Tekrar) <span class="text-danger">*</span></label>
                        <input type="password" name="password_confirmation" class="form-control" required minlength="8">
                    </div>
                    <div id="changePasswordErrors" class="alert alert-danger" style="display: none;"></div>
                </form>
            </div>
            <div class="modal-footer" style="border-radius: 0 0 20px 20px;">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-warning" onclick="submitChangePassword()">
                    <i class="bi bi-check-circle"></i> Şifre Değiştir
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Telefon Değiştir Modal -->
<div class="modal fade" id="changePhoneModal" tabindex="-1" aria-labelledby="changePhoneModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 20px;">
            <div class="modal-header bg-info text-white" style="border-radius: 20px 20px 0 0;">
                <h5 class="modal-title" id="changePhoneModalLabel">
                    <i class="bi bi-telephone"></i> Telefon Değiştir
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" style="max-height: 70vh; overflow-y: auto; padding-bottom: 20px;">
                <form id="changePhoneForm">
                    <div class="mb-3">
                        <label class="form-label">Mevcut Telefon</label>
                        <input type="tel" class="form-control" value="{{ $user->phone ?? '' }}" readonly style="background: #f3f4f6;">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Yeni Telefon Numarası <span class="text-danger">*</span></label>
                        <input type="tel" name="new_phone" id="new_phone" class="form-control" placeholder="05XX XXX XX XX" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Şifre Doğrulama <span class="text-danger">*</span></label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <div style="display: flex; gap: 8px;">
                            <input type="tel" class="form-control" id="change_phone_display" value="{{ $user->phone ?? '' }}" readonly style="flex: 1; background: #f3f4f6;">
                            <button type="button" class="btn btn-primary" id="sendPhoneOtpBtn" onclick="sendPhoneOtp()" style="width: auto; min-width: 120px;">
                                <i class="bi bi-send"></i> Kod Gönder
                            </button>
                        </div>
                        <small class="text-muted" id="phoneOtpStatus" style="display: block; margin-top: 8px;"></small>
                    </div>
                    <div class="mb-3" id="phoneOtpField" style="display: none;">
                        <label class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                        <input type="text" name="otp_code" id="phone_otp_code" class="form-control" placeholder="6 haneli kodu giriniz" maxlength="6">
                    </div>
                    <div id="changePhoneErrors" class="alert alert-danger" style="display: none;"></div>
                </form>
            </div>
            <div class="modal-footer" style="border-radius: 0 0 20px 20px;">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-primary" onclick="submitChangePhone()">
                    <i class="bi bi-check-circle"></i> Telefon Değiştir
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Hesap Sil Modal -->
<div class="modal fade" id="deleteAccountModal" tabindex="-1" aria-labelledby="deleteAccountModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 20px;">
            <div class="modal-header bg-danger text-white" style="border-radius: 20px 20px 0 0;">
                <h5 class="modal-title" id="deleteAccountModalLabel">
                    <i class="bi bi-exclamation-triangle"></i> Hesabı Sil
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" style="max-height: 70vh; overflow-y: auto; padding-bottom: 20px;">
                <div class="alert alert-warning mb-3">
                    <i class="bi bi-info-circle"></i> <strong>Dikkat!</strong> Bu işlem geri alınamaz. Hesabınız ve tüm verileriniz kalıcı olarak silinecektir.
                </div>
                <form id="deleteAccountForm">
                    <div class="mb-3">
                        <label class="form-label">Şifre Doğrulama <span class="text-danger">*</span></label>
                        <input type="password" name="password" class="form-control" required placeholder="Hesap şifrenizi giriniz">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Telefon Numarası</label>
                        <div style="display: flex; gap: 8px;">
                            <input type="tel" class="form-control" id="delete_phone_display" value="{{ $user->phone ?? '' }}" readonly style="flex: 1; background: #f3f4f6;">
                            <button type="button" class="btn btn-warning" id="sendDeleteOtpBtn" onclick="sendDeleteOtp()" style="width: auto; min-width: 120px;">
                                <i class="bi bi-send"></i> Kod Gönder
                            </button>
                        </div>
                        <small class="text-muted" id="deleteOtpStatus" style="display: block; margin-top: 8px;"></small>
                    </div>
                    <div class="mb-3" id="deleteOtpField" style="display: none;">
                        <label class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                        <input type="text" name="otp_code" id="delete_otp_code" class="form-control" placeholder="6 haneli kodu giriniz" maxlength="6">
                    </div>
                    <div id="deleteAccountErrors" class="alert alert-danger" style="display: none;"></div>
                </form>
            </div>
            <div class="modal-footer" style="border-radius: 0 0 20px 20px;">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-danger" onclick="submitDeleteAccount()">
                    <i class="bi bi-trash"></i> Hesabı Sil
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    function openChangePasswordModal() {
        const modal = new bootstrap.Modal(document.getElementById('changePasswordModal'));
        modal.show();
    }
    
    function openChangePhoneModal() {
        const modal = new bootstrap.Modal(document.getElementById('changePhoneModal'));
        modal.show();
    }
    
    function openDeleteAccountModal() {
        const modal = new bootstrap.Modal(document.getElementById('deleteAccountModal'));
        modal.show();
    }
    
    function submitChangePassword() {
        const form = document.getElementById('changePasswordForm');
        const formData = new FormData(form);
        const submitBtn = event.target;
        const originalText = submitBtn.innerHTML;
        const errorDiv = document.getElementById('changePasswordErrors');
        
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Değiştiriliyor...';
        errorDiv.style.display = 'none';
        
        fetch('{{ route("mobile.settings.password") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => {
            if (!response.ok) {
                return response.text().then(text => {
                    try {
                        return JSON.parse(text);
                    } catch {
                        return { success: false, message: 'Bir hata oluştu.' };
                    }
                });
            }
            return response.json();
        })
        .then(data => {
            if (data.success || !data.errors) {
                // Başarılı - modal'ı kapat ve sayfayı yenile
                bootstrap.Modal.getInstance(document.getElementById('changePasswordModal')).hide();
                setTimeout(() => {
                    window.location.reload();
                }, 500);
            } else {
                // Hata var
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
                
                let errorHtml = '<ul class="mb-0">';
                if (data.errors) {
                    Object.keys(data.errors).forEach(key => {
                        data.errors[key].forEach(error => {
                            errorHtml += '<li>' + error + '</li>';
                        });
                    });
                } else if (data.message) {
                    errorHtml += '<li>' + data.message + '</li>';
                }
                errorHtml += '</ul>';
                errorDiv.innerHTML = errorHtml;
                errorDiv.style.display = 'block';
            }
        })
        .catch(error => {
            console.error('Change Password Error:', error);
            submitBtn.disabled = false;
            submitBtn.innerHTML = originalText;
            errorDiv.innerHTML = '<ul class="mb-0"><li>Bir hata oluştu. Lütfen tekrar deneyin.</li></ul>';
            errorDiv.style.display = 'block';
        });
    }
    
    function sendPhoneOtp() {
        const newPhone = document.getElementById('new_phone').value;
        if (!newPhone) {
            showAlertModal('Uyarı', 'Lütfen yeni telefon numarasını giriniz.');
            return;
        }
        
        const btn = document.getElementById('sendPhoneOtpBtn');
        const status = document.getElementById('phoneOtpStatus');
        
        if (!btn || !status) return;
        
        btn.disabled = true;
        btn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        status.textContent = '';
        
        fetch('{{ route("mobile.settings.phone-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            },
            body: JSON.stringify({ new_phone: newPhone })
        })
        .then(response => response.json())
        .then(data => {
            if (!btn || !status) return;
            
            if (data.success) {
                status.textContent = '✓ Doğrulama kodu gönderildi.';
                status.style.color = '#10b981';
                document.getElementById('phoneOtpField').style.display = 'block';
                btn.innerHTML = '<i class="bi bi-check-circle"></i> Kod Gönderildi';
            } else {
                status.textContent = '✗ ' + (data.message || 'Kod gönderilemedi.');
                status.style.color = '#dc3545';
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Phone OTP Error:', error);
            if (!btn || !status) return;
            
            status.textContent = '✗ Bir hata oluştu.';
            status.style.color = '#dc3545';
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    function submitChangePhone() {
        const form = document.getElementById('changePhoneForm');
        const formData = new FormData(form);
        const submitBtn = event.target;
        const originalText = submitBtn.innerHTML;
        const errorDiv = document.getElementById('changePhoneErrors');
        
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Değiştiriliyor...';
        errorDiv.style.display = 'none';
        
        fetch('{{ route("mobile.settings.phone") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => {
            if (!response.ok) {
                return response.text().then(text => {
                    try {
                        return JSON.parse(text);
                    } catch {
                        return { success: false, message: 'Bir hata oluştu.' };
                    }
                });
            }
            return response.json();
        })
        .then(data => {
            if (data.success || !data.errors) {
                // Başarılı - modal'ı kapat ve sayfayı yenile
                bootstrap.Modal.getInstance(document.getElementById('changePhoneModal')).hide();
                setTimeout(() => {
                    window.location.reload();
                }, 500);
            } else {
                // Hata var
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
                
                let errorHtml = '<ul class="mb-0">';
                if (data.errors) {
                    Object.keys(data.errors).forEach(key => {
                        data.errors[key].forEach(error => {
                            errorHtml += '<li>' + error + '</li>';
                        });
                    });
                } else if (data.message) {
                    errorHtml += '<li>' + data.message + '</li>';
                }
                errorHtml += '</ul>';
                errorDiv.innerHTML = errorHtml;
                errorDiv.style.display = 'block';
            }
        })
        .catch(error => {
            console.error('Change Phone Error:', error);
            submitBtn.disabled = false;
            submitBtn.innerHTML = originalText;
            errorDiv.innerHTML = '<ul class="mb-0"><li>Bir hata oluştu. Lütfen tekrar deneyin.</li></ul>';
            errorDiv.style.display = 'block';
        });
    }
    
    function sendDeleteOtp() {
        const btn = document.getElementById('sendDeleteOtpBtn');
        const status = document.getElementById('deleteOtpStatus');
        
        if (!btn || !status) {
            console.error('Button or status element not found');
            return;
        }
        
        btn.disabled = true;
        btn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        status.textContent = '';
        
        fetch('{{ route("mobile.settings.delete-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (!btn || !status) return;
            
            if (data.success) {
                status.textContent = '✓ Doğrulama kodu gönderildi.';
                status.style.color = '#10b981';
                document.getElementById('deleteOtpField').style.display = 'block';
                btn.innerHTML = '<i class="bi bi-check-circle"></i> Kod Gönderildi';
            } else {
                status.textContent = '✗ ' + (data.message || 'Kod gönderilemedi.');
                status.style.color = '#dc3545';
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Delete OTP Error:', error);
            if (!btn || !status) return;
            
            status.textContent = '✗ Bir hata oluştu.';
            status.style.color = '#dc3545';
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    function submitDeleteAccount() {
        showConfirmModal(
            'Hesabı Sil',
            'Hesabınızı silmek istediğinize emin misiniz? Bu işlem geri alınamaz!',
            function() {
                showConfirmModal(
                    'Son Onay',
                    'Son bir kez daha onaylıyor musunuz? Hesabınız kalıcı olarak silinecek!',
                    function() {
                        const form = document.getElementById('deleteAccountForm');
                        const formData = new FormData(form);
                        const submitBtn = document.querySelector('#deleteAccountForm button[type="submit"]');
                        const originalText = submitBtn.innerHTML;
                        const errorDiv = document.getElementById('deleteAccountErrors');
                        
                        submitBtn.disabled = true;
                        submitBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Siliniyor...';
                        errorDiv.style.display = 'none';
        
        fetch('{{ route("mobile.settings.destroy") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'X-HTTP-Method-Override': 'DELETE'
            }
        })
        .then(response => {
            if (response.redirected) {
                // Flutter bridge'e mesaj gönder
                if (window.FlutterBridge) {
                    window.FlutterBridge.postMessage('logout');
                }
                window.location.href = response.url;
                return;
            }
            if (!response.ok) {
                return response.text().then(text => {
                    try {
                        return JSON.parse(text);
                    } catch {
                        return { success: false, message: 'Bir hata oluştu.' };
                    }
                });
            }
            return response.json();
        })
        .then(data => {
            if (data && data.success) {
                // Flutter bridge'e mesaj gönder
                if (window.FlutterBridge) {
                    window.FlutterBridge.postMessage('logout');
                }
                window.location.href = data.redirect || '/admin/mobile/login';
            } else {
                // Hata var
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
                
                let errorHtml = '<ul class="mb-0">';
                if (data && data.errors) {
                    Object.keys(data.errors).forEach(key => {
                        data.errors[key].forEach(error => {
                            errorHtml += '<li>' + error + '</li>';
                        });
                    });
                } else if (data && data.message) {
                    errorHtml += '<li>' + data.message + '</li>';
                } else {
                    errorHtml += '<li>Bir hata oluştu. Lütfen tekrar deneyin.</li>';
                }
                errorHtml += '</ul>';
                errorDiv.innerHTML = errorHtml;
                errorDiv.style.display = 'block';
            }
        })
        .catch(error => {
            console.error('Delete Account Error:', error);
            submitBtn.disabled = false;
            submitBtn.innerHTML = originalText;
            errorDiv.innerHTML = '<ul class="mb-0"><li>Bir hata oluştu. Lütfen tekrar deneyin.</li></ul>';
            errorDiv.style.display = 'block';
        });
    }
</script>
@endsection

