@extends('admin.mobile.layouts.app')

@section('title', 'Salon Düzenle')

@push('styles')
<style>
    .salon-edit-page {
        padding-bottom: 20px;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
        margin: 0;
    }
    
    .back-button {
        background: #e5e7eb;
        color: #4b5563;
        padding: 8px 12px;
        border-radius: 8px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
    }
    
    .back-button:active {
        background: #d1d5db;
        transform: scale(0.98);
    }
    
    .form-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        border: 1px solid #e5e7eb;
    }
    
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        display: block;
        font-size: 14px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 8px;
    }
    
    .form-control {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 16px;
        background: white;
        transition: all 0.2s;
    }
    
    .form-control:focus {
        outline: none;
        border-color: #10b981;
        box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
    }
    
    .btn-primary {
        background: #f59e0b;
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        border: none;
        min-height: 44px;
        width: 100%;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .btn-primary:active {
        background: #d97706;
        transform: scale(0.98);
    }
    
    .alert {
        padding: 12px 16px;
        border-radius: 8px;
        margin-bottom: 16px;
        font-size: 14px;
    }
    
    .alert-danger {
        background: #fee2e2;
        color: #991b1b;
    }
</style>
@endpush

@section('content')
<div class="salon-edit-page">
    <div class="page-header">
        <a href="{{ route('mobile.settings.salons.show', $salon->id) }}" class="back-button">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
        <h1 class="page-title">Salon Düzenle</h1>
    </div>
    
    @if($errors->any())
        <div class="alert alert-danger">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    
    <div class="form-card">
        <form method="POST" action="{{ route('mobile.settings.salons.update', $salon->id) }}">
            @csrf
            @method('PUT')
            
            <div class="form-group">
                <label class="form-label">Salon Adı <span style="color: #dc2626;">*</span></label>
                <input type="text" name="name" class="form-control" value="{{ old('name', $salon->name) }}" required>
            </div>
            
            <div class="form-group">
                <label class="form-label">Telefon Numarası <span style="color: #dc2626;">*</span></label>
                <input type="text" name="phone" class="form-control" value="{{ old('phone', $salon->phone) }}" placeholder="05XX XXX XX XX" required>
            </div>
            
            <div class="form-group">
                <label class="form-label">Adres <span style="color: #dc2626;">*</span></label>
                <textarea name="address" class="form-control" rows="3" placeholder="Salon adresi" required>{{ old('address', $salon->address) }}</textarea>
            </div>
            
            <button type="submit" class="btn-primary">
                <i class="bi bi-check-circle"></i> Güncelle
            </button>
        </form>
    </div>
</div>
@endsection

