@extends('admin.mobile.layouts.app')

@section('title', 'Salon Yönetimi')

@push('styles')
<style>
    .salons-page {
        padding-bottom: 20px;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
        margin: 0;
    }
    
    .back-button {
        background: #e5e7eb;
        color: #4b5563;
        padding: 8px 12px;
        border-radius: 8px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
    }
    
    .back-button:active {
        background: #d1d5db;
        transform: scale(0.98);
    }
    
    .salon-card {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 12px;
        border: 1px solid #e5e7eb;
        border-left: 4px solid #f59e0b;
    }
    
    .salon-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 12px;
    }
    
    .salon-name {
        font-size: 18px;
        font-weight: 700;
        color: #111827;
        margin-bottom: 4px;
    }
    
    .salon-status {
        padding: 4px 10px;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600;
    }
    
    .status-active {
        background: #d1fae5;
        color: #065f46;
    }
    
    .status-inactive {
        background: #f3f4f6;
        color: #6b7280;
    }
    
    .salon-info {
        margin-bottom: 12px;
    }
    
    .info-row {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 8px;
        font-size: 14px;
    }
    
    .info-row i {
        color: #10b981;
        font-size: 16px;
        width: 20px;
    }
    
    .info-row-label {
        color: #6b7280;
        min-width: 80px;
    }
    
    .info-row-value {
        color: #111827;
        font-weight: 500;
        flex: 1;
    }
    
    .salon-actions {
        display: flex;
        gap: 8px;
        margin-top: 12px;
        padding-top: 12px;
        border-top: 1px solid #f3f4f6;
    }
    
    .btn-action {
        flex: 1;
        padding: 10px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        text-align: center;
        text-decoration: none;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        border: 1px solid #e5e7eb;
        transition: all 0.2s;
    }
    
    .btn-action:active {
        transform: scale(0.98);
    }
    
    .btn-edit {
        background: #fef3c7;
        color: #d97706;
        border-color: #fef3c7;
    }
    
    .btn-view {
        background: #dbeafe;
        color: #10b981;
        border-color: #dbeafe;
    }
    
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #6b7280;
    }
    
    .empty-state-icon {
        font-size: 64px;
        margin-bottom: 16px;
        opacity: 0.5;
    }
    
    .empty-state-title {
        font-size: 18px;
        font-weight: 600;
        margin-bottom: 8px;
    }
    
    .empty-state-text {
        font-size: 14px;
    }
</style>
@endpush

@section('content')
<div class="salons-page">
    <div class="page-header">
        <a href="{{ route('mobile.settings.index') }}" class="back-button">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
        <h1 class="page-title">Salon Yönetimi</h1>
    </div>
    
    @if(session('success'))
        <div class="alert alert-success">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-circle"></i> {{ session('error') }}
        </div>
    @endif
    
    @forelse($salons as $salon)
        <div class="salon-card">
            <div class="salon-header">
                <div style="flex: 1;">
                    <div class="salon-name">{{ $salon->name }}</div>
                </div>
                <div>
                    <span class="salon-status {{ $salon->is_active ? 'status-active' : 'status-inactive' }}">
                        <i class="bi bi-{{ $salon->is_active ? 'check-circle' : 'x-circle' }}"></i>
                        {{ $salon->is_active ? 'Aktif' : 'Pasif' }}
                    </span>
                </div>
            </div>
            
            <div class="salon-info">
                <div class="info-row">
                    <i class="bi bi-telephone"></i>
                    <span class="info-row-label">Telefon:</span>
                    <span class="info-row-value">{{ $salon->phone ?? '-' }}</span>
                </div>
                
                <div class="info-row">
                    <i class="bi bi-geo-alt"></i>
                    <span class="info-row-label">Adres:</span>
                    <span class="info-row-value">{{ $salon->address ?? '-' }}</span>
                </div>
            </div>
            
            <div class="salon-actions">
                <a href="{{ route('mobile.settings.salons.show', $salon->id) }}" class="btn-action btn-view">
                    <i class="bi bi-eye"></i> Görüntüle
                </a>
                <a href="{{ route('mobile.settings.salons.edit', $salon->id) }}" class="btn-action btn-edit">
                    <i class="bi bi-pencil"></i> Düzenle
                </a>
            </div>
        </div>
    @empty
        <div class="empty-state">
            <div class="empty-state-icon">
                <i class="bi bi-building"></i>
            </div>
            <div class="empty-state-title">Henüz salon oluşturulmamış</div>
            <div class="empty-state-text">İlk salonunuzu oluşturmak için zorunlu salon oluşturma ekranını kullanın.</div>
        </div>
    @endforelse
</div>
@endsection

