@extends('admin.mobile.layouts.app')

@section('title', 'Salon Detayı')

@push('styles')
<style>
    .salon-detail-page {
        padding-bottom: 20px;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
        margin: 0;
    }
    
    .back-button {
        background: #e5e7eb;
        color: #4b5563;
        padding: 8px 12px;
        border-radius: 8px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
    }
    
    .back-button:active {
        background: #d1d5db;
        transform: scale(0.98);
    }
    
    .info-card {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 12px;
        border: 1px solid #e5e7eb;
    }
    
    .info-item {
        display: flex;
        align-items: flex-start;
        gap: 12px;
        padding: 12px 0;
        border-bottom: 1px solid #f3f4f6;
    }
    
    .info-item:last-child {
        border-bottom: none;
    }
    
    .info-icon {
        color: #10b981;
        font-size: 20px;
        margin-top: 2px;
        flex-shrink: 0;
    }
    
    .info-content {
        flex: 1;
    }
    
    .info-label {
        font-size: 13px;
        color: #6b7280;
        margin-bottom: 4px;
    }
    
    .info-value {
        font-size: 15px;
        font-weight: 600;
        color: #111827;
    }
    
    .status-badge {
        padding: 4px 12px;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 4px;
    }
    
    .status-active {
        background: #d1fae5;
        color: #065f46;
    }
    
    .status-inactive {
        background: #f3f4f6;
        color: #6b7280;
    }
    
    .btn-edit {
        background: #f59e0b;
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        border: none;
        width: 100%;
        margin-top: 16px;
        transition: all 0.2s;
    }
    
    .btn-edit:active {
        background: #d97706;
        transform: scale(0.98);
    }
</style>
@endpush

@section('content')
<div class="salon-detail-page">
    <div class="page-header">
        <a href="{{ route('mobile.settings.salons.index') }}" class="back-button">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
        <h1 class="page-title">Salon Detayı</h1>
    </div>
    
    <div class="info-card">
        <div class="info-item">
            <i class="bi bi-building info-icon"></i>
            <div class="info-content">
                <div class="info-label">Salon Adı</div>
                <div class="info-value">{{ $salon->name }}</div>
            </div>
        </div>
        
        <div class="info-item">
            <i class="bi bi-telephone info-icon"></i>
            <div class="info-content">
                <div class="info-label">Telefon Numarası</div>
                <div class="info-value">{{ $salon->phone ?? '-' }}</div>
            </div>
        </div>
        
        <div class="info-item">
            <i class="bi bi-geo-alt info-icon"></i>
            <div class="info-content">
                <div class="info-label">Adres</div>
                <div class="info-value">{{ $salon->address ?? '-' }}</div>
            </div>
        </div>
        
        <div class="info-item">
            <i class="bi bi-check-circle info-icon"></i>
            <div class="info-content">
                <div class="info-label">Durum</div>
                <div class="info-value">
                    <span class="status-badge {{ $salon->is_active ? 'status-active' : 'status-inactive' }}">
                        <i class="bi bi-{{ $salon->is_active ? 'check-circle' : 'x-circle' }}"></i>
                        {{ $salon->is_active ? 'Aktif' : 'Pasif' }}
                    </span>
                </div>
            </div>
        </div>
    </div>
    
    <a href="{{ route('mobile.settings.salons.edit', $salon->id) }}" class="btn-edit">
        <i class="bi bi-pencil"></i> Salonu Düzenle
    </a>
</div>
@endsection

