@extends('layouts.admin')

@section('title', 'Bildirimler')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="bi bi-bell"></i> Bildirimler</h2>
        </div>
        
        <div class="card shadow-sm">
            <div class="card-body">
                @if(count($notifications) > 0)
                    <div class="list-group">
                        @foreach($notifications as $notification)
                            <a href="{{ $notification['url'] }}" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between align-items-start">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <i class="bi bi-{{ $notification['icon'] }} text-{{ $notification['color'] }}" style="font-size: 24px;"></i>
                                        </div>
                                        <div>
                                            <h6 class="mb-1">{{ $notification['title'] }}</h6>
                                            <p class="mb-1 text-muted">{{ $notification['message'] }}</p>
                                        </div>
                                    </div>
                                    <small class="text-muted">{{ $notification['date']->diffForHumans() }}</small>
                                </div>
                            </a>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="bi bi-bell-slash" style="font-size: 64px; color: #ccc;"></i>
                        <p class="text-muted mt-3">Henüz bildirim bulunmamaktadır.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

