@extends('layouts.admin')

@section('title', 'Paket Seçimi')
@section('page-title', 'Paket Seçimi')

@section('content')
<div class="container-fluid">
    <div class="mb-4">
        <h2 class="fw-bold mb-2" style="color: #ec4899;">
            <i class="bi bi-box-seam me-2"></i>Paket Seçimi
        </h2>
        <p class="text-muted mb-0">
            @if(!empty($freeCampaignActive))
                Ücretsiz kullanım süreniz aktif. Bitişinde güncel paketlerden birini seçebilirsiniz.
            @else
                Devam edebilmek için bir paket seçin ve satın alın veya kupon kodunuz varsa uygulayın.
            @endif
        </p>
    </div>

    @if(!empty($freeCampaignActive))
    <div class="alert alert-success border-0 mb-4" style="background:#ecfdf3;color:#166534;">
        <i class="bi bi-gift me-2"></i>
        Hesabınızda ücretsiz kullanım süresi aktif. Bu süre boyunca fiyatlandırma uygulanmaz.
    </div>
    @endif

    @if(!$freeCampaignActive)
    <div class="card shadow-sm border-0 mb-4" style="border-radius: 16px; border: 2px dashed #ec4899 !important;">
        <div class="card-body p-4">
            <div class="d-flex align-items-center mb-3">
                <div class="rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 48px; height: 48px; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
                    <i class="bi bi-tag-fill text-white" style="font-size: 1.25rem;"></i>
                </div>
                <div>
                    <h5 class="fw-bold mb-0" style="color: #be185d;">Kupon kodunuz var mı?</h5>
                    <p class="text-muted small mb-0">Kodu girerek ücretsiz kullanım süresi veya SMS hakkı kazanabilirsiniz.</p>
                </div>
            </div>
            <div class="row align-items-end g-2">
                <div class="col-md-8">
                    <label class="form-label small text-muted">Kupon kodu</label>
                    <input type="text" id="couponCodeInput" class="form-control form-control-lg" placeholder="Örn: HOSGELDIN30" maxlength="64" style="border-radius: 12px;">
                    <div id="couponMessage" class="small mt-2"></div>
                </div>
                <div class="col-md-4">
                    <button type="button" id="couponApplyBtn" class="btn btn-lg w-100 text-white" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 12px;">
                        <i class="bi bi-check2-circle me-2"></i>Uygula
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    @if($packages->count() > 0)
    <div class="row g-4 justify-content-center">
        @php
            $sortedPackages = $packages->sortBy(function($pkg) {
                return $pkg->is_popular ? 1 : ($pkg->sort_order == 1 ? 0 : 2);
            });
        @endphp
        @foreach($sortedPackages as $package)
        <div class="col-12 col-md-6 col-lg-4">
            <div class="card shadow-sm h-100 border-0 {{ $package->is_popular ? 'border-primary border-3' : '' }}" style="border-radius: 16px; overflow: hidden; transition: all 0.3s;">
                <div class="card-body p-4" style="height: 100%;">
                    @if($package->is_popular)
                    <div class="text-center mb-3">
                        <span class="badge" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); padding: 0.5rem 1.5rem; font-size: 0.9rem;">
                            <i class="bi bi-star-fill me-1"></i> Popüler
                        </span>
                    </div>
                    @endif
                    <div class="text-center mb-4">
                        <h4 class="fw-bold text-dark mb-2">{{ $package->name }}</h4>
                        @if($package->description)
                        <p class="text-muted small mb-3">{{ $package->description }}</p>
                        @endif
                        <div class="mb-2">
                            @if($package->original_price && $package->original_price > $package->price)
                            <span class="text-decoration-line-through text-muted me-2">{{ number_format($package->original_price, 0, ',', '.') }} ₺</span>
                            <span class="badge bg-danger">%{{ $package->discount_percentage }} İndirim</span>
                            @endif
                        </div>
                        <h3 class="fw-bold mb-0" style="color: #ec4899;">{{ $package->formatted_price }}</h3>
                        @if($package->price > 0)
                        <small class="text-muted">/{{ $package->price_period_text }}</small>
                        @endif
                    </div>
                    @if($package->features && count($package->features) > 0)
                    <ul class="list-unstyled mb-4" style="max-height: 200px; overflow-y: auto;">
                        @foreach($package->features as $feature)
                        <li class="py-2 d-flex align-items-center">
                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                            <span class="small">{{ is_array($feature) ? ($feature['name'] ?? $feature['text'] ?? '') : $feature }}</span>
                        </li>
                        @endforeach
                    </ul>
                    @endif
                    <a href="{{ route('payment.checkout.package', $package->id) }}" class="btn btn-lg w-100 text-white d-block text-center text-decoration-none" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 12px; font-weight: 600; padding: 14px;">
                        @if(!empty($freeCampaignActive))
                            <i class="bi bi-clock-history me-2"></i>Kampanya Sonrası Geçiş
                        @else
                            <i class="bi bi-cart-plus me-2"></i>Satın Al
                        @endif
                    </a>
                </div>
            </div>
        </div>
        @endforeach
    </div>
    @else
    <div class="card shadow-sm border-0">
        <div class="card-body text-center py-5">
            <i class="bi bi-box-seam text-muted" style="font-size: 4rem;"></i>
            <h4 class="mt-3 text-muted">Henüz paket bulunmuyor</h4>
            <p class="text-muted mb-4">Paketler yakında eklenecektir. Lütfen daha sonra tekrar deneyin.</p>
            <a href="{{ route('admin.dashboard') }}" class="btn btn-primary">
                <i class="bi bi-arrow-left me-2"></i>Panele Dön
            </a>
        </div>
    </div>
    @endif
</div>

@if(!$freeCampaignActive)
@push('scripts')
<script>
(function() {
    var btn = document.getElementById('couponApplyBtn');
    var input = document.getElementById('couponCodeInput');
    var msg = document.getElementById('couponMessage');
    if (!btn || !input) return;
    btn.addEventListener('click', function() {
        var code = (input.value || '').trim();
        if (!code) {
            msg.innerHTML = '<span class="text-danger">Kupon kodu giriniz.</span>';
            return;
        }
        msg.innerHTML = '';
        btn.disabled = true;
        fetch('{{ route("admin.packages.coupon.apply") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Accept': 'application/json',
            },
            body: JSON.stringify({ code: code })
        })
        .then(function(r) { return r.json().then(function(d) { return { ok: r.ok, status: r.status, data: d }; }); })
        .then(function(res) {
            if (res.ok && res.data.success) {
                msg.innerHTML = '<span class="text-success">' + (res.data.message || 'Kupon uygulandı.') + '</span>';
                if (res.data.redirect) {
                    setTimeout(function() { window.location.href = res.data.redirect; }, 1200);
                }
            } else {
                msg.innerHTML = '<span class="text-danger">' + (res.data.message || 'Kupon uygulanamadı.') + '</span>';
                btn.disabled = false;
            }
        })
        .catch(function() {
            msg.innerHTML = '<span class="text-danger">Bir hata oluştu. Tekrar deneyin.</span>';
            btn.disabled = false;
        });
    });
    input.addEventListener('keydown', function(e) {
        if (e.key === 'Enter') btn.click();
    });
})();
</script>
@endpush
@endif
@endsection
