@extends('layouts.admin')

@section('title', 'Yeni Personel Ekle')
@section('page-title', 'Yeni Personel Ekle')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Personel Bilgileri</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.beauty-salon.personel.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <!-- Profil Fotoğrafı -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <label class="form-label fw-bold mb-3">
                                    <i class="bi bi-image me-2"></i>Profil Fotoğrafı
                                </label>
                                <div class="profile-image-upload-container">
                                    <div class="profile-image-preview-wrapper" id="profileImageClickArea" role="button" tabindex="0" aria-label="Profil fotoğrafı seç">
                                        <div class="profile-image-ring">
                                            <div id="profileImagePreview" class="profile-image-placeholder">
                                                <i class="bi bi-person-circle"></i>
                                                <span>Profil Fotoğrafı Yok</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-image-upload-controls">
                                        <input type="file" id="profile_image" name="profile_image" accept="image/jpeg,image/png,image/jpg,image/gif,image/webp" class="d-none" onchange="handleProfileImageUpload(this)">
                                        <button type="button" class="btn btn-outline-primary btn-sm px-3" onclick="document.getElementById('profile_image').click()">
                                            <i class="bi bi-upload me-2"></i>Fotoğraf Seç
                                        </button>
                                        <button type="button" id="removeProfileImageBtn" class="btn btn-outline-danger btn-sm px-3 d-none" onclick="clearProfileImage()">
                                            <i class="bi bi-trash me-2"></i>Kaldır
                                        </button>
                                    </div>
                                    <small id="profileImageMeta" class="text-muted d-block mt-1 text-center">
                                        <i class="bi bi-info-circle me-1"></i>Maksimum 5 MB. Desteklenen formatlar: JPG, PNG, GIF, WEBP.
                                    </small>
                                    @error('profile_image')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label">Ad Soyad <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                                @error('name')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label">E-posta <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" id="email" name="email" value="{{ old('email') }}" required>
                                @error('email')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label">Telefon</label>
                                <input type="tel" class="form-control" id="phone" name="phone" value="{{ old('phone') }}">
                                @error('phone')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="password" class="form-label">Şifre <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="password" name="password" required>
                                @error('password')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="password_confirmation" class="form-label">Şifre Tekrar <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required>
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">
                                <i class="bi bi-scissors me-2"></i>Hizmetler <span class="text-danger">*</span>
                            </label>
                            <div class="services-selection-container border rounded p-3" style="background-color: #f8fafc; min-height: 200px; max-height: 400px; overflow-y: auto;">
                                @if($services && $services->count() > 0)
                                    <div class="row g-2">
                                        @foreach($services as $service)
                                            <div class="col-md-6 col-lg-4">
                                                <div class="service-checkbox-card" data-service-id="{{ $service->id }}">
                                                    <input type="checkbox" 
                                                           name="service_ids[]" 
                                                           value="{{ $service->id }}" 
                                                           id="service_{{ $service->id }}"
                                                           class="service-checkbox d-none">
                                                    <label for="service_{{ $service->id }}" class="service-label w-100 mb-0" style="cursor: pointer;">
                                                        <div class="d-flex align-items-center justify-content-between p-3 rounded border" style="background: white; transition: all 0.3s;">
                                                            <div class="flex-grow-1">
                                                                <strong class="d-block mb-1">{{ $service->name }}</strong>
                                                                <small class="text-muted d-block">
                                                                    <i class="bi bi-currency-exchange"></i> {{ number_format($service->price, 2, ',', '.') }} ₺
                                                                    @if($service->duration)
                                                                        <span class="ms-2"><i class="bi bi-clock"></i> {{ $service->duration }} dk</span>
                                                                    @endif
                                                                </small>
                                                            </div>
                                                            <div class="check-icon-wrapper ms-2">
                                                                <i class="bi bi-check-circle-fill" style="font-size: 24px; color: #ec4899; opacity: 0; transition: opacity 0.3s;"></i>
                                                            </div>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <div class="text-center py-4">
                                        <p class="text-muted mb-3">
                                            <i class="bi bi-info-circle me-2"></i>Henüz hizmet tanımlanmamış.
                                        </p>
                                        <a href="{{ route('admin.beauty-salon.services.create') }}" class="btn btn-sm btn-primary">
                                            <i class="bi bi-plus-circle me-1"></i>Hizmet Oluştur
                                        </a>
                                    </div>
                                @endif
                            </div>
                            <small class="text-muted d-block mt-2">
                                <i class="bi bi-info-circle me-1"></i>Personelin yapabileceği hizmetleri seçin. Bu hizmetler randevu oluştururken görünecektir.
                            </small>
                            @error('service_ids')
                                <div class="text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save me-2"></i>Kaydet
                            </button>
                            <a href="{{ route('admin.beauty-salon.personel.index') }}" class="btn btn-secondary">
                                <i class="bi bi-x me-2"></i>İptal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .profile-image-upload-container {
        display: flex;
        flex-direction: column;
        gap: 14px;
        padding: 24px;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border-radius: 16px;
        border: 2px dashed #e5e7eb;
        transition: all 0.3s ease;
    }
    
    .profile-image-upload-container:hover {
        border-color: #ec4899;
        background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%);
    }
    
    .profile-image-preview-wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 180px;
        cursor: pointer;
        outline: none;
    }

    .profile-image-preview-wrapper:focus-visible .profile-image-ring {
        box-shadow: 0 0 0 4px rgba(236, 72, 153, 0.25);
    }

    .profile-image-ring {
        width: 160px;
        height: 160px;
        border-radius: 50%;
        border: 4px solid #f9a8d4;
        background: #fff;
        padding: 3px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: transform 0.25s ease, box-shadow 0.25s ease;
    }

    .profile-image-upload-container:hover .profile-image-ring {
        transform: scale(1.02);
        box-shadow: 0 8px 24px rgba(236, 72, 153, 0.25);
    }
    
    .profile-image-preview {
        width: 146px;
        height: 146px;
        border-radius: 50%;
        object-fit: cover;
        border: 2px solid #ec4899;
        display: block;
    }
    
    .profile-image-placeholder {
        width: 146px;
        height: 146px;
        border-radius: 50%;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        color: white;
        text-align: center;
        padding: 10px;
    }

    .profile-image-placeholder i {
        font-size: 60px;
        line-height: 1;
    }

    .profile-image-placeholder span {
        margin-top: 6px;
        font-size: 12px;
        font-weight: 500;
    }
    
    .profile-image-upload-controls {
        display: flex;
        gap: 10px;
        justify-content: center;
        flex-wrap: wrap;
    }

    @media (max-width: 576px) {
        .profile-image-upload-container {
            padding: 16px;
        }
        .profile-image-ring {
            width: 136px;
            height: 136px;
        }
        .profile-image-preview,
        .profile-image-placeholder {
            width: 122px;
            height: 122px;
        }
        .profile-image-placeholder i {
            font-size: 46px;
        }
    }
    
    /* Admin Toggle Switch */
    .admin-toggle-container {
        position: relative;
    }
    
    .admin-toggle-input {
        position: absolute;
        opacity: 0;
        width: 0;
        height: 0;
    }
    
    .admin-toggle-label {
        display: flex;
        align-items: center;
        gap: 12px;
        cursor: pointer;
        padding: 12px 20px;
        background: linear-gradient(135deg, #f8fafc 0%, #e5e7eb 100%);
        border: 2px solid #e5e7eb;
        border-radius: 12px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }
    
    .admin-toggle-label:hover {
        border-color: #ec4899;
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.15);
    }
    
    .admin-toggle-input:checked + .admin-toggle-label {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border-color: #ec4899;
        box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);
    }
    
    .admin-toggle-slider {
        position: relative;
        width: 50px;
        height: 28px;
        background: #cbd5e1;
        border-radius: 14px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        flex-shrink: 0;
    }
    
    .admin-toggle-slider::before {
        content: '';
        position: absolute;
        width: 22px;
        height: 22px;
        border-radius: 50%;
        background: white;
        top: 3px;
        left: 3px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .admin-toggle-slider {
        background: rgba(255, 255, 255, 0.3);
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .admin-toggle-slider::before {
        transform: translateX(22px);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);
    }
    
    .admin-toggle-text {
        display: flex;
        align-items: center;
        font-weight: 600;
        color: #374151;
        transition: color 0.3s;
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .admin-toggle-text {
        color: white;
    }
    
    .toggle-text-off,
    .toggle-text-on {
        transition: opacity 0.3s, transform 0.3s;
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .toggle-text-off {
        opacity: 0;
        transform: translateX(-10px);
        position: absolute;
    }
    
    .admin-toggle-input:not(:checked) + .admin-toggle-label .toggle-text-on {
        opacity: 0;
        transform: translateX(10px);
        position: absolute;
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .toggle-text-on {
        opacity: 1;
        transform: translateX(0);
    }
    
    .admin-toggle-input:not(:checked) + .admin-toggle-label .toggle-text-off {
        opacity: 1;
        transform: translateX(0);
    }
    
    /* Services Selection */
    .services-selection-container {
        scrollbar-width: thin;
        scrollbar-color: #ec4899 #f8fafc;
    }
    
    .services-selection-container::-webkit-scrollbar {
        width: 8px;
    }
    
    .services-selection-container::-webkit-scrollbar-track {
        background: #f8fafc;
        border-radius: 4px;
    }
    
    .services-selection-container::-webkit-scrollbar-thumb {
        background: #ec4899;
        border-radius: 4px;
    }
    
    .services-selection-container::-webkit-scrollbar-thumb:hover {
        background: #be185d;
    }
    
    .service-checkbox-card {
        margin-bottom: 8px;
    }
    
    .service-label {
        margin: 0;
    }
    
    .service-label > div {
        border: 2px solid #e5e7eb !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .service-label:hover > div {
        border-color: #ec4899 !important;
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.15);
        transform: translateY(-2px);
    }
    
    .service-checkbox-card.selected .service-label > div {
        border-color: #ec4899 !important;
        background: linear-gradient(135deg, rgba(236, 72, 153, 0.05) 0%, rgba(190, 24, 93, 0.05) 100%) !important;
        box-shadow: 0 4px 16px rgba(236, 72, 153, 0.2);
    }
    
    .service-checkbox-card.selected .check-icon-wrapper i {
        opacity: 1 !important;
        animation: checkBounce 0.4s ease;
    }
    
    @keyframes checkBounce {
        0% { transform: scale(0.5); opacity: 0; }
        50% { transform: scale(1.2); }
        100% { transform: scale(1); opacity: 1; }
    }
    
    .service-checkbox:checked + .service-label > div {
        border-color: #ec4899 !important;
        background: linear-gradient(135deg, rgba(236, 72, 153, 0.05) 0%, rgba(190, 24, 93, 0.05) 100%) !important;
    }
</style>
@endpush

@push('scripts')
<script>
    function handleProfileImageUpload(input) {
        if (input.files && input.files[0]) {
            const file = input.files[0];
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('profileImagePreview');
                if (preview.tagName === 'IMG') {
                    preview.src = e.target.result;
                } else {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.className = 'profile-image-preview';
                    img.id = 'profileImagePreview';
                    preview.parentNode.replaceChild(img, preview);
                }

                const removeBtn = document.getElementById('removeProfileImageBtn');
                if (removeBtn) {
                    removeBtn.classList.remove('d-none');
                }

                const meta = document.getElementById('profileImageMeta');
                if (meta) {
                    meta.innerHTML = '<i class="bi bi-check-circle me-1 text-success"></i>Seçilen dosya: <strong>' + file.name + '</strong>';
                }
            };
            reader.readAsDataURL(file);
        }
    }

    function clearProfileImage() {
        const input = document.getElementById('profile_image');
        if (input) {
            input.value = '';
        }

        const preview = document.getElementById('profileImagePreview');
        if (preview) {
            const placeholder = document.createElement('div');
            placeholder.id = 'profileImagePreview';
            placeholder.className = 'profile-image-placeholder';
            placeholder.innerHTML = '<i class="bi bi-person-circle"></i><span>Profil Fotoğrafı Yok</span>';
            preview.parentNode.replaceChild(placeholder, preview);
        }

        const removeBtn = document.getElementById('removeProfileImageBtn');
        if (removeBtn) {
            removeBtn.classList.add('d-none');
        }

        const meta = document.getElementById('profileImageMeta');
        if (meta) {
            meta.innerHTML = '<i class="bi bi-info-circle me-1"></i>Maksimum 5 MB. Desteklenen formatlar: JPG, PNG, GIF, WEBP.';
        }
    }
    
    document.addEventListener('DOMContentLoaded', function() {
        const clickArea = document.getElementById('profileImageClickArea');
        if (clickArea) {
            clickArea.addEventListener('click', function() {
                document.getElementById('profile_image').click();
            });
            clickArea.addEventListener('keydown', function(e) {
                if (e.key === 'Enter' || e.key === ' ') {
                    e.preventDefault();
                    document.getElementById('profile_image').click();
                }
            });
        }

        // Şifre ve şifre tekrarı kontrolü
        const passwordInput = document.getElementById('password');
        const passwordConfirmationInput = document.getElementById('password_confirmation');
        const form = document.querySelector('form[action*="personel.store"]');
        
        function validatePasswords() {
            const password = passwordInput.value;
            const passwordConfirmation = passwordConfirmationInput.value;
            
            // Şifre tekrarı alanından hata mesajını kaldır
            let errorDiv = passwordConfirmationInput.parentElement.querySelector('.password-error');
            if (errorDiv) {
                errorDiv.remove();
            }
            
            // Şifreler eşleşmiyorsa hata göster
            if (password && passwordConfirmation && password !== passwordConfirmation) {
                errorDiv = document.createElement('div');
                errorDiv.className = 'text-danger small password-error';
                errorDiv.textContent = 'Şifreler eşleşmiyor!';
                passwordConfirmationInput.parentElement.appendChild(errorDiv);
                passwordConfirmationInput.setCustomValidity('Şifreler eşleşmiyor');
                return false;
            } else {
                passwordConfirmationInput.setCustomValidity('');
                return true;
            }
        }
        
        passwordInput.addEventListener('input', validatePasswords);
        passwordConfirmationInput.addEventListener('input', validatePasswords);
        
        // Form submit kontrolü
        if (form) {
            form.addEventListener('submit', function(e) {
                if (!validatePasswords()) {
                    e.preventDefault();
                    e.stopPropagation();
                    return false;
                }
                
                // Hizmet seçimi kontrolü
                const selectedServices = document.querySelectorAll('.service-checkbox:checked');
                if (selectedServices.length === 0) {
                    e.preventDefault();
                    e.stopPropagation();
                    alert('Lütfen en az bir hizmet seçin!');
                    return false;
                }
            });
        }
        
        // Hizmet checkbox'larına tıklandığında görsel güncelleme
        const serviceCheckboxes = document.querySelectorAll('.service-checkbox');
        const serviceCards = document.querySelectorAll('.service-checkbox-card');
        
        serviceCheckboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                const card = this.closest('.service-checkbox-card');
                if (this.checked) {
                    card.classList.add('selected');
                } else {
                    card.classList.remove('selected');
                }
            });
        });
        
        // Label'a tıklandığında checkbox'ı toggle et
        serviceCards.forEach(card => {
            const label = card.querySelector('.service-label');
            if (label) {
                label.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    const checkbox = card.querySelector('.service-checkbox');
                    if (checkbox) {
                        checkbox.checked = !checkbox.checked;
                        checkbox.dispatchEvent(new Event('change', { bubbles: true }));
                    }
                });
            }
        });
    });
</script>
@endpush
@endsection

