@extends('layouts.admin')

@section('title', 'Personel Düzenle')
@section('page-title', 'Personel Düzenle')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white">
                        <i class="bi bi-person-gear me-2"></i>Personel Bilgileri
                    </h5>
                </div>
                <div class="card-body p-4">
                    <form action="{{ route('admin.beauty-salon.personel.update', $personel->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        
                        <!-- Profil Fotoğrafı -->
                        <div class="personel-photo-section mb-4">
                            <label class="form-label fw-bold mb-3">
                                <i class="bi bi-image me-2"></i>Profil Fotoğrafı
                            </label>
                            <div class="personel-photo-box">
                                <div class="personel-photo-preview-wrapper" id="profileImageClickArea" role="button" tabindex="0" aria-label="Profil fotoğrafını değiştir">
                                    <div class="personel-photo-ring">
                                        @if($personel->profile_image)
                                            <img src="{{ asset('storage/' . $personel->profile_image) }}" alt="Profil" id="profileImagePreview" class="personel-photo-img">
                                        @else
                                            <div id="profileImagePreview" class="personel-photo-placeholder">
                                                <i class="bi bi-person-circle"></i>
                                                <span>Profil Fotoğrafı Yok</span>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="personel-photo-actions">
                                    <input type="file" id="profile_image" name="profile_image" accept="image/jpeg,image/png,image/jpg,image/gif,image/webp" class="d-none" onchange="handleProfileImageUpload(this)">
                                    <div class="d-flex gap-2 flex-wrap">
                                        <button type="button" class="btn btn-outline-primary btn-sm px-3" onclick="document.getElementById('profile_image').click()">
                                            <i class="bi bi-upload me-1"></i>Fotoğraf Seç
                                        </button>
                                        <button type="button" id="removeProfileImageBtn" class="btn btn-outline-danger btn-sm px-3 {{ $personel->profile_image ? '' : 'd-none' }}" onclick="removeProfileImage()">
                                            <i class="bi bi-trash me-1"></i>Kaldır
                                        </button>
                                    </div>
                                    <small id="profileImageMeta" class="text-muted d-block mt-2">
                                        @if($personel->profile_image)
                                            <i class="bi bi-check-circle me-1 text-success"></i>Mevcut profil fotoğrafı kullanılıyor.
                                        @else
                                            <i class="bi bi-info-circle me-1"></i>JPG, PNG, GIF, WEBP – max. 5 MB.
                                        @endif
                                    </small>
                                </div>
                            </div>
                            @error('profile_image')
                                <div class="text-danger small mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label fw-semibold">
                                    <i class="bi bi-person me-1"></i>Ad Soyad <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control form-control-lg" id="name" name="name" value="{{ old('name', $personel->name) }}" required>
                                @error('name')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label fw-semibold">
                                    <i class="bi bi-envelope me-1"></i>E-posta <span class="text-danger">*</span>
                                </label>
                                <input type="email" class="form-control form-control-lg" id="email" name="email" value="{{ old('email', $personel->email) }}" required>
                                @error('email')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label fw-semibold">
                                    <i class="bi bi-telephone me-1"></i>Telefon
                                </label>
                                <input type="tel" class="form-control form-control-lg" id="phone" name="phone" value="{{ old('phone', $personel->phone) }}">
                                @error('phone')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="password" class="form-label fw-semibold">
                                    <i class="bi bi-lock me-1"></i>Yeni Şifre
                                </label>
                                <input type="password" class="form-control form-control-lg" id="password" name="password" placeholder="Değiştirmek istemiyorsanız boş bırakın">
                                @error('password')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="password_confirmation" class="form-label fw-semibold">
                                    <i class="bi bi-lock-fill me-1"></i>Şifre Tekrar
                                </label>
                                <input type="password" class="form-control form-control-lg" id="password_confirmation" name="password_confirmation">
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">
                                <i class="bi bi-scissors me-2"></i>Hizmetler <span class="text-danger">*</span>
                            </label>
                            <div class="services-selection-container border rounded p-3" style="background-color: #f8fafc; min-height: 200px; max-height: 400px; overflow-y: auto;">
                                @if($allServices && $allServices->count() > 0)
                                    <div class="row g-2">
                                        @foreach($allServices as $service)
                                            @php
                                                $isSelected = $personelServices->contains('id', $service->id);
                                            @endphp
                                            <div class="col-md-6 col-lg-4">
                                                <div class="service-checkbox-card {{ $isSelected ? 'selected' : '' }}" data-service-id="{{ $service->id }}">
                                                    <input type="checkbox" 
                                                           name="service_ids[]" 
                                                           value="{{ $service->id }}" 
                                                           id="service_{{ $service->id }}"
                                                           {{ $isSelected ? 'checked' : '' }}
                                                           class="service-checkbox d-none">
                                                    <label for="service_{{ $service->id }}" class="service-label w-100 mb-0" style="cursor: pointer;">
                                                        <div class="d-flex align-items-center justify-content-between p-3 rounded border" style="background: white; transition: all 0.3s;">
                                                            <div class="flex-grow-1">
                                                                <strong class="d-block mb-1">{{ $service->name }}</strong>
                                                                <small class="text-muted d-block">
                                                                    <i class="bi bi-currency-exchange"></i> {{ number_format($service->price, 2, ',', '.') }} ₺
                                                                    @if($service->duration)
                                                                        <span class="ms-2"><i class="bi bi-clock"></i> {{ $service->duration }} dk</span>
                                                                    @endif
                                                                </small>
                                                            </div>
                                                            <div class="check-icon-wrapper ms-2">
                                                                <i class="bi bi-check-circle-fill" style="font-size: 24px; color: #ec4899; opacity: {{ $isSelected ? '1' : '0' }}; transition: opacity 0.3s;"></i>
                                                            </div>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <div class="text-center py-4">
                                        <p class="text-muted mb-3">
                                            <i class="bi bi-info-circle me-2"></i>Henüz hizmet tanımlanmamış.
                                        </p>
                                        <a href="{{ route('admin.beauty-salon.services.create') }}" class="btn btn-sm btn-primary">
                                            <i class="bi bi-plus-circle me-1"></i>Hizmet Oluştur
                                        </a>
                                    </div>
                                @endif
                            </div>
                            <small class="text-muted d-block mt-2">
                                <i class="bi bi-info-circle me-1"></i>Personelin yapabileceği hizmetleri seçin. Bu hizmetler randevu oluştururken görünecektir.
                            </small>
                            @error('service_ids')
                                <div class="text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mt-4 d-flex gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-save me-2"></i>Güncelle
                            </button>
                            <a href="{{ route('admin.beauty-salon.personel.index') }}" class="btn btn-secondary btn-lg">
                                <i class="bi bi-arrow-left me-2"></i>Geri Dön
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .services-selection-container {
        scrollbar-width: thin;
        scrollbar-color: #ec4899 #f8fafc;
    }
    
    .services-selection-container::-webkit-scrollbar {
        width: 8px;
    }
    
    .services-selection-container::-webkit-scrollbar-track {
        background: #f8fafc;
        border-radius: 4px;
    }
    
    .services-selection-container::-webkit-scrollbar-thumb {
        background: #ec4899;
        border-radius: 4px;
    }
    
    .services-selection-container::-webkit-scrollbar-thumb:hover {
        background: #be185d;
    }
    
    .service-checkbox-card {
        margin-bottom: 8px;
    }
    
    .service-label {
        margin: 0;
    }
    
    .service-label > div {
        border: 2px solid #e5e7eb !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .service-label:hover > div {
        border-color: #ec4899 !important;
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.15);
        transform: translateY(-2px);
    }
    
    .service-checkbox-card.selected .service-label > div {
        border-color: #ec4899 !important;
        background: linear-gradient(135deg, rgba(236, 72, 153, 0.05) 0%, rgba(190, 24, 93, 0.05) 100%) !important;
        box-shadow: 0 4px 16px rgba(236, 72, 153, 0.2);
    }
    
    .service-checkbox-card.selected .check-icon-wrapper i {
        opacity: 1 !important;
        animation: checkBounce 0.4s ease;
    }
    
    @keyframes checkBounce {
        0% { transform: scale(0.5); opacity: 0; }
        50% { transform: scale(1.2); }
        100% { transform: scale(1); opacity: 1; }
    }
    
    .service-checkbox:checked + .service-label > div {
        border-color: #ec4899 !important;
        background: linear-gradient(135deg, rgba(236, 72, 153, 0.05) 0%, rgba(190, 24, 93, 0.05) 100%) !important;
    }
    
    /* Admin Toggle Switch */
    .admin-toggle-container {
        position: relative;
    }
    
    .admin-toggle-input {
        position: absolute;
        opacity: 0;
        width: 0;
        height: 0;
    }
    
    .admin-toggle-label {
        display: flex;
        align-items: center;
        gap: 12px;
        cursor: pointer;
        padding: 12px 20px;
        background: linear-gradient(135deg, #f8fafc 0%, #e5e7eb 100%);
        border: 2px solid #e5e7eb;
        border-radius: 12px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }
    
    .admin-toggle-label:hover {
        border-color: #ec4899;
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.15);
    }
    
    .admin-toggle-input:checked + .admin-toggle-label {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border-color: #ec4899;
        box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);
    }
    
    .admin-toggle-slider {
        position: relative;
        width: 50px;
        height: 28px;
        background: #cbd5e1;
        border-radius: 14px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        flex-shrink: 0;
    }
    
    .admin-toggle-slider::before {
        content: '';
        position: absolute;
        width: 22px;
        height: 22px;
        border-radius: 50%;
        background: white;
        top: 3px;
        left: 3px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .admin-toggle-slider {
        background: rgba(255, 255, 255, 0.3);
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .admin-toggle-slider::before {
        transform: translateX(22px);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);
    }
    
    .admin-toggle-text {
        display: flex;
        align-items: center;
        font-weight: 600;
        color: #374151;
        transition: color 0.3s;
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .admin-toggle-text {
        color: white;
    }
    
    .toggle-text-off,
    .toggle-text-on {
        transition: opacity 0.3s, transform 0.3s;
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .toggle-text-off {
        opacity: 0;
        transform: translateX(-10px);
        position: absolute;
    }
    
    .admin-toggle-input:not(:checked) + .admin-toggle-label .toggle-text-on {
        opacity: 0;
        transform: translateX(10px);
        position: absolute;
    }
    
    .admin-toggle-input:checked + .admin-toggle-label .toggle-text-on {
        opacity: 1;
        transform: translateX(0);
    }
    
    .admin-toggle-input:not(:checked) + .admin-toggle-label .toggle-text-off {
        opacity: 1;
        transform: translateX(0);
    }
</style>
@endpush

@push('styles')
<style>
    .personel-photo-section .form-label { font-size: 1rem; }
    
    .personel-photo-box {
        display: flex;
        align-items: center;
        gap: 24px;
        padding: 20px;
        background: #f8fafc;
        border-radius: 12px;
        border: 1px solid #e2e8f0;
    }
    
    .personel-photo-preview-wrapper {
        flex-shrink: 0;
        cursor: pointer;
        outline: none;
    }

    .personel-photo-preview-wrapper:focus-visible .personel-photo-ring {
        box-shadow: 0 0 0 4px rgba(236, 72, 153, 0.25);
    }

    .personel-photo-ring {
        width: 132px;
        height: 132px;
        border-radius: 50%;
        border: 4px solid #f9a8d4;
        background: #fff;
        padding: 3px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: transform 0.25s ease, box-shadow 0.25s ease;
    }

    .personel-photo-box:hover .personel-photo-ring {
        transform: scale(1.02);
        box-shadow: 0 8px 24px rgba(236, 72, 153, 0.2);
    }

    .personel-photo-preview {
        flex-shrink: 0;
        width: 96px;
        height: 96px;
        border-radius: 50%;
        overflow: hidden;
        cursor: pointer;
        border: 3px solid #e2e8f0;
        transition: border-color 0.2s, transform 0.2s;
    }
    
    .personel-photo-preview:hover {
        border-color: #ec4899;
        transform: scale(1.02);
    }
    
    .personel-photo-img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
        border-radius: 50%;
        width: 118px;
        height: 118px;
        border: 2px solid #ec4899;
    }
    
    .personel-photo-placeholder {
        width: 118px;
        height: 118px;
        border-radius: 50%;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 12px;
        font-weight: 500;
        text-align: center;
        padding: 8px;
    }
    
    .personel-photo-placeholder i {
        font-size: 48px;
        margin-bottom: 4px;
    }
    
    .personel-photo-actions {
        display: flex;
        flex-direction: column;
        gap: 8px;
        min-width: 240px;
    }
    
    .personel-photo-actions .btn { white-space: nowrap; }

    @media (max-width: 768px) {
        .personel-photo-box {
            flex-direction: column;
            align-items: stretch;
            gap: 14px;
        }
        .personel-photo-preview-wrapper {
            display: flex;
            justify-content: center;
        }
        .personel-photo-actions {
            min-width: auto;
        }
    }
    
    .form-control-lg {
        border-radius: 12px;
        border: 2px solid #e5e7eb;
        transition: all 0.3s ease;
    }
    
    .form-control-lg:focus {
        border-color: #ec4899;
        box-shadow: 0 0 0 0.2rem rgba(236, 72, 153, 0.25);
    }
    
    .card {
        border-radius: 16px;
        overflow: hidden;
    }
    
    .btn-lg {
        border-radius: 12px;
        padding: 12px 24px;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    
    .btn-primary {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border: none;
    }
    
    .btn-primary:hover {
        background: linear-gradient(135deg, #be185d 0%, #9f1239 100%);
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(236, 72, 153, 0.4);
    }
</style>
@endpush

@push('scripts')
<script>
    function handleProfileImageUpload(input) {
        if (input.files && input.files[0]) {
            const file = input.files[0];
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('profileImagePreview');
                if (preview.tagName === 'IMG') {
                    preview.src = e.target.result;
                } else {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.className = 'personel-photo-img';
                    img.id = 'profileImagePreview';
                    img.alt = 'Profil';
                    preview.parentNode.replaceChild(img, preview);
                }

                const removeBtn = document.getElementById('removeProfileImageBtn');
                if (removeBtn) {
                    removeBtn.classList.remove('d-none');
                }

                const meta = document.getElementById('profileImageMeta');
                if (meta) {
                    meta.innerHTML = '<i class="bi bi-check-circle me-1 text-success"></i>Seçilen dosya: <strong>' + file.name + '</strong>';
                }
            };
            reader.readAsDataURL(file);
        }
    }
    
    function removeProfileImage() {
        if (confirm('Profil fotoğrafını kaldırmak istediğinize emin misiniz?')) {
            const input = document.getElementById('profile_image');
            input.value = '';
            const preview = document.getElementById('profileImagePreview');
            const placeholder = document.createElement('div');
            placeholder.id = 'profileImagePreview';
            placeholder.className = 'personel-photo-placeholder';
            placeholder.innerHTML = '<i class="bi bi-person-circle"></i><span>Profil Fotoğrafı Yok</span>';
            preview.parentNode.replaceChild(placeholder, preview);

            const removeBtn = document.getElementById('removeProfileImageBtn');
            if (removeBtn) {
                removeBtn.classList.add('d-none');
            }

            const meta = document.getElementById('profileImageMeta');
            if (meta) {
                meta.innerHTML = '<i class="bi bi-info-circle me-1"></i>JPG, PNG, GIF, WEBP – max. 5 MB.';
            }
        }
    }
    
    document.addEventListener('DOMContentLoaded', function() {
        const clickArea = document.getElementById('profileImageClickArea');
        if (clickArea) {
            clickArea.addEventListener('click', function() {
                document.getElementById('profile_image').click();
            });
            clickArea.addEventListener('keydown', function(e) {
                if (e.key === 'Enter' || e.key === ' ') {
                    e.preventDefault();
                    document.getElementById('profile_image').click();
                }
            });
        }
        
        // Hizmet checkbox'larına tıklandığında görsel güncelleme
        // Hizmet checkbox'larına tıklandığında görsel güncelleme
        const serviceCheckboxes = document.querySelectorAll('.service-checkbox');
        const serviceCards = document.querySelectorAll('.service-checkbox-card');
        
        serviceCheckboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                const card = this.closest('.service-checkbox-card');
                if (this.checked) {
                    card.classList.add('selected');
                } else {
                    card.classList.remove('selected');
                }
            });
        });
        
        // Label'a tıklandığında checkbox'ı toggle et
        serviceCards.forEach(card => {
            const label = card.querySelector('.service-label');
            label.addEventListener('click', function(e) {
                // Eğer checkbox'a tıklandıysa zaten toggle olacak
                const checkbox = card.querySelector('.service-checkbox');
                if (e.target !== checkbox && !checkbox.contains(e.target)) {
                    checkbox.checked = !checkbox.checked;
                    checkbox.dispatchEvent(new Event('change'));
                }
            });
        });
    });
</script>
@endpush
@endsection

