@extends('layouts.admin')

@section('title', 'Personel Yönetimi')
@section('page-title', 'Personel Yönetimi')

@section('content')
<style>
    .personel-card {
        border: none;
        border-radius: 20px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
        overflow: hidden;
        background: white;
        height: 100%;
    }
    
    .personel-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 40px rgba(236, 72, 153, 0.2);
    }
    
    .personel-avatar {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 700;
        font-size: 28px;
        background: linear-gradient(135deg, var(--avatar-color) 0%, var(--avatar-color-dark) 100%);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
        flex-shrink: 0;
        position: relative;
        overflow: hidden;
    }
    
    .personel-avatar img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .personel-avatar::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    }
    
    .personel-info h5 {
        font-size: 1.25rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.5rem;
    }
    
    .personel-info .email {
        color: #6b7280;
        font-size: 0.875rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-bottom: 0.25rem;
    }
    
    .personel-info .phone {
        color: #6b7280;
        font-size: 0.875rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .service-badge {
        display: inline-flex;
        align-items: center;
        padding: 0.375rem 0.75rem;
        border-radius: 12px;
        font-size: 0.75rem;
        font-weight: 600;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        color: white;
        border: none;
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.2);
    }
    
    .service-badge-secondary {
        background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
        box-shadow: 0 2px 8px rgba(107, 114, 128, 0.2);
    }
    
    .action-btn {
        border-radius: 12px;
        padding: 0.5rem 1rem;
        font-weight: 600;
        transition: all 0.2s ease;
        border: none;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }
    
    .action-btn-info {
        background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        color: white;
    }
    
    .action-btn-warning {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        color: white;
    }
    
    .action-btn-danger {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: white;
    }
    
    .action-btn-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
    }
    
    .stats-card {
        background: linear-gradient(135deg, #fce7f3 0%, #fdf2f8 100%);
        border-radius: 16px;
        padding: 1.5rem;
        border: 2px solid #fce7f3;
    }
    
    .stats-number {
        font-size: 2rem;
        font-weight: 800;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .stats-label {
        color: #6b7280;
        font-size: 0.875rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    @media (max-width: 768px) {
        .personel-card {
            margin-bottom: 1.5rem;
        }
        
        .personel-avatar {
            width: 64px;
            height: 64px;
            font-size: 24px;
        }
        
        .action-btn {
            flex: 1;
        }
    }
    
    .empty-state {
        padding: 4rem 2rem;
        text-align: center;
    }
    
    .empty-state-icon {
        font-size: 5rem;
        opacity: 0.3;
        color: #ec4899;
        margin-bottom: 1.5rem;
    }
</style>

<div class="container-fluid">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-3">
        <div>
            <h2 class="fw-bold mb-2" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; font-size: 2rem;">
                <i class="bi bi-people-fill me-2"></i> Personel Yönetimi
            </h2>
            <p class="text-muted mb-0">Ekibinizi yönetin ve organize edin</p>
        </div>
        <a href="{{ route('admin.beauty-salon.personel.create') }}" class="btn btn-primary btn-lg" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 12px; padding: 0.75rem 1.5rem; font-weight: 600; box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);">
            <i class="bi bi-person-plus-fill me-2"></i>Yeni Personel Ekle
        </a>
    </div>

    @if($personels->count() > 0)
        <!-- Desktop Grid View -->
        <div class="row d-none d-lg-flex">
            @foreach($personels as $personel)
                @php
                    $avatarColor = $personel->avatar_color ?? '#ec4899';
                    $avatarColorDark = $avatarColor;
                    $initials = $personel->initials ?? strtoupper(mb_substr($personel->name, 0, 2));
                @endphp
                <div class="col-lg-4 col-xl-3 mb-4">
                    <div class="personel-card" style="--avatar-color: {{ $avatarColor }}; --avatar-color-dark: {{ $avatarColorDark }};">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-start gap-3 mb-4">
                                <div class="personel-avatar" style="background: linear-gradient(135deg, {{ $avatarColor }} 0%, {{ $avatarColorDark }} 100%);">
                                    @if($personel->profile_image)
                                        <img src="{{ Storage::url($personel->profile_image) }}" alt="{{ $personel->name }}">
                                    @else
                                        {{ $initials }}
                                    @endif
                                </div>
                                <div class="personel-info flex-grow-1">
                                    <h5>{{ $personel->name }}</h5>
                                    <div class="email">
                                        <i class="bi bi-envelope"></i>
                                        <span>{{ Str::limit($personel->email, 25) }}</span>
                                    </div>
                                    @if($personel->phone)
                                        <div class="phone">
                                            <i class="bi bi-telephone"></i>
                                            <span>{{ $personel->phone }}</span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            
                            @if($personel->services && $personel->services->count() > 0)
                                <div class="mb-4">
                                    <div class="d-flex flex-wrap gap-2 align-items-center">
                                        @foreach($personel->services->take(3) as $service)
                                            <span class="service-badge">
                                                <i class="bi bi-check-circle me-1"></i>{{ Str::limit($service->name, 15) }}
                                            </span>
                                        @endforeach
                                        @if($personel->services->count() > 3)
                                            <span class="service-badge service-badge-secondary">
                                                +{{ $personel->services->count() - 3 }} daha
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            @else
                                <div class="mb-4">
                                    <span class="text-muted small">
                                        <i class="bi bi-info-circle me-1"></i>Henüz hizmet atanmamış
                                    </span>
                                </div>
                            @endif
                            
                            <div class="d-flex gap-2">
                                <a href="{{ route('admin.beauty-salon.personel.show', $personel->id) }}" class="action-btn action-btn-info flex-fill text-decoration-none text-center">
                                    <i class="bi bi-eye"></i>
                                    <span class="d-none d-sm-inline">Görüntüle</span>
                                </a>
                                <button type="button" class="action-btn action-btn-success" onclick='openLeaveModal({{ $personel->id }}, @json($personel->name))'>
                                    <i class="bi bi-calendar-x"></i>
                                </button>
                                <a href="{{ route('admin.beauty-salon.personel.edit', $personel->id) }}" class="action-btn action-btn-warning text-decoration-none">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <button type="button" class="action-btn action-btn-danger" onclick="confirmDeletePersonel({{ $personel->id }}, '{{ $personel->name }}')">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        
        <!-- Mobile/Tablet Cards -->
        <div class="d-lg-none">
            @foreach($personels as $personel)
                @php
                    $avatarColor = $personel->avatar_color ?? '#ec4899';
                    $avatarColorDark = $avatarColor;
                    $initials = $personel->initials ?? strtoupper(mb_substr($personel->name, 0, 2));
                @endphp
                <div class="card personel-card mb-3" style="--avatar-color: {{ $avatarColor }}; --avatar-color-dark: {{ $avatarColorDark }};">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-start gap-3 mb-3">
                            <div class="personel-avatar" style="background: linear-gradient(135deg, {{ $avatarColor }} 0%, {{ $avatarColorDark }} 100%);">
                                @if($personel->profile_image)
                                    <img src="{{ Storage::url($personel->profile_image) }}" alt="{{ $personel->name }}">
                                @else
                                    {{ $initials }}
                                @endif
                            </div>
                            <div class="personel-info flex-grow-1">
                                <h5>{{ $personel->name }}</h5>
                                <div class="email">
                                    <i class="bi bi-envelope"></i>
                                    <span>{{ $personel->email }}</span>
                                </div>
                                @if($personel->phone)
                                    <div class="phone">
                                        <i class="bi bi-telephone"></i>
                                        <span>{{ $personel->phone }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                        
                        @if($personel->services && $personel->services->count() > 0)
                            <div class="mb-3">
                                <div class="d-flex flex-wrap gap-2">
                                    @foreach($personel->services->take(3) as $service)
                                        <span class="service-badge">
                                            <i class="bi bi-check-circle me-1"></i>{{ Str::limit($service->name, 20) }}
                                        </span>
                                    @endforeach
                                    @if($personel->services->count() > 3)
                                        <span class="service-badge service-badge-secondary">
                                            +{{ $personel->services->count() - 3 }} daha
                                        </span>
                                    @endif
                                </div>
                            </div>
                        @else
                            <div class="mb-3">
                                <span class="text-muted small">
                                    <i class="bi bi-info-circle me-1"></i>Henüz hizmet atanmamış
                                </span>
                            </div>
                        @endif
                        
                        <div class="d-flex gap-2">
                            <a href="{{ route('admin.beauty-salon.personel.show', $personel->id) }}" class="action-btn action-btn-info flex-fill text-decoration-none text-center">
                                <i class="bi bi-eye me-1"></i>Görüntüle
                            </a>
                            <button type="button" class="action-btn action-btn-success" onclick='openLeaveModal({{ $personel->id }}, @json($personel->name))'>
                                <i class="bi bi-calendar-x"></i>
                            </button>
                            <a href="{{ route('admin.beauty-salon.personel.edit', $personel->id) }}" class="action-btn action-btn-warning text-decoration-none">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <button type="button" class="action-btn action-btn-danger" onclick="confirmDeletePersonel({{ $personel->id }}, '{{ $personel->name }}')">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="card border-0 shadow-sm">
            <div class="card-body empty-state">
                <div class="empty-state-icon">
                    <i class="bi bi-people"></i>
                </div>
                <h4 class="fw-bold mb-3" style="color: #1f2937;">Henüz personel eklenmemiş</h4>
                <p class="text-muted mb-4">Ekibinize personel ekleyerek başlayın. Personellerinize hizmet atayabilir ve randevularını yönetebilirsiniz.</p>
                <a href="{{ route('admin.beauty-salon.personel.create') }}" class="btn btn-primary btn-lg" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 12px; padding: 0.75rem 2rem; font-weight: 600; box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);">
                    <i class="bi bi-person-plus-fill me-2"></i>İlk Personeli Ekle
                </a>
            </div>
        </div>
    @endif
</div>

<!-- İzin ve Randevu Aktarım Modal -->
<div class="modal fade" id="leaveModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 16px;">
            <div class="modal-header">
                <h5 class="modal-title fw-bold"><i class="bi bi-calendar-x me-2"></i>Personel İzin İşlemi</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="leaveAlertBox" class="alert py-2" style="display:none;"></div>
                <input type="hidden" id="leavePersonelId">
                <div class="mb-3">
                    <label class="form-label fw-semibold">Personel</label>
                    <input type="text" id="leavePersonelName" class="form-control" readonly>
                </div>
                <div class="row g-2 mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">İzin Günü</label>
                        <input type="date" id="leaveDate" class="form-control">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Not (Opsiyonel)</label>
                        <input type="text" id="leaveNote" class="form-control" placeholder="Açıklama">
                    </div>
                </div>

                <div id="leaveTransferSection" style="display:none;">
                    <div class="alert alert-warning py-2 mb-2">
                        <strong>Seçilen günde aktif randevular var.</strong> İzin öncesi randevu aktarımı yapmanız gerekir.
                    </div>
                    <div class="mb-2">
                        <label class="form-label fw-semibold">Hedef Personel</label>
                        <select id="transferTargetPersonel" class="form-select">
                            <option value="">Personel seçin</option>
                        </select>
                    </div>
                    <div class="mb-2">
                        <label class="form-label fw-semibold">O gün randevu aktarımı</label>
                        <div id="transferAppointmentList" class="border rounded p-2" style="max-height:180px; overflow:auto;"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light border" data-bs-dismiss="modal">Kapat</button>
                <button type="button" id="cancelLeaveBtn" class="btn btn-danger" style="display:none;">İzni İptal Et</button>
                <button type="button" id="saveLeaveBtn" class="btn btn-primary">İzni Kaydet</button>
            </div>
        </div>
    </div>
</div>

<!-- Silme Onay Modalı -->
<div class="modal fade" id="deletePersonelModal" tabindex="-1" aria-labelledby="deletePersonelModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 20px;">
            <div class="modal-header border-0" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 20px 20px 0 0;">
                <h5 class="modal-title text-white fw-bold" id="deletePersonelModalLabel">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i>Personel Silme Onayı
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <p id="deletePersonelMessage" class="mb-3 fw-semibold" style="color: #1f2937;"></p>
                <div class="alert alert-warning border-0 mb-0" style="background: #fef3c7; border-radius: 12px;">
                    <i class="bi bi-info-circle-fill me-2"></i>
                    <strong>Uyarı:</strong> Bu işlem geri alınamaz! Personelin tüm verileri kalıcı olarak silinecektir.
                </div>
            </div>
            <div class="modal-footer border-0">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 12px; padding: 0.5rem 1.5rem; font-weight: 600;">
                    <i class="bi bi-x-lg me-1"></i>İptal
                </button>
                <form id="deletePersonelForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border: none; border-radius: 12px; padding: 0.5rem 1.5rem; font-weight: 600; box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);">
                        <i class="bi bi-trash-fill me-1"></i>Evet, Sil
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function confirmDeletePersonel(id, name) {
    const modalElement = document.getElementById('deletePersonelModal');
    if (!modalElement) {
        console.error('deletePersonelModal bulunamadı');
        return;
    }
    
    const modal = new bootstrap.Modal(modalElement);
    const form = document.getElementById('deletePersonelForm');
    const message = document.getElementById('deletePersonelMessage');
    
    message.textContent = `"${name}" adlı personeli silmek istediğinizden emin misiniz?`;
    form.action = `{{ url('admin/guzellik-salonu/personel') }}/${id}`;
    
    modal.show();
}

function showLeaveAlert(message, type = 'info') {
    const el = document.getElementById('leaveAlertBox');
    if (!el) return;
    const map = {
        info: 'alert-info',
        success: 'alert-success',
        warning: 'alert-warning',
        error: 'alert-danger'
    };
    el.className = `alert ${map[type] || 'alert-info'} py-2`;
    el.textContent = message;
    el.style.display = 'block';
}

function hideLeaveAlert() {
    const el = document.getElementById('leaveAlertBox');
    if (el) el.style.display = 'none';
}

function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text || '';
    return div.innerHTML;
}

function openLeaveModal(personelId, personelName) {
    hideLeaveAlert();
    document.getElementById('leavePersonelId').value = personelId;
    document.getElementById('leavePersonelName').value = personelName;
    document.getElementById('leaveDate').value = '';
    document.getElementById('leaveNote').value = '';
    document.getElementById('saveLeaveBtn').textContent = 'İzni Kaydet';
    document.getElementById('cancelLeaveBtn').style.display = 'none';
    document.getElementById('leaveTransferSection').style.display = 'none';
    document.getElementById('transferTargetPersonel').innerHTML = '<option value="">Personel seçin</option>';
    document.getElementById('transferAppointmentList').innerHTML = '<div class="text-muted small">Tarih seçin.</div>';

    new bootstrap.Modal(document.getElementById('leaveModal')).show();
}

async function previewLeaveData() {
    const personelId = document.getElementById('leavePersonelId').value;
    const date = document.getElementById('leaveDate').value;
    if (!personelId || !date) return;

    hideLeaveAlert();
    const previewUrl = `{{ url('admin/guzellik-salonu/personel') }}/${personelId}/izin/preview?date=${encodeURIComponent(date)}`;
    try {
        const response = await fetch(previewUrl, {
            headers: {
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            }
        });
        const data = await response.json().catch(() => ({}));
        if (!response.ok || !data.success) {
            throw new Error(data.message || 'İzin önizlemesi alınamadı.');
        }

        if (data.already_on_leave) {
            showLeaveAlert('Bu personel seçilen tarihte zaten izinli.', 'warning');
            document.getElementById('saveLeaveBtn').textContent = 'İzni Güncelle';
            document.getElementById('cancelLeaveBtn').style.display = 'inline-block';
            if (data.existing_leave?.note) {
                document.getElementById('leaveNote').value = data.existing_leave.note;
            }
        } else {
            document.getElementById('saveLeaveBtn').textContent = 'İzni Kaydet';
            document.getElementById('cancelLeaveBtn').style.display = 'none';
        }

        const targetSelect = document.getElementById('transferTargetPersonel');
        targetSelect.innerHTML = '<option value="">Personel seçin</option>';
        (data.other_personels || []).forEach((p) => {
            const label = p.on_leave
                ? `${p.name} (İzinli - Aktarım yapılamaz)`
                : `${p.name} (${p.active_appointment_count || 0} randevu)`;
            targetSelect.innerHTML += `<option value="${p.id}" ${p.on_leave ? 'disabled' : ''}>${escapeHtml(label)}</option>`;
        });

        const appointmentList = document.getElementById('transferAppointmentList');
        const appointments = Array.isArray(data.appointments) ? data.appointments : [];
        if (appointments.length) {
            appointmentList.innerHTML = appointments.map((item) => {
                const services = (item.service_names || []).join(', ') || 'Hizmet yok';
                const timeLabel = `${item.start_time || ''}${item.end_time ? ' - ' + item.end_time : ''}`;
                return `
                    <label class="d-flex gap-2 align-items-start border rounded p-2 mb-1" style="cursor:pointer;">
                        <input type="checkbox" class="transfer-reservation-item mt-1" value="${item.reservation_id}" checked>
                        <div>
                            <div class="fw-semibold">${escapeHtml(timeLabel)} / ${escapeHtml(item.customer_name || '-')}</div>
                            <small class="text-muted">${escapeHtml(services)}</small>
                        </div>
                    </label>
                `;
            }).join('');
            showLeaveAlert('İzin kaydı için listedeki tüm randevular seçili kalmalıdır.', 'info');
        } else {
            appointmentList.innerHTML = '<div class="text-muted small">Seçilen gün aktif randevu yok.</div>';
        }

        const shouldOpenTransfer = appointments.length > 0;
        document.getElementById('leaveTransferSection').style.display = shouldOpenTransfer ? 'block' : 'none';
    } catch (error) {
        showLeaveAlert(error.message || 'Önizleme hatası.', 'error');
    }
}

async function saveLeave() {
    const personelId = document.getElementById('leavePersonelId').value;
    const leaveDate = document.getElementById('leaveDate').value;
    const note = document.getElementById('leaveNote').value || '';
    const transferToPersonelId = document.getElementById('transferTargetPersonel').value || null;
    const allReservationItems = Array.from(document.querySelectorAll('.transfer-reservation-item'));
    const transferReservationIds = Array.from(document.querySelectorAll('.transfer-reservation-item:checked')).map(el => Number(el.value));

    if (!personelId || !leaveDate) {
        showLeaveAlert('Lütfen izin tarihini seçin.', 'warning');
        return;
    }

    if (transferReservationIds.length && !transferToPersonelId) {
        showLeaveAlert('Randevu aktarımı için hedef personel seçmelisiniz.', 'warning');
        return;
    }

    if (allReservationItems.length > 0 && transferReservationIds.length !== allReservationItems.length) {
        showLeaveAlert('İzin kaydı için o güne ait tüm randevular seçili olmalıdır.', 'warning');
        return;
    }

    const payload = {
        leave_date: leaveDate,
        note: note,
        transfer_to_personel_id: transferToPersonelId,
        transfer_reservation_ids: transferReservationIds
    };

    const btn = document.getElementById('saveLeaveBtn');
    const oldText = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = 'Kaydediliyor...';

    try {
        const url = `{{ url('admin/guzellik-salonu/personel') }}/${personelId}/izin`;
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify(payload)
        });

        const data = await response.json().catch(() => ({}));
        if (!response.ok || !data.success) {
            throw new Error(data.message || 'İzin kaydedilemedi.');
        }

        showLeaveAlert(data.message || 'İzin kaydedildi.', 'success');
        setTimeout(() => {
            window.location.reload();
        }, 700);
    } catch (error) {
        showLeaveAlert(error.message || 'İzin kaydedilemedi.', 'error');
    } finally {
        btn.disabled = false;
        btn.innerHTML = oldText;
    }
}

async function cancelLeave() {
    const personelId = document.getElementById('leavePersonelId').value;
    const leaveDate = document.getElementById('leaveDate').value;
    if (!personelId || !leaveDate) {
        showLeaveAlert('İptal için izin tarihini seçin.', 'warning');
        return;
    }

    const confirmed = window.confirm('Seçilen tarihteki personel iznini iptal etmek istiyor musunuz?');
    if (!confirmed) return;

    const btn = document.getElementById('cancelLeaveBtn');
    const oldText = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = 'İptal ediliyor...';

    try {
        const url = `{{ url('admin/guzellik-salonu/personel') }}/${personelId}/izin`;
        const response = await fetch(url, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({ leave_date: leaveDate })
        });

        const data = await response.json().catch(() => ({}));
        if (!response.ok || !data.success) {
            throw new Error(data.message || 'İzin iptal edilemedi.');
        }

        showLeaveAlert(data.message || 'İzin iptal edildi.', 'success');
        setTimeout(() => window.location.reload(), 700);
    } catch (error) {
        showLeaveAlert(error.message || 'İzin iptal edilemedi.', 'error');
    } finally {
        btn.disabled = false;
        btn.innerHTML = oldText;
    }
}

document.getElementById('leaveDate')?.addEventListener('change', previewLeaveData);
document.getElementById('saveLeaveBtn')?.addEventListener('click', saveLeave);
document.getElementById('cancelLeaveBtn')?.addEventListener('click', cancelLeave);
</script>
@endpush
@endsection
