@extends('layouts.admin')

@section('title', 'Personel Detayı')
@section('page-title', 'Personel Detayı')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <a href="{{ route('admin.beauty-salon.personel.index') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-2"></i>Geri
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <div style="width: 120px; height: 120px; border-radius: 50%; background: {{ $personel->avatar_color }}; display: flex; align-items: center; justify-content: center; margin: 0 auto; font-size: 48px; color: white; font-weight: bold;">
                            {{ $personel->initials }}
                        </div>
                    </div>
                    <h4>{{ $personel->name }}</h4>
                    <p class="text-muted mb-2">{{ $personel->email }}</p>
                    <p class="text-muted mb-3">{{ $personel->phone }}</p>
                    
                    <!-- Hizmetler (Yetenekler) -->
                    @if($personelServices && $personelServices->count() > 0)
                        <div class="mb-3">
                            <strong>Hizmetler (Yetenekler):</strong><br>
                            @foreach($personelServices as $service)
                                <span class="badge bg-primary me-1 mb-1">{{ $service->name }}</span>
                            @endforeach
                        </div>
                    @else
                        <div class="mb-3">
                            <small class="text-muted">Henüz hizmet atanmamış.</small>
                        </div>
                    @endif
                    
                    <div class="mt-3">
                        <a href="{{ route('admin.beauty-salon.personel.edit', $personel->id) }}" class="btn btn-warning">
                            <i class="bi bi-pencil me-2"></i>Düzenle
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="card mt-3">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">Hizmetler (Yetenekler)</h6>
                    <button type="button" class="btn btn-sm btn-primary" onclick="openAssignServiceModal()">
                        <i class="bi bi-plus-circle me-1"></i>Hizmet Ata
                    </button>
                </div>
                <div class="card-body">
                    @if($personelServices && $personelServices->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Hizmet Adı</th>
                                        <th>Fiyat</th>
                                        <th>Süre</th>
                                        <th>İşlemler</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($personelServices as $service)
                                        <tr>
                                            <td><strong>{{ $service->name }}</strong></td>
                                            <td>{{ number_format($service->price, 2, ',', '.') }} ₺</td>
                                            <td>{{ $service->duration ? $service->duration . ' dk' : '-' }}</td>
                                            <td>
                                                <form action="{{ route('admin.beauty-salon.personel.remove-service', [$personel->id, $service->id]) }}" method="POST" class="d-inline remove-service-form" data-message="Bu hizmeti kaldırmak istediğinize emin misiniz?">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-muted text-center py-3">Henüz hizmet atanmamış.</p>
                    @endif
                </div>
            </div>
            
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="mb-0">İstatistikler</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>Toplam Randevu:</strong>
                        <span class="float-end">{{ $stats['total_appointments'] }}</span>
                    </div>
                    <div class="mb-3">
                        <strong>Tamamlanan:</strong>
                        <span class="float-end">{{ $stats['completed_appointments'] }}</span>
                    </div>
                    <div>
                        <strong>Toplam Gelir:</strong>
                        <span class="float-end">{{ number_format($stats['total_revenue'], 2, ',', '.') }} ₺</span>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Randevular</h6>
                </div>
                <div class="card-body">
                    @if($appointments->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Tarih</th>
                                        <th>Saat</th>
                                        <th>Müşteri</th>
                                        <th>Oda</th>
                                        <th>Durum</th>
                                        <th>Tutar</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($appointments as $appointment)
                                        <tr>
                                            <td>{{ $appointment->date->format('d.m.Y') }}</td>
                                            <td>{{ $appointment->start_time }} - {{ $appointment->end_time }}</td>
                                            <td>{{ $appointment->customer->name ?? '-' }}</td>
                                            <td>{{ $appointment->room->name ?? '-' }}</td>
                                            <td>
                                                @if($appointment->status === 'completed')
                                                    <span class="badge bg-success">Tamamlandı</span>
                                                @elseif($appointment->status === 'confirmed')
                                                    <span class="badge bg-primary">Onaylı</span>
                                                @else
                                                    <span class="badge bg-secondary">{{ $appointment->status }}</span>
                                                @endif
                                            </td>
                                            <td>{{ number_format($appointment->total_price, 2, ',', '.') }} ₺</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $appointments->links() }}
                        </div>
                    @else
                        <p class="text-muted text-center py-4">Henüz randevu bulunmamaktadır.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hizmet Atama Modal -->
<div class="modal fade" id="assignServiceModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content" style="border-radius: 16px; border: none; overflow: hidden;">
            <div class="modal-header" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); border-radius: 0; padding: 20px 24px;">
                <h5 class="modal-title text-white fw-bold" style="margin: 0;">
                    <i class="bi bi-box-seam me-2"></i>Hizmet Ata
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.beauty-salon.personel.assign-services', $personel->id) }}" method="POST">
                @csrf
                <div class="modal-body" style="padding: 24px; max-height: 60vh; overflow-y: auto;">
                    <p class="mb-4 text-muted" style="font-size: 14px;">
                        <i class="bi bi-info-circle me-1"></i>Bu personele atamak istediğiniz hizmetleri seçin:
                    </p>
                    @if($allServices && $allServices->count() > 0)
                        <div class="row g-3">
                            @foreach($allServices as $service)
                                <div class="col-md-6 col-lg-4">
                                    <input type="checkbox" name="service_ids[]" value="{{ $service->id }}" id="service_{{ $service->id }}" 
                                        {{ $personelServices->contains($service->id) ? 'checked' : '' }} class="service-checkbox" style="position: absolute; opacity: 0; pointer-events: none;">
                                    <label for="service_{{ $service->id }}" class="service-card-label">
                                        <div class="service-card-item {{ $personelServices->contains($service->id) ? 'selected' : '' }}">
                                            <div class="service-card-header">
                                                <div class="service-check-icon">
                                                    <i class="bi bi-check-circle-fill"></i>
                                                </div>
                                                <h6 class="service-name mb-2">{{ $service->name }}</h6>
                                            </div>
                                            <div class="service-card-body">
                                                <div class="service-price">
                                                    <i class="bi bi-currency-exchange me-1"></i>
                                                    <strong>{{ number_format($service->price, 2, ',', '.') }} ₺</strong>
                                                </div>
                                                @if($service->duration)
                                                    <div class="service-duration">
                                                        <i class="bi bi-clock me-1"></i>
                                                        <span>{{ $service->duration }} dakika</span>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="alert alert-warning d-flex align-items-center" style="border-radius: 12px; border: none; background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);">
                            <i class="bi bi-exclamation-triangle-fill me-3" style="font-size: 24px; color: #f59e0b;"></i>
                            <div>
                                <strong>Henüz hizmet eklenmemiş.</strong>
                                <br>
                                <small>Önce <a href="{{ route('admin.beauty-salon.services.create') }}" class="text-decoration-none fw-bold">hizmet ekleyin</a>.</small>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="modal-footer" style="padding: 20px 24px; background: #f8f9fa; border-top: 1px solid #e5e7eb; border-radius: 0;">
                    <button type="button" class="btn btn-light px-4" data-bs-dismiss="modal" style="border-radius: 10px; font-weight: 500;">
                        <i class="bi bi-x-circle me-2"></i>İptal
                    </button>
                    <button type="submit" class="btn px-4" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); color: white; border: none; border-radius: 10px; font-weight: 500; box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);">
                        <i class="bi bi-check-circle me-2"></i>Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
.service-card-label {
    cursor: pointer;
    margin: 0;
    display: block;
}

.service-card-item {
    background: white;
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    padding: 16px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
    height: 100%;
    display: flex;
    flex-direction: column;
}

.service-card-item::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(135deg, #10b981 0%, #047857 100%);
    transform: scaleX(0);
    transition: transform 0.3s ease;
}

.service-card-item:hover {
    border-color: #10b981;
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(16, 185, 129, 0.15);
}

.service-card-item.selected {
    border-color: #10b981;
    background: linear-gradient(135deg, #f0fdf4 0%, #ecfdf5 100%);
    box-shadow: 0 4px 16px rgba(16, 185, 129, 0.2);
}

.service-card-item.selected::before {
    transform: scaleX(1);
}

.service-check-icon {
    position: absolute;
    top: 12px;
    right: 12px;
    width: 24px;
    height: 24px;
    background: linear-gradient(135deg, #10b981 0%, #047857 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 14px;
    opacity: 0;
    transform: scale(0);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.service-card-item.selected .service-check-icon {
    opacity: 1;
    transform: scale(1);
}

.service-card-header {
    margin-bottom: 12px;
    position: relative;
}

.service-name {
    font-size: 15px;
    font-weight: 600;
    color: #1f2937;
    margin: 0;
    line-height: 1.4;
}

.service-card-body {
    margin-top: auto;
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.service-price {
    color: #10b981;
    font-size: 16px;
    font-weight: 600;
    display: flex;
    align-items: center;
}

.service-duration {
    color: #6b7280;
    font-size: 13px;
    display: flex;
    align-items: center;
}

.service-checkbox:checked + .service-card-label .service-card-item {
    border-color: #10b981;
    background: linear-gradient(135deg, #f0fdf4 0%, #ecfdf5 100%);
}

.service-checkbox:checked + .service-card-label .service-card-item::before {
    transform: scaleX(1);
}

.service-checkbox:checked + .service-card-label .service-check-icon {
    opacity: 1;
    transform: scale(1);
}
</style>

@push('scripts')
<script>
    function openAssignServiceModal() {
        new bootstrap.Modal(document.getElementById('assignServiceModal')).show();
    }
    
    // Checkbox'ları label tıklamasıyla kontrol et
    document.addEventListener('DOMContentLoaded', function() {
        // Label'a tıklandığında checkbox'ı toggle et
        document.querySelectorAll('.service-card-label').forEach(function(label) {
            label.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                const checkboxId = this.getAttribute('for');
                const checkbox = document.getElementById(checkboxId);
                
                if (checkbox) {
                    // Checkbox durumunu toggle et
                    checkbox.checked = !checkbox.checked;
                    
                    // Card'ın selected class'ını toggle et
                    const card = this.querySelector('.service-card-item');
                    if (card) {
                        if (checkbox.checked) {
                            card.classList.add('selected');
                        } else {
                            card.classList.remove('selected');
                        }
                    }
                    
                    // Debug için console log
                    console.log('Checkbox toggled:', checkboxId, 'Checked:', checkbox.checked);
                }
            });
        });
        
        // Form submit öncesi kontrol ve debug
        const assignServiceForm = document.querySelector('#assignServiceModal form');
        if (assignServiceForm) {
            assignServiceForm.addEventListener('submit', function(e) {
                // Tüm checkbox'ları kontrol et
                const checkboxes = this.querySelectorAll('input[type="checkbox"][name="service_ids[]"]');
                const checkedBoxes = this.querySelectorAll('input[type="checkbox"][name="service_ids[]"]:checked');
                
                console.log('Form submit - Total checkboxes:', checkboxes.length);
                console.log('Form submit - Checked checkboxes:', checkedBoxes.length);
                
                // Seçili checkbox değerlerini logla
                const checkedValues = Array.from(checkedBoxes).map(cb => cb.value);
                console.log('Form submit - Checked values:', checkedValues);
                
                // Eğer hiç checkbox seçilmemişse, hidden input ekle (boş array göndermek için)
                if (checkedBoxes.length === 0) {
                    // Boş array göndermek için hidden input ekle
                    const hiddenInput = document.createElement('input');
                    hiddenInput.type = 'hidden';
                    hiddenInput.name = 'service_ids[]';
                    hiddenInput.value = '';
                    this.appendChild(hiddenInput);
                }
            });
        }
        
        // Form submit - hiç hizmet seçilmemişse bile gönderilebilir (tüm hizmetleri kaldırmak için)
        
        // Hizmet kaldırma formları için custom confirm
        document.querySelectorAll('.remove-service-form').forEach(function(form) {
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                const message = this.getAttribute('data-message') || 'Bu işlemi yapmak istediğinize emin misiniz?';
                const form = this;
                
                if (typeof customConfirm === 'function') {
                    customConfirm(message).then(function(confirmed) {
                        if (confirmed) {
                            form.submit();
                        }
                    });
                } else {
                    if (confirm(message)) {
                        form.submit();
                    }
                }
            });
        });
    });
</script>
@endpush
@endsection

