@extends('layouts.admin')

@section('title', 'Referans Geçmişi')
@section('page-title', 'Referans Geçmişi')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-clock-history me-2"></i>Referans Geçmişi
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.referrals.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Ödül Geçmişi
            </h5>
        </div>
        <div class="card-body">
            @if(isset($rewardHistory) && $rewardHistory->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Müşteri</th>
                                <th>Ödül Türü</th>
                                <th>Ödül Miktarı</th>
                                <th>Kim İçin</th>
                                <th>Randevu</th>
                                <th>Tarih</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($rewardHistory as $history)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $history->customer->name ?? 'Müşteri' }}</div>
                                        @if($history->customer && $history->customer->phone)
                                            <small class="text-muted">{{ $history->customer->phone }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($history->reward_type === 'discount')
                                            <span class="badge bg-success">İndirim</span>
                                        @elseif($history->reward_type === 'points')
                                            <span class="badge bg-info">Puan</span>
                                        @elseif($history->reward_type === 'free_service')
                                            <span class="badge bg-warning text-dark">Ücretsiz Hizmet</span>
                                        @else
                                            <span class="badge bg-primary">Nakit</span>
                                        @endif
                                    </td>
                                    <td class="fw-bold text-success">
                                        {{ number_format($history->reward_amount, 2, ',', '.') }} ₺
                                    </td>
                                    <td>
                                        @if($history->reward_for === 'referrer')
                                            <span class="badge bg-primary">Referans Eden</span>
                                        @else
                                            <span class="badge bg-info">Yeni Müşteri</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($history->appointment_id)
                                            <button type="button" onclick="if(typeof window.showReservationDetail === 'function') { window.showReservationDetail({{ $history->appointment_id }}); } else { window.location.href='{{ route('admin.appointments.show', $history->appointment_id) }}'; }" class="btn btn-sm btn-link text-primary p-0" style="text-decoration: none;">
                                                #{{ $history->appointment_id }}
                                            </button>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>{{ $history->created_at->format('d.m.Y H:i') }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $rewardHistory->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-clock-history" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz ödül geçmişi bulunmamaktadır.</p>
                    <p class="text-muted">Referans sistemi ödülleri burada görünecektir.</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

