@extends('layouts.admin')

@section('title', 'Referans Sistemi')
@section('page-title', 'Referans Sistemi')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-people-fill me-2"></i>Referans Sistemi
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.referrals.rewards') }}" class="btn btn-outline-success">
                        <i class="bi bi-gift me-2"></i>Ödüller
                    </a>
                    <a href="{{ route('admin.beauty-salon.referrals.history') }}" class="btn btn-outline-info">
                        <i class="bi bi-clock-history me-2"></i>Geçmiş
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- İstatistikler -->
    <div class="row g-4 mb-4">
        <div class="col-md-4">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px; background: linear-gradient(135deg, #10b981 0%, #047857 100%); color: white;">
                <div class="card-body">
                    <i class="bi bi-person-plus-fill" style="font-size: 32px; opacity: 0.9;"></i>
                    <h3 class="mb-0 mt-2">{{ $totalReferrals }}</h3>
                    <p class="mb-0">Toplam Referans</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px; background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); color: white;">
                <div class="card-body">
                    <i class="bi bi-check-circle-fill" style="font-size: 32px; opacity: 0.9;"></i>
                    <h3 class="mb-0 mt-2">{{ $completedReferrals }}</h3>
                    <p class="mb-0">Tamamlanan</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white;">
                <div class="card-body">
                    <i class="bi bi-cash-coin" style="font-size: 32px; opacity: 0.9;"></i>
                    <h3 class="mb-0 mt-2">{{ number_format($totalRewards, 0, ',', '.') }} ₺</h3>
                    <p class="mb-0">Toplam Ödül</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Referans Listesi -->
    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Referans Listesi
            </h5>
        </div>
        <div class="card-body">
            @if($referrals->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Referans Eden</th>
                                <th>Referans Kodu</th>
                                <th>Yeni Müşteri</th>
                                <th>Durum</th>
                                <th>Tarih</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($referrals as $referral)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $referral->referrer->name ?? 'Müşteri' }}</div>
                                        @if($referral->referrer && $referral->referrer->phone)
                                            <small class="text-muted">{{ $referral->referrer->phone }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <code class="text-primary">{{ $referral->referral_code }}</code>
                                    </td>
                                    <td>
                                        @if($referral->referred)
                                            <div class="fw-bold">{{ $referral->referred->name }}</div>
                                            @if($referral->referred->phone)
                                                <small class="text-muted">{{ $referral->referred->phone }}</small>
                                            @endif
                                        @else
                                            <span class="text-muted">Henüz kayıt olmadı</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($referral->status === 'completed')
                                            <span class="badge bg-success">Tamamlandı</span>
                                        @elseif($referral->status === 'first_visit')
                                            <span class="badge bg-info">İlk Ziyaret</span>
                                        @elseif($referral->status === 'registered')
                                            <span class="badge bg-warning text-dark">Kayıt Oldu</span>
                                        @else
                                            <span class="badge bg-secondary">Beklemede</span>
                                        @endif
                                    </td>
                                    <td>{{ $referral->created_at->format('d.m.Y H:i') }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $referrals->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-people" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz referans bulunmamaktadır.</p>
                    <p class="text-muted">Müşterileriniz referans kodlarını arkadaşlarıyla paylaştığında burada görünecektir.</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
