@extends('layouts.admin')

@section('title', 'Referans Ödülleri')
@section('page-title', 'Referans Ödülleri')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-gift me-2"></i>Referans Ödülleri
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.referrals.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Ödül Ayarları
            </h5>
        </div>
        <div class="card-body">
            @if(isset($rewards) && $rewards->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Ödül Türü</th>
                                <th>Referans Eden Ödülü</th>
                                <th>Yeni Müşteri Ödülü</th>
                                <th>Minimum Ziyaret</th>
                                <th>Durum</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($rewards as $reward)
                                <tr>
                                    <td>
                                        @if($reward->reward_type === 'discount')
                                            <span class="badge bg-success">İndirim</span>
                                        @elseif($reward->reward_type === 'points')
                                            <span class="badge bg-info">Puan</span>
                                        @elseif($reward->reward_type === 'free_service')
                                            <span class="badge bg-warning text-dark">Ücretsiz Hizmet</span>
                                        @else
                                            <span class="badge bg-primary">Nakit</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($reward->referrer_reward_percentage)
                                            %{{ number_format($reward->referrer_reward_percentage, 0) }}
                                        @else
                                            {{ number_format($reward->referrer_reward_amount, 2, ',', '.') }} ₺
                                        @endif
                                    </td>
                                    <td>
                                        @if($reward->referred_reward_percentage)
                                            %{{ number_format($reward->referred_reward_percentage, 0) }}
                                        @else
                                            {{ number_format($reward->referred_reward_amount, 2, ',', '.') }} ₺
                                        @endif
                                    </td>
                                    <td>{{ $reward->min_visits_required }}</td>
                                    <td>
                                        @if($reward->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-danger">Pasif</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="editReward({{ $reward->id }})">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-gift" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz ödül ayarı oluşturulmamış.</p>
                    <p class="text-muted">Referans sistemi için ödül ayarlarınızı yapılandırın.</p>
                </div>
            @endif
        </div>
    </div>
</div>

@push('scripts')
<script>
    function editReward(id) {
        alert('Ödül düzenleme özelliği geliştiriliyor. Yakında eklenecektir.');
    }
</script>
@endpush
@endsection

