@extends('layouts.admin')

@section('title', 'Aylık Gelir Raporu')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Aylık Gelir Raporu</li>
@endsection

@section('content')
    <h2 class="mb-4">Aylık Gelir Raporu</h2>
    
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.reports.monthly-revenue') }}" class="row g-3">
                <div class="col-md-6">
                    <label class="form-label fw-bold">Ay Seçin</label>
                    <input type="month" name="month" class="form-control form-control-lg" value="{{ $month }}">
                </div>
                <div class="col-md-6 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="bi bi-search"></i> Filtrele
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card shadow-sm border-success">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="bi bi-cash-coin"></i> Toplam Gelir</h5>
                </div>
                <div class="card-body">
                    <h2 class="text-success mb-0">{{ number_format($revenue, 2, ',', '.') }} ₺</h2>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-list-ul"></i> Randevu Detayları</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Randevu Kodu</th>
                            <th>Müşteri</th>
                            <th>Tarih</th>
                            <th>Tutar</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($appointments as $reservation)
                            <tr>
                                <td>{{ $reservation->code }}</td>
                                <td>{{ $reservation->customer->name }}</td>
                                <td>{{ $reservation->date->format('d.m.Y') }}</td>
                                <td><strong>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</strong></td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center">Randevu bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

