@extends('layouts.admin')

@section('title', 'Haftalık Rapor')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Haftalık Rapor</li>
@endsection

@section('content')
    <h2 class="mb-4">Haftalık Rapor</h2>
    
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.reports.weekly') }}" class="row g-3">
                <div class="col-md-4">
                    <label class="form-label fw-bold">Başlangıç Tarihi</label>
                    <input type="date" name="start_date" class="form-control form-control-lg" value="{{ $startDate }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label fw-bold">Bitiş Tarihi</label>
                    <input type="date" name="end_date" class="form-control form-control-lg" value="{{ $endDate }}">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="bi bi-search"></i> Filtrele
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-calendar-week"></i> Haftalık Randevular</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Randevu Kodu</th>
                            <th>Müşteri</th>
                            <th>Tarih</th>
                            <th>Salon</th>
                            <th>Durum</th>
                            <th>Tutar</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($appointments as $reservation)
                            <tr>
                                <td>{{ $reservation->code }}</td>
                                <td>{{ $reservation->customer->name }}</td>
                                <td>{{ $reservation->date->format('d.m.Y') }}</td>
                                <td>{{ $reservation->salon->name }}</td>
                                <td>
                                    @if($reservation->status == 'open')
                                        <span class="badge bg-warning">Açık</span>
                                    @elseif($reservation->status == 'confirmed')
                                        <span class="badge bg-success">Onaylandı</span>
                                    @elseif($reservation->status == 'cancelled')
                                        <span class="badge bg-danger">İptal</span>
                                    @else
                                        <span class="badge bg-info">Tamamlandı</span>
                                    @endif
                                </td>
                                <td>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">Randevu bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

