@extends('layouts.admin')

@section('title', 'Oda Düzenle')
@section('page-title', 'Oda Düzenle')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Oda Bilgileri</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.beauty-salon.rooms.update', $room->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label">Oda Adı <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $room->name) }}" required>
                                @error('name')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="capacity" class="form-label">Kapasite</label>
                                <input type="number" class="form-control" id="capacity" name="capacity" value="{{ old('capacity', $room->capacity) }}" min="1">
                                @error('capacity')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="description" class="form-label">Açıklama</label>
                            <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $room->description) }}</textarea>
                            @error('description')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="color" class="form-label">Renk (Takvimde görünecek)</label>
                                <input type="color" class="form-control form-control-color" id="color" name="color" value="{{ old('color', $room->color) }}" title="Renk seçin">
                                @error('color')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save me-2"></i>Güncelle
                            </button>
                            <a href="{{ route('admin.beauty-salon.rooms.index') }}" class="btn btn-secondary">
                                <i class="bi bi-x me-2"></i>İptal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

