@extends('layouts.admin')

@section('title', 'Oda Yönetimi')
@section('page-title', 'Oda Yönetimi')

@section('content')
<style>
    .room-card {
        border: none;
        border-radius: 20px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
        overflow: hidden;
        background: white;
        height: 100%;
        position: relative;
    }
    
    .room-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, var(--room-color) 0%, var(--room-color-dark) 100%);
    }
    
    .room-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
    }
    
    .room-icon {
        width: 80px;
        height: 80px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 36px;
        background: linear-gradient(135deg, var(--room-color) 0%, var(--room-color-dark) 100%);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
        flex-shrink: 0;
        position: relative;
        overflow: hidden;
    }
    
    .room-icon::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
    }
    
    .room-info h5 {
        font-size: 1.25rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.5rem;
    }
    
    .room-info .description {
        color: #6b7280;
        font-size: 0.875rem;
        line-height: 1.5;
        margin-bottom: 0.5rem;
    }
    
    .room-info .capacity {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.375rem 0.75rem;
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
        border-radius: 12px;
        color: #0369a1;
        font-weight: 600;
        font-size: 0.875rem;
    }
    
    .room-info .capacity i {
        font-size: 1rem;
    }
    
    .action-btn {
        border-radius: 12px;
        padding: 0.5rem 1rem;
        font-weight: 600;
        transition: all 0.2s ease;
        border: none;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }
    
    .action-btn-warning {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        color: white;
    }
    
    .action-btn-danger {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: white;
    }
    
    @media (max-width: 768px) {
        .room-card {
            margin-bottom: 1.5rem;
        }
        
        .room-icon {
            width: 64px;
            height: 64px;
            font-size: 28px;
        }
        
        .action-btn {
            flex: 1;
        }
    }
    
    .empty-state {
        padding: 4rem 2rem;
        text-align: center;
    }
    
    .empty-state-icon {
        font-size: 5rem;
        opacity: 0.3;
        color: #ec4899;
        margin-bottom: 1.5rem;
    }
    
    .color-preview {
        width: 24px;
        height: 24px;
        border-radius: 8px;
        border: 2px solid rgba(0, 0, 0, 0.1);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
</style>

<div class="container-fluid">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-3">
        <div>
            <h2 class="fw-bold mb-2" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; font-size: 2rem;">
                <i class="bi bi-door-open-fill me-2"></i> Oda Yönetimi
            </h2>
            <p class="text-muted mb-0">Salonunuzdaki odaları yönetin ve organize edin</p>
        </div>
        <a href="{{ route('admin.beauty-salon.rooms.create') }}" class="btn btn-primary btn-lg" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 12px; padding: 0.75rem 1.5rem; font-weight: 600; box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);">
            <i class="bi bi-plus-circle-fill me-2"></i>Yeni Oda Ekle
        </a>
    </div>

    @if($rooms->count() > 0)
        <!-- Desktop Grid View -->
        <div class="row d-none d-lg-flex">
            @foreach($rooms as $room)
                @php
                    $roomColor = $room->color ?? '#10b981';
                    // Renk tonunu biraz koyulaştırarak gradient için kullan
                    $roomColorDark = $roomColor;
                    // Eğer hex renk ise, koyulaştır
                    if (preg_match('/^#[0-9A-Fa-f]{6}$/', $roomColor)) {
                        $r = hexdec(substr($roomColor, 1, 2));
                        $g = hexdec(substr($roomColor, 3, 2));
                        $b = hexdec(substr($roomColor, 5, 2));
                        $r = max(0, min(255, $r - 20));
                        $g = max(0, min(255, $g - 20));
                        $b = max(0, min(255, $b - 20));
                        $roomColorDark = sprintf("#%02x%02x%02x", $r, $g, $b);
                    }
                @endphp
                <div class="col-lg-4 col-xl-3 mb-4">
                    <div class="room-card" style="--room-color: {{ $roomColor }}; --room-color-dark: {{ $roomColorDark }};">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-start gap-3 mb-4">
                                <div class="room-icon" style="background: linear-gradient(135deg, {{ $roomColor }} 0%, {{ $roomColorDark }} 100%);">
                                    <i class="bi bi-door-open-fill"></i>
                                </div>
                                <div class="room-info flex-grow-1">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <h5>{{ $room->name }}</h5>
                                        <div class="color-preview" style="background: {{ $roomColor }};"></div>
                                    </div>
                                    @if($room->description)
                                        <div class="description">
                                            {{ Str::limit($room->description, 80) }}
                                        </div>
                                    @endif
                                    @if($room->capacity)
                                        <div class="capacity">
                                            <i class="bi bi-people-fill"></i>
                                            <span>{{ $room->capacity }} Kişi</span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="d-flex gap-2 mt-3">
                                <a href="{{ route('admin.beauty-salon.rooms.edit', $room->id) }}" class="action-btn action-btn-warning flex-fill text-decoration-none text-center">
                                    <i class="bi bi-pencil-fill"></i>
                                    <span class="d-none d-sm-inline">Düzenle</span>
                                </a>
                                <button type="button" class="action-btn action-btn-danger" onclick="confirmDeleteRoom({{ $room->id }}, '{{ $room->name }}')">
                                    <i class="bi bi-trash-fill"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        
        <!-- Mobile/Tablet Cards -->
        <div class="d-lg-none">
            @foreach($rooms as $room)
                @php
                    $roomColor = $room->color ?? '#10b981';
                    $roomColorDark = $roomColor;
                    if (preg_match('/^#[0-9A-Fa-f]{6}$/', $roomColor)) {
                        $r = hexdec(substr($roomColor, 1, 2));
                        $g = hexdec(substr($roomColor, 3, 2));
                        $b = hexdec(substr($roomColor, 5, 2));
                        $r = max(0, min(255, $r - 20));
                        $g = max(0, min(255, $g - 20));
                        $b = max(0, min(255, $b - 20));
                        $roomColorDark = sprintf("#%02x%02x%02x", $r, $g, $b);
                    }
                @endphp
                <div class="card room-card mb-3" style="--room-color: {{ $roomColor }}; --room-color-dark: {{ $roomColorDark }};">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-start gap-3 mb-3">
                            <div class="room-icon" style="background: linear-gradient(135deg, {{ $roomColor }} 0%, {{ $roomColorDark }} 100%);">
                                <i class="bi bi-door-open-fill"></i>
                            </div>
                            <div class="room-info flex-grow-1">
                                <div class="d-flex align-items-center gap-2 mb-2">
                                    <h5>{{ $room->name }}</h5>
                                    <div class="color-preview" style="background: {{ $roomColor }};"></div>
                                </div>
                                @if($room->description)
                                    <div class="description mb-2">
                                        {{ $room->description }}
                                    </div>
                                @endif
                                @if($room->capacity)
                                    <div class="capacity">
                                        <i class="bi bi-people-fill"></i>
                                        <span>{{ $room->capacity }} Kişi</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                        
                        <div class="d-flex gap-2">
                            <a href="{{ route('admin.beauty-salon.rooms.edit', $room->id) }}" class="action-btn action-btn-warning flex-fill text-decoration-none text-center">
                                <i class="bi bi-pencil-fill me-1"></i>Düzenle
                            </a>
                            <button type="button" class="action-btn action-btn-danger" onclick="confirmDeleteRoom({{ $room->id }}, '{{ $room->name }}')">
                                <i class="bi bi-trash-fill"></i>
                            </button>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="card border-0 shadow-sm">
            <div class="card-body empty-state">
                <div class="empty-state-icon">
                    <i class="bi bi-door-open"></i>
                </div>
                <h4 class="fw-bold mb-3" style="color: #1f2937;">Henüz oda eklenmemiş</h4>
                <p class="text-muted mb-4">Salonunuzdaki odaları ekleyerek başlayın. Odalarınızı randevu yönetiminde kullanabilirsiniz.</p>
                <a href="{{ route('admin.beauty-salon.rooms.create') }}" class="btn btn-primary btn-lg" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 12px; padding: 0.75rem 2rem; font-weight: 600; box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);">
                    <i class="bi bi-plus-circle-fill me-2"></i>İlk Odayı Ekle
                </a>
            </div>
        </div>
    @endif
</div>

<!-- Silme Onay Modalı -->
<div class="modal fade" id="deleteRoomModal" tabindex="-1" aria-labelledby="deleteRoomModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 20px;">
            <div class="modal-header border-0" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 20px 20px 0 0;">
                <h5 class="modal-title text-white fw-bold" id="deleteRoomModalLabel">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i>Oda Silme Onayı
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <p id="deleteRoomMessage" class="mb-3 fw-semibold" style="color: #1f2937;"></p>
                <div class="alert alert-warning border-0 mb-0" style="background: #fef3c7; border-radius: 12px;">
                    <i class="bi bi-info-circle-fill me-2"></i>
                    <strong>Uyarı:</strong> Bu işlem geri alınamaz! Odanın tüm verileri kalıcı olarak silinecektir.
                </div>
            </div>
            <div class="modal-footer border-0">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 12px; padding: 0.5rem 1.5rem; font-weight: 600;">
                    <i class="bi bi-x-lg me-1"></i>İptal
                </button>
                <form id="deleteRoomForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border: none; border-radius: 12px; padding: 0.5rem 1.5rem; font-weight: 600; box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);">
                        <i class="bi bi-trash-fill me-1"></i>Evet, Sil
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function confirmDeleteRoom(id, name) {
    const modalElement = document.getElementById('deleteRoomModal');
    if (!modalElement) {
        console.error('deleteRoomModal bulunamadı');
        return;
    }
    
    const modal = new bootstrap.Modal(modalElement);
    const form = document.getElementById('deleteRoomForm');
    const message = document.getElementById('deleteRoomMessage');
    
    message.textContent = `"${name}" adlı odayı silmek istediğinizden emin misiniz?`;
    form.action = `{{ url('admin/guzellik-salonu/odalar') }}/${id}`;
    
    modal.show();
}
</script>
@endpush
@endsection
