@extends('layouts.admin')

@section('title', 'Yeni Kategori Ekle')
@section('page-title', 'Yeni Kategori Ekle')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
                    <h5 class="mb-0 text-white">
                        <i class="bi bi-folder-plus me-2"></i>Yeni Kategori Ekle
                    </h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.beauty-salon.service-categories.store') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="name" class="form-label fw-bold">
                                <i class="bi bi-tag me-1"></i>Kategori Adı <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control form-control-lg" id="name" name="name" value="{{ old('name') }}" placeholder="Örn: Saç Bakımı, Cilt Bakımı" required>
                            @error('name')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="description" class="form-label fw-bold">
                                <i class="bi bi-file-text me-1"></i>Açıklama
                            </label>
                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="Kategori hakkında açıklama...">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="color" class="form-label fw-bold">
                                <i class="bi bi-palette me-1"></i>Renk
                            </label>
                            <input type="color" class="form-control form-control-color" id="color" name="color" value="{{ old('color', '#ec4899') }}" title="Kategori rengi seçin" style="width: 100%; height: 50px;">
                            @error('color')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-save me-2"></i>Kaydet
                            </button>
                            <a href="{{ route('admin.beauty-salon.service-categories.index') }}" class="btn btn-secondary btn-lg">
                                <i class="bi bi-x me-2"></i>İptal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


