@extends('layouts.admin')

@section('title', 'Kategori Düzenle')
@section('page-title', 'Kategori Düzenle')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header" style="background: linear-gradient(135deg, {{ $category->color }} 0%, {{ $category->color }}dd 100%);">
                    <h5 class="mb-0 text-white">
                        <i class="bi bi-pencil me-2"></i>Kategori Düzenle
                    </h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.beauty-salon.service-categories.update', $category->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="mb-3">
                            <label for="name" class="form-label fw-bold">
                                <i class="bi bi-tag me-1"></i>Kategori Adı <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control form-control-lg" id="name" name="name" value="{{ old('name', $category->name) }}" placeholder="Örn: Saç Bakımı, Cilt Bakımı" required>
                            @error('name')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="description" class="form-label fw-bold">
                                <i class="bi bi-file-text me-1"></i>Açıklama
                            </label>
                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="Kategori hakkında açıklama...">{{ old('description', $category->description) }}</textarea>
                            @error('description')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="color" class="form-label fw-bold">
                                <i class="bi bi-palette me-1"></i>Renk
                            </label>
                            <input type="color" class="form-control form-control-color" id="color" name="color" value="{{ old('color', $category->color) }}" title="Kategori rengi seçin" style="width: 100%; height: 50px;">
                            @error('color')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-save me-2"></i>Güncelle
                            </button>
                            <a href="{{ route('admin.beauty-salon.service-categories.index') }}" class="btn btn-secondary btn-lg">
                                <i class="bi bi-x me-2"></i>İptal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


