@extends('layouts.admin')

@section('title', 'Hizmet Kategorileri')
@section('page-title', 'Hizmet Kategorileri')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-2" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                    <i class="bi bi-folder me-2"></i>Hizmet Kategorileri
                </h2>
                <a href="{{ route('admin.beauty-salon.service-categories.create') }}" class="btn btn-primary">
                    <i class="bi bi-plus-circle me-2"></i>Yeni Kategori Ekle
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="row">
        @if($categories->count() > 0)
            @foreach($categories as $category)
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card h-100 shadow-sm border-0" style="border-left: 4px solid {{ $category->color }}; transition: all 0.3s ease;">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div>
                                    <h5 class="card-title fw-bold mb-1">{{ $category->name }}</h5>
                                    @if($category->description)
                                        <p class="text-muted small mb-0">{{ Str::limit($category->description, 60) }}</p>
                                    @endif
                                </div>
                                <div style="width: 40px; height: 40px; background: {{ $category->color }}; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                    <i class="bi bi-folder-fill text-white"></i>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <span class="badge bg-primary">
                                    <i class="bi bi-scissors me-1"></i>{{ $category->services_count }} Hizmet
                                </span>
                            </div>
                            
                            <div class="d-flex gap-2">
                                <a href="{{ route('admin.beauty-salon.services.index-by-category', $category->id) }}" class="btn btn-primary btn-sm flex-fill">
                                    <i class="bi bi-eye me-1"></i>Hizmetleri Gör
                                </a>
                                <a href="{{ route('admin.beauty-salon.services.create', $category->id) }}" class="btn btn-success btn-sm">
                                    <i class="bi bi-plus-circle"></i>
                                </a>
                                <a href="{{ route('admin.beauty-salon.service-categories.edit', $category->id) }}" class="btn btn-warning btn-sm">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="{{ route('admin.beauty-salon.service-categories.destroy', $category->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu kategoriyi silmek istediğinize emin misiniz? Kategoriye ait hizmetler kategorisiz olacaktır.');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @else
            <div class="col-12">
                <div class="card">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-folder-x" style="font-size: 48px; color: #ccc;"></i>
                        <p class="text-muted mt-3">Henüz kategori eklenmemiş.</p>
                        <a href="{{ route('admin.beauty-salon.service-categories.create') }}" class="btn btn-primary">
                            <i class="bi bi-plus-circle me-2"></i>İlk Kategoriyi Ekle
                        </a>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection


