@extends('layouts.admin')

@section('title', $category->name . ' - Hizmetler')
@section('page-title', $category->name . ' - Hizmetler')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('admin.beauty-salon.service-categories.index') }}">
                                    <i class="bi bi-folder me-1"></i>Kategoriler
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">
                                <span style="color: {{ $category->color }};">{{ $category->name }}</span>
                            </li>
                        </ol>
                    </nav>
                    <h2 class="fw-bold mb-0" style="color: {{ $category->color }};">
                        <i class="bi bi-scissors me-2"></i>{{ $category->name }} Hizmetleri
                    </h2>
                </div>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.services.create', $category->id) }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Hizmet Ekle
                    </a>
                    <a href="{{ route('admin.beauty-salon.service-categories.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Kategorilere Dön
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header" style="background: linear-gradient(135deg, {{ $category->color }} 0%, {{ $category->color }}dd 100%);">
                    <h5 class="mb-0 text-white">
                        <i class="bi bi-list-ul me-2"></i>{{ $category->name }} Hizmetleri
                        <span class="badge bg-white text-dark ms-2">{{ $category->services->count() }}</span>
                    </h5>
                </div>
                <div class="card-body">
                    @if($category->services->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Hizmet Adı</th>
                                        <th>Açıklama</th>
                                        <th>Fiyat</th>
                                        <th>Süre</th>
                                        <th>İşlemler</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($category->services as $service)
                                        <tr>
                                            <td><strong>{{ $service->name }}</strong></td>
                                            <td>{{ $service->description ?? '-' }}</td>
                                            <td>{{ number_format($service->price, 2, ',', '.') }} ₺</td>
                                            <td>{{ $service->duration ? $service->duration . ' dk' : '-' }}</td>
                                            <td>
                                                <a href="{{ route('admin.beauty-salon.services.edit', $service->id) }}" class="btn btn-sm btn-warning">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <form action="{{ route('admin.beauty-salon.services.destroy', $service->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu hizmeti silmek istediğinize emin misiniz?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-scissors" style="font-size: 48px; color: #ccc;"></i>
                            <p class="text-muted mt-3">Bu kategoride henüz hizmet eklenmemiş.</p>
                            <a href="{{ route('admin.beauty-salon.services.create', $category->id) }}" class="btn btn-primary">
                                <i class="bi bi-plus-circle me-2"></i>İlk Hizmeti Ekle
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


