@extends('layouts.admin')

@section('title', 'Yeni Hizmet Ekle')
@section('page-title', 'Yeni Hizmet Ekle')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.beauty-salon.services.index') }}">
                            <i class="bi bi-folder me-1"></i>Kategoriler
                        </a>
                    </li>
                    @if($category)
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.beauty-salon.services.index-by-category', $category->id) }}">
                                {{ $category->name }}
                            </a>
                        </li>
                    @endif
                    <li class="breadcrumb-item active" aria-current="page">Yeni Hizmet</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Hizmet Bilgileri</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.beauty-salon.services.store') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="service_category_id" class="form-label">Kategori <span class="text-danger">*</span></label>
                            <select class="form-select" id="service_category_id" name="service_category_id" required>
                                <option value="">Kategori Seçin</option>
                                @foreach($categories as $cat)
                                    <option value="{{ $cat->id }}" {{ ($category && $category->id == $cat->id) ? 'selected' : '' }}>
                                        {{ $cat->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('service_category_id')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="name" class="form-label">Hizmet Adı <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" placeholder="Örn: Saç Yıkama Paketi" required>
                            @error('name')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="description" class="form-label">Açıklama</label>
                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="Hizmet hakkında detaylı bilgi...">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="price" class="form-label">Fiyat (₺) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="price" name="price" value="{{ old('price') }}" step="0.01" min="0" placeholder="0.00" required>
                            @error('price')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="duration" class="form-label">Süre (Dakika) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="duration" name="duration" value="{{ old('duration', 30) }}" min="1" placeholder="30" required>
                            <small class="text-muted">Hizmetin süresi dakika cinsinden (örn: 30, 60, 90)</small>
                            @error('duration')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save me-2"></i>Kaydet
                            </button>
                            @if($category)
                                <a href="{{ route('admin.beauty-salon.services.index-by-category', $category->id) }}" class="btn btn-secondary">
                                    <i class="bi bi-x me-2"></i>İptal
                                </a>
                            @else
                                <a href="{{ route('admin.beauty-salon.services.index') }}" class="btn btn-secondary">
                                    <i class="bi bi-x me-2"></i>İptal
                                </a>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
