@extends('layouts.admin')

@section('title', 'Hizmet Düzenle')
@section('page-title', 'Hizmet Düzenle')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Hizmet Bilgileri</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.beauty-salon.services.update', $service->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="mb-3">
                            <label for="service_category_id" class="form-label">Kategori <span class="text-danger">*</span></label>
                            <select class="form-select" id="service_category_id" name="service_category_id" required>
                                <option value="">Kategori Seçin</option>
                                @foreach($categories as $cat)
                                    <option value="{{ $cat->id }}" {{ old('service_category_id', $service->service_category_id) == $cat->id ? 'selected' : '' }}>
                                        {{ $cat->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('service_category_id')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="name" class="form-label">Hizmet Adı <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $service->name) }}" placeholder="Örn: Saç Yıkama Paketi" required>
                            @error('name')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="description" class="form-label">Açıklama</label>
                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="Hizmet hakkında detaylı bilgi...">{{ old('description', $service->description) }}</textarea>
                            @error('description')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="price" class="form-label">Fiyat (₺) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="price" name="price" value="{{ old('price', $service->price) }}" step="0.01" min="0" placeholder="0.00" required>
                            @error('price')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="duration" class="form-label">Süre (Dakika) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="duration" name="duration" value="{{ old('duration', $service->duration ?? 30) }}" min="1" placeholder="30" required>
                            <small class="text-muted">Hizmetin süresi dakika cinsinden (örn: 30, 60, 90)</small>
                            @error('duration')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save me-2"></i>Güncelle
                            </button>
                            @if($service->service_category_id)
                                <a href="{{ route('admin.beauty-salon.services.index-by-category', $service->service_category_id) }}" class="btn btn-secondary">
                                    <i class="bi bi-x me-2"></i>İptal
                                </a>
                            @else
                                <a href="{{ route('admin.beauty-salon.services.index') }}" class="btn btn-secondary">
                                    <i class="bi bi-x me-2"></i>İptal
                                </a>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

