@extends('layouts.admin')

@section('title', 'Muhasebe Grup Ayarları')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Muhasebe Grup Ayarları</li>
@endsection

@section('content')
    <h2 class="mb-4">Muhasebe Grup Ayarları</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-calculator"></i> Muhasebe Ayarları</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.accounting') }}">
                @csrf
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Varsayılan Para Birimi</label>
                    <select name="currency" class="form-select form-select-lg">
                        <option value="TRY" {{ ($settings['currency'] ?? 'TRY') == 'TRY' ? 'selected' : '' }}>TRY (₺)</option>
                        <option value="USD" {{ ($settings['currency'] ?? '') == 'USD' ? 'selected' : '' }}>USD ($)</option>
                        <option value="EUR" {{ ($settings['currency'] ?? '') == 'EUR' ? 'selected' : '' }}>EUR (€)</option>
                    </select>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">KDV Oranı (%)</label>
                    <input type="number" step="0.01" name="tax_rate" class="form-control form-control-lg" value="{{ $settings['tax_rate'] ?? 18 }}">
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Varsayılan Ödeme Yöntemi</label>
                    <select name="default_payment_method" class="form-select form-select-lg">
                        <option value="cash" {{ ($settings['default_payment_method'] ?? 'cash') == 'cash' ? 'selected' : '' }}>Nakit</option>
                        <option value="bank_transfer" {{ ($settings['default_payment_method'] ?? '') == 'bank_transfer' ? 'selected' : '' }}>Banka Transferi</option>
                        <option value="credit_card" {{ ($settings['default_payment_method'] ?? '') == 'credit_card' ? 'selected' : '' }}>Kredi Kartı</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-lg btn-primary">
                    <i class="bi bi-check-circle"></i> Kaydet
                </button>
            </form>
        </div>
    </div>
@endsection

