@extends('layouts.admin')

@section('title', 'Yeni Sözleşme Ekle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.contracts.index') }}">Sözleşme Yönetimi</a></li>
    <li class="breadcrumb-item active">Yeni Sözleşme</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Yeni Sözleşme Ekle</h2>
        <a href="{{ route('admin.settings.contracts.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-file-earmark-text"></i> Sözleşme Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.contracts.store') }}">
                @csrf
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Sözleşme Adı *</label>
                    <input type="text" name="name" class="form-control form-control-lg" value="{{ old('name') }}" required>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">İçerik</label>
                    <textarea name="content" class="form-control" rows="15" placeholder="Sözleşme içeriğini buraya yazın. Güzellik salonu randevu sözleşmesi için uygun maddeler ekleyin.">{{ old('content') }}</textarea>
                    <small class="text-muted">HTML kullanabilirsiniz. Sözleşme içeriğinde "güzellik salonu", "randevu", "hizmet" gibi terimler kullanın.</small>
                </div>
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                        <label class="form-check-label fw-bold" for="is_active">
                            Aktif
                        </label>
                    </div>
                </div>
                
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.settings.contracts.index') }}" class="btn btn-lg btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                    <button type="submit" class="btn btn-lg btn-primary">
                        <i class="bi bi-check-circle"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

