@extends('layouts.admin')

@section('title', 'Sözleşme Yönetimi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Sözleşme Yönetimi</li>
@endsection

@section('content')
<style>
    /* Desktop görünümde de üstten boşluk */
    @media (min-width: 1025px) {
        .main-content {
            padding-top: 20px !important;
        }
    }
    
    @media (max-width: 1024px) {
        .main-content {
            padding-top: 20px !important;
        }
        .card {
            border-radius: 16px !important;
            margin-bottom: 15px !important;
        }
        
        .card-header {
            padding: 15px !important;
            font-size: 16px !important;
        }
        
        .card-body {
            padding: 15px !important;
        }
        
        .table-responsive {
            border-radius: 12px !important;
            overflow-x: auto !important;
            -webkit-overflow-scrolling: touch;
        }
        
        .table {
            font-size: 14px !important;
            margin-bottom: 0 !important;
        }
        
        .table th, .table td {
            padding: 12px 8px !important;
            white-space: nowrap;
        }
        
        .table th {
            font-size: 13px !important;
            font-weight: 600 !important;
        }
        
        .btn-group {
            flex-direction: column !important;
            gap: 5px !important;
        }
        
        .btn-group .btn {
            width: 100% !important;
            margin-bottom: 5px !important;
        }
        
        .input-group {
            flex-wrap: wrap !important;
        }
        
        .input-group input {
            min-width: 0 !important;
            flex: 1 1 auto !important;
        }
        
        .input-group .btn {
            min-width: 44px !important;
            min-height: 44px !important;
        }
        
        .badge {
            font-size: 11px !important;
            padding: 4px 8px !important;
            margin: 2px 0 !important;
            display: inline-block !important;
        }
        
        .alert {
            padding: 15px !important;
            border-radius: 12px !important;
            font-size: 14px !important;
        }
    }
    
    @media (max-width: 768px) {
        .table th:nth-child(2),
        .table td:nth-child(2) {
            display: none;
        }
        
        .table th:nth-child(4),
        .table td:nth-child(4) {
            display: none;
        }
    }
</style>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 style="color: #ec4899;">
            <i class="bi bi-file-earmark-text"></i> Sözleşme Yönetimi
        </h2>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white;">
            <h5 class="mb-0 text-white"><i class="bi bi-file-earmark-text"></i> Sözleşmeler</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Sözleşme Adı</th>
                            <th>İçerik Önizleme</th>
                            <th>Durum</th>
                            <th>Public Link</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($globalContract) && $globalContract)
                            <tr class="table-info">
                                <td>
                                    <strong>{{ $globalContract->name }}</strong>
                                    <span class="badge bg-danger ms-2"><i class="bi bi-lock-fill"></i> Zorunlu Sözleşme</span>
                                    <span class="badge bg-warning text-dark ms-2"><i class="bi bi-globe"></i> Sistem Geneli</span>
                                </td>
                                <td>{{ Str::limit(strip_tags($globalContract->content), 80) }}</td>
                                <td>
                                    <span class="badge bg-success">Aktif</span>
                                </td>
                                <td>
                                    @if($globalContract->public_token)
                                        <div class="input-group input-group-sm" style="max-width: 200px;">
                                            <input type="text" class="form-control form-control-sm" value="{{ route('public.contract', $globalContract->public_token) }}" readonly id="link-global">
                                            <button class="btn btn-outline-secondary" type="button" onclick="copyLink('global')" title="Linki Kopyala">
                                                <i class="bi bi-clipboard"></i>
                                            </button>
                                            <a href="{{ route('public.contract', $globalContract->public_token) }}" target="_blank" class="btn btn-outline-primary" title="Görüntüle">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </div>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-secondary">Düzenlenemez</span>
                                </td>
                            </tr>
                        @endif
                        @forelse($contracts as $contract)
                            <tr class="{{ $contract->is_default ? 'table-primary' : '' }}">
                                <td>
                                    <strong>{{ $contract->name }}</strong>
                                    @if($contract->is_default)
                                        <span class="badge bg-warning text-dark ms-2"><i class="bi bi-star-fill"></i> Ana Sözleşme</span>
                                    @endif
                                </td>
                                <td>{{ Str::limit(strip_tags($contract->content), 80) }}</td>
                                <td>
                                    @if($contract->is_active)
                                        <span class="badge bg-success">Aktif</span>
                                    @else
                                        <span class="badge bg-secondary">Pasif</span>
                                    @endif
                                </td>
                                <td>
                                    @if($contract->public_token)
                                        <div class="input-group input-group-sm" style="max-width: 200px;">
                                            <input type="text" class="form-control form-control-sm" value="{{ route('public.contract', $contract->public_token) }}" readonly id="link-{{ $contract->id }}">
                                            <button class="btn btn-outline-secondary" type="button" onclick="copyLink('{{ $contract->id }}')" title="Linki Kopyala">
                                                <i class="bi bi-clipboard"></i>
                                            </button>
                                            <a href="{{ route('public.contract', $contract->public_token) }}" target="_blank" class="btn btn-outline-primary" title="Görüntüle">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </div>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        @if(!$contract->is_default && $contract->is_active)
                                            <form action="{{ route('admin.settings.contracts.set-default', $contract->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-success" title="Ana Sözleşme Yap">
                                                    <i class="bi bi-star"></i> <span class="d-none d-md-inline">Ana Yap</span>
                                                </button>
                                            </form>
                                        @endif
                                        <a href="{{ route('admin.settings.contracts.edit', $contract->id) }}" class="btn btn-sm btn-warning" title="Düzenle">
                                            <i class="bi bi-pencil"></i> <span class="d-none d-md-inline">Düzenle</span>
                                        </a>
                                        @if(!$contract->is_default && !$contract->is_required)
                                            <form action="{{ route('admin.settings.contracts.destroy', $contract->id) }}" method="POST" class="d-inline delete-form" data-message="Bu sözleşmeyi silmek istediğinize emin misiniz?">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" title="Sil">
                                                    <i class="bi bi-trash"></i> <span class="d-none d-md-inline">Sil</span>
                                                </button>
                                            </form>
                                        @endif
                                        @if($contract->is_required)
                                            <span class="badge bg-danger">Düzenlenemez</span>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">Sözleşme bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="alert alert-info mt-3">
        <i class="bi bi-info-circle"></i> 
        <strong>İpucu:</strong> <span class="badge bg-warning text-dark"><i class="bi bi-star-fill"></i> Ana Sözleşme</span> olarak işaretlenen sözleşme, 
        randevu oluşturma ve müşterilere gönderilecek SMS/WhatsApp mesajlarında kullanılacaktır.
    </div>
@endsection

@push('scripts')
<script>
function copyLink(contractId) {
    const input = document.getElementById('link-' + contractId);
    input.select();
    document.execCommand('copy');
    
    // Bildirim göster
    const btn = input.nextElementSibling;
    const originalHtml = btn.innerHTML;
    btn.innerHTML = '<i class="bi bi-check"></i>';
    btn.classList.remove('btn-outline-secondary');
    btn.classList.add('btn-success');
    
    setTimeout(() => {
        btn.innerHTML = originalHtml;
        btn.classList.remove('btn-success');
        btn.classList.add('btn-outline-secondary');
    }, 1500);
}
</script>
@endpush

