@extends('layouts.admin')

@section('title', 'Extra Yönetimi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Randevu Extraları</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Extra Yönetimi</h2>
        <a href="{{ route('admin.settings.extras.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Yeni Extra Ekle
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-plus-circle"></i> Randevu Extraları</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Extra Adı</th>
                            <th>Açıklama</th>
                            <th>Fiyat</th>
                            <th>Durum</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($extras as $extra)
                            <tr>
                                <td><strong>{{ $extra->name }}</strong></td>
                                <td>{{ Str::limit($extra->description, 50) }}</td>
                                <td><strong class="text-success">{{ number_format($extra->price, 2, ',', '.') }} ₺</strong></td>
                                <td>
                                    @if($extra->is_active)
                                        <span class="badge bg-success">Aktif</span>
                                    @else
                                        <span class="badge bg-secondary">Pasif</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.settings.extras.edit', $extra->id) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('admin.settings.extras.destroy', $extra->id) }}" method="POST" class="d-inline delete-form" data-message="Bu ekstrayı silmek istediğinize emin misiniz?">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">Extra bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

