@extends('layouts.admin')

@section('title', 'Genel Ayarlar')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-2 fw-bold" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                <i class="bi bi-gear me-2"></i> Genel Ayarlar
            </h1>
            <p class="text-muted mb-0">Sistem genel ayarları ve yapılandırmaları</p>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #34d399 0%, #10b981 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-telephone"></i> İletişim Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.general.update') }}">
                @csrf
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="phone" class="form-label">Telefon Numarası <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="phone" name="phone" 
                               value="{{ $settings['phone'] ?? '0850 811 08 20' }}" 
                               placeholder="0850 811 08 20" required>
                        <small class="form-text text-muted">Bu telefon numarası ana sayfada ve iletişim sayfalarında gösterilecektir.</small>
                    </div>
                    <div class="col-md-6">
                        <label for="email" class="form-label">E-posta Adresi</label>
                        <input type="email" class="form-control" id="email" name="email" 
                               value="{{ $settings['email'] ?? '' }}" 
                               placeholder="info@salonay.com">
                        <small class="form-text text-muted">Genel iletişim e-posta adresi.</small>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="address" class="form-label">Adres</label>
                        <textarea class="form-control" id="address" name="address" rows="3" 
                                  placeholder="Şirket adresi">{{ $settings['address'] ?? '' }}</textarea>
                    </div>
                    <div class="col-md-6">
                        <label for="company_name" class="form-label">Şirket Adı</label>
                        <input type="text" class="form-control" id="company_name" name="company_name" 
                               value="{{ $settings['company_name'] ?? 'Salonay' }}" 
                               placeholder="Salonay">
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Uygulama İndirme Linkleri -->
    <div class="card mt-4">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-download"></i> Uygulama İndirme Linkleri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.general.update') }}">
                @csrf
                
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label for="android_download_url" class="form-label">
                            <i class="bi bi-android2 text-success me-2"></i>Android İndirme Linki
                        </label>
                        <input type="url" class="form-control" id="android_download_url" name="android_download_url" 
                               value="{{ \App\Models\Setting::where('group', 'apps')->where('key', 'android_download_url')->value('value') ?? '' }}" 
                               placeholder="https://play.google.com/store/apps/details?id=...">
                        <small class="form-text text-muted">Google Play Store veya APK indirme linki</small>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-12">
                        <label for="ios_download_url" class="form-label">
                            <i class="bi bi-apple text-dark me-2"></i>iOS İndirme Linki
                        </label>
                        <input type="url" class="form-control" id="ios_download_url" name="ios_download_url" 
                               value="{{ \App\Models\Setting::where('group', 'apps')->where('key', 'ios_download_url')->value('value') ?? '' }}" 
                               placeholder="https://apps.apple.com/app/...">
                        <small class="form-text text-muted">App Store indirme linki</small>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-12">
                        <label class="form-label">
                            <i class="bi bi-windows text-primary me-2"></i>Windows Setup Dosyası
                        </label>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            Windows setup dosyasını <code>storage/Salonay Setup.exe</code> veya <code>storage/app/public/Salonay Setup.exe</code> konumuna yükleyin.
                            @php
                                $fileExists = false;
                                if (file_exists(storage_path('Salonay Setup.exe'))) {
                                    $fileExists = true;
                                } elseif (file_exists(storage_path('app/public/Salonay Setup.exe'))) {
                                    $fileExists = true;
                                } elseif (file_exists(storage_path('app/public/windows-setup.exe'))) {
                                    $fileExists = true;
                                }
                            @endphp
                            @if($fileExists)
                                <span class="badge bg-success ms-2">Dosya mevcut</span>
                            @else
                                <span class="badge bg-warning ms-2">Dosya bulunamadı</span>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Ödeme API Ayarları -->
    <div class="card mt-4">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-credit-card"></i> Ödeme API Ayarları</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.general.update') }}">
                @csrf
                
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label for="payment_provider" class="form-label">Ödeme API Sağlayıcısı <span class="text-danger">*</span></label>
                        <select class="form-select" id="payment_provider" name="payment_provider" required>
                            <option value="paytr" {{ ($settings['payment_provider'] ?? 'paytr') == 'paytr' ? 'selected' : '' }}>PayTR</option>
                            <option value="iyzico" {{ ($settings['payment_provider'] ?? 'paytr') == 'iyzico' ? 'selected' : '' }}>İyzico</option>
                        </select>
                        <small class="form-text text-muted">Paket ve SMS ödemeleri için kullanılacak ödeme API'si</small>
                    </div>
                </div>

                <div id="paytr-settings" style="display: {{ ($settings['payment_provider'] ?? 'paytr') == 'paytr' ? 'block' : 'none' }};">
                    <h6 class="mb-3"><i class="bi bi-info-circle me-2"></i>PayTR Ayarları</h6>
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="paytr_merchant_id" class="form-label">Mağaza No (Merchant ID)</label>
                            <input type="text" class="form-control" id="paytr_merchant_id" name="paytr_merchant_id" 
                                   value="{{ $settings['paytr_merchant_id'] ?? '' }}" 
                                   placeholder="Mağaza numaranız">
                        </div>
                        <div class="col-md-4">
                            <label for="paytr_merchant_key" class="form-label">Mağaza Anahtarı (Merchant Key)</label>
                            <input type="text" class="form-control" id="paytr_merchant_key" name="paytr_merchant_key" 
                                   value="{{ $settings['paytr_merchant_key'] ?? '' }}" 
                                   placeholder="Mağaza anahtarınız">
                        </div>
                        <div class="col-md-4">
                            <label for="paytr_merchant_salt" class="form-label">Mağaza Salt</label>
                            <input type="text" class="form-control" id="paytr_merchant_salt" name="paytr_merchant_salt" 
                                   value="{{ $settings['paytr_merchant_salt'] ?? '' }}" 
                                   placeholder="Mağaza salt değeriniz">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="paytr_test_mode" name="paytr_test_mode" value="1" {{ ($settings['paytr_test_mode'] ?? '0') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label" for="paytr_test_mode">
                                    Test Modu (Sandbox)
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="iyzico-settings" style="display: {{ ($settings['payment_provider'] ?? 'paytr') == 'iyzico' ? 'block' : 'none' }};">
                    <h6 class="mb-3"><i class="bi bi-info-circle me-2"></i>İyzico Ayarları</h6>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="iyzico_api_key" class="form-label">API Key</label>
                            <input type="text" class="form-control" id="iyzico_api_key" name="iyzico_api_key" 
                                   value="{{ $settings['iyzico_api_key'] ?? '' }}" 
                                   placeholder="İyzico API Key">
                        </div>
                        <div class="col-md-6">
                            <label for="iyzico_secret_key" class="form-label">Secret Key</label>
                            <input type="text" class="form-control" id="iyzico_secret_key" name="iyzico_secret_key" 
                                   value="{{ $settings['iyzico_secret_key'] ?? '' }}" 
                                   placeholder="İyzico Secret Key">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="iyzico_test_mode" name="iyzico_test_mode" value="1" {{ ($settings['iyzico_test_mode'] ?? '1') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label" for="iyzico_test_mode">
                                    Test Modu (Sandbox)
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('payment_provider').addEventListener('change', function() {
    const provider = this.value;
    document.getElementById('paytr-settings').style.display = provider === 'paytr' ? 'block' : 'none';
    document.getElementById('iyzico-settings').style.display = provider === 'iyzico' ? 'block' : 'none';
});
</script>
@endsection
