@extends('layouts.admin')

@section('title', 'Fatura Bilgileri')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.membership') }}">Ayarlar</a></li>
    <li class="breadcrumb-item active">Fatura Bilgileri</li>
@endsection

@section('content')
<style>
    .invoice-hero {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border-radius: 20px;
        padding: 32px;
        color: white;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(236, 72, 153, 0.3);
    }
    .invoice-hero h1 { font-size: 28px; font-weight: 700; margin-bottom: 8px; }
    .invoice-card {
        background: white;
        border-radius: 16px;
        padding: 28px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 24px;
        border-left: 4px solid #ec4899;
    }
    .form-label { font-weight: 600; color: #374151; }
    .form-control, .form-select { border-radius: 12px; border: 2px solid #e5e7eb; padding: 12px 16px; }
    .form-control:focus, .form-select:focus { border-color: #ec4899; box-shadow: 0 0 0 3px rgba(236, 72, 153, 0.15); }
</style>

<div class="invoice-hero">
    <h1><i class="bi bi-receipt-cutoff me-2"></i>Fatura Bilgileri</h1>
    <p class="mb-0 opacity-90">Paket ve SMS satın alımlarında kesilecek faturalar için bilgilerinizi girin. İstediğiniz zaman buradan kaydedebilirsiniz.</p>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif
@if($errors->any())
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle me-2"></i>
        <ul class="mb-0 ps-3">
            @foreach($errors->all() as $err)
                <li>{{ $err }}</li>
            @endforeach
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<form action="{{ route('admin.settings.invoice-info.update') }}" method="POST">
    @csrf
    <div class="invoice-card">
        <h5 class="mb-4"><i class="bi bi-person-vcard me-2 text-primary"></i>Fatura Kişi / Kurum Bilgisi</h5>
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Fatura Türü</label>
                <select name="invoice_type" class="form-select" id="invoiceType">
                    <option value="bireysel" {{ ($user->invoice_type ?? '') == 'bireysel' ? 'selected' : '' }}>Bireysel</option>
                    <option value="kurumsal" {{ ($user->invoice_type ?? '') == 'kurumsal' ? 'selected' : '' }}>Kurumsal</option>
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label" id="invoiceNameLabel">Ad Soyad</label>
                <input type="text" name="invoice_name" class="form-control {{ $errors->has('invoice_name') ? 'is-invalid' : '' }}" value="{{ old('invoice_name', $user->invoice_name) }}" placeholder="Ad Soyad veya Ünvan">
                @error('invoice_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
            </div>
            <div class="col-md-6">
                <label class="form-label" id="taxNumberLabel">TC Kimlik No</label>
                <input type="text" name="invoice_tax_number" class="form-control" value="{{ old('invoice_tax_number', $user->invoice_tax_number) }}" placeholder="TC Kimlik No (11 hane)" maxlength="11" id="invoiceTaxNumber">
            </div>
            <div class="col-md-6" id="taxOfficeWrap" style="display:none;">
                <label class="form-label">Vergi Dairesi</label>
                <input type="text" name="invoice_tax_office" class="form-control" value="{{ old('invoice_tax_office', $user->invoice_tax_office) }}" placeholder="Vergi Dairesi">
            </div>
        </div>
    </div>

    <div class="invoice-card">
        <h5 class="mb-4"><i class="bi bi-geo-alt me-2 text-primary"></i>Fatura Adresi</h5>
        <div class="row g-3">
            <div class="col-12">
                <label class="form-label">Adres</label>
                <textarea name="invoice_address" class="form-control" rows="3" placeholder="Mahalle, sokak, bina no, daire no">{{ old('invoice_address', $user->invoice_address) }}</textarea>
            </div>
            <div class="col-md-4">
                <label class="form-label">İl</label>
                <select name="invoice_city" class="form-select" id="invoiceCity">
                    <option value="">İl seçin</option>
                    @php $cities = array_keys(\App\Helpers\DistrictHelper::getAllDistricts()); @endphp
                    @foreach($cities as $city)
                        <option value="{{ $city }}" {{ ($user->invoice_city ?? '') == $city ? 'selected' : '' }}>{{ $city }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">İlçe</label>
                <select name="invoice_district" class="form-select" id="invoiceDistrict">
                    <option value="">Önce il seçin</option>
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">Posta Kodu</label>
                <input type="text" name="invoice_postal_code" class="form-control" value="{{ old('invoice_postal_code', $user->invoice_postal_code) }}" placeholder="34000" maxlength="10">
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-end gap-2">
        <a href="{{ route('admin.settings.membership') }}" class="btn btn-outline-secondary">İptal</a>
        <button type="submit" class="btn text-white" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
            <i class="bi bi-check-lg me-2"></i>Kaydet
        </button>
    </div>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('invoiceType');
    const nameLabel = document.getElementById('invoiceNameLabel');
    const taxLabel = document.getElementById('taxNumberLabel');
    const taxInput = document.getElementById('invoiceTaxNumber');
    const taxOfficeWrap = document.getElementById('taxOfficeWrap');
    const citySelect = document.getElementById('invoiceCity');
    const districtSelect = document.getElementById('invoiceDistrict');

    const districts = @json(\App\Helpers\DistrictHelper::getAllDistricts());
    const currentDistrict = @json($user->invoice_district ?? '');

    function toggleInvoiceType() {
        const isKurumsal = typeSelect.value === 'kurumsal';
        nameLabel.textContent = isKurumsal ? 'Ünvan' : 'Ad Soyad';
        taxLabel.textContent = isKurumsal ? 'Vergi No (VKN)' : 'TC Kimlik No';
        taxInput.placeholder = isKurumsal ? 'Vergi No (10 hane)' : 'TC Kimlik No (11 hane)';
        taxInput.maxLength = isKurumsal ? 10 : 11;
        taxOfficeWrap.style.display = isKurumsal ? 'block' : 'none';
    }
    typeSelect.addEventListener('change', toggleInvoiceType);
    toggleInvoiceType();

    function loadDistricts() {
        const city = citySelect.value;
        districtSelect.innerHTML = '<option value="">İlçe seçin</option>';
        if (city && districts[city]) {
            districts[city].forEach(d => {
                const opt = document.createElement('option');
                opt.value = d;
                opt.textContent = d;
                if (d === currentDistrict) opt.selected = true;
                districtSelect.appendChild(opt);
            });
        }
    }
    citySelect.addEventListener('change', loadDistricts);
    loadDistricts();
});
</script>
@endsection
