@extends('layouts.admin')

@section('title', 'Üyelik Bilgilerim')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Üyelik Bilgilerim</li>
@endsection

@section('content')
<style>
    .membership-hero {
        background: linear-gradient(135deg, #10b981 0%, #047857 100%);
        border-radius: 20px;
        padding: 40px;
        color: white;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(124, 58, 237, 0.3);
    }
    
    .membership-hero h1 {
        font-size: 36px;
        font-weight: 700;
        margin-bottom: 10px;
    }
    
    .membership-card {
        background: white;
        border-radius: 20px;
        padding: 32px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 24px;
        border-left: 5px solid #10b981;
    }
    
    .membership-info-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 20px;
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border-radius: 16px;
        margin-bottom: 16px;
        border: 2px solid #e2e8f0;
        transition: all 0.3s ease;
    }
    
    .membership-info-item:hover {
        border-color: #10b981;
        box-shadow: 0 4px 12px rgba(124, 58, 237, 0.1);
        transform: translateY(-2px);
    }
    
    .membership-info-label {
        font-weight: 600;
        color: #475569;
        font-size: 15px;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .membership-info-label i {
        font-size: 20px;
        color: #10b981;
    }
    
    .membership-info-value {
        font-weight: 700;
        color: #1e293b;
        font-size: 18px;
    }
    
    .badge-unlimited {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
        padding: 8px 16px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
    }
    
    .badge-expired {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: white;
        padding: 8px 16px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
    }
    
    .badge-warning {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        color: white;
        padding: 8px 16px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
    }
    
    .badge-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
        padding: 8px 16px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
    }
</style>

<div class="container-fluid">
    <!-- Hero Section -->
    <div class="membership-hero">
        <div class="d-flex justify-content-between align-items-center">
            <div>
        <h1><i class="bi bi-person-badge me-3"></i>Üyelik Bilgilerim</h1>
        <p>Lisans ve üyelik durumunuz</p>
            </div>
            <div class="d-flex gap-2">
                <button type="button" class="btn btn-light" onclick="openChangePasswordModal()">
                    <i class="bi bi-key"></i> Şifremi Değiştir
                </button>
                <button type="button" class="btn btn-light" onclick="openChangePhoneModal()">
                    <i class="bi bi-telephone"></i> Telefon Numaramı Değiştir
                </button>
                <button type="button" class="btn btn-light text-danger" onclick="openDeleteAccountModal()">
                    <i class="bi bi-trash"></i> Hesabı Sil
                </button>
            </div>
        </div>
    </div>
    
    <!-- SMS Bakiyesi Kutusu -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="membership-card" style="border-left-color: #10b981; background: linear-gradient(135deg, #ffffff 0%, #f0fdf4 100%);">
                <div class="d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-3">
                        <div style="width: 60px; height: 60px; border-radius: 16px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 28px; box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);">
                            <i class="bi bi-chat-dots"></i>
                        </div>
                        <div>
                            <h5 class="mb-1" style="color: #1e293b; font-weight: 700; font-size: 18px;">
                                SMS Bakiyesi
                            </h5>
                            <p class="mb-0 text-muted" style="font-size: 14px;">
                                Süper admin tarafından atanan SMS bakiyesi
                            </p>
                        </div>
                    </div>
                    <div class="text-end">
                        <div style="font-size: 42px; font-weight: 700; color: #10b981; line-height: 1;">
                            {{ number_format(auth()->user()->sms_balance ?? 0, 0) }}
                        </div>
                        <div style="font-size: 14px; color: #64748b; font-weight: 500; margin-top: 4px;">
                            SMS Kredisi
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="membership-card">
                <h3 class="mb-4" style="color: #1e293b; font-weight: 700;">
                    <i class="bi bi-info-circle me-2" style="color: #7c3aed;"></i>Lisans Bilgileri
                </h3>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-shield-check"></i>
                        <span>Lisans Durumu</span>
                    </div>
                    <div class="membership-info-value">
                        @if($isUnlimited)
                            <span class="badge-unlimited">
                                <i class="bi bi-infinity me-1"></i>Sınırsız
                            </span>
                        @elseif($licenseExpiresAt)
                            @php
                                $now = \Carbon\Carbon::now();
                                $expires = \Carbon\Carbon::parse($licenseExpiresAt);
                                $isExpired = $now->gt($expires);
                                $daysRemaining = floor($now->diffInDays($expires, false));
                            @endphp
                            @if($isExpired)
                                <span class="badge-expired">
                                    <i class="bi bi-x-circle me-1"></i>Süresi Dolmuş
                                </span>
                            @elseif($daysRemaining <= 7)
                                <span class="badge-warning">
                                    <i class="bi bi-exclamation-triangle me-1"></i>Yakında Dolacak
                                </span>
                            @else
                                <span class="badge-success">
                                    <i class="bi bi-check-circle me-1"></i>Aktif
                                </span>
                            @endif
                        @else
                            <span class="badge-unlimited">
                                <i class="bi bi-infinity me-1"></i>Sınırsız
                            </span>
                        @endif
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-calendar-event"></i>
                        <span>Üyelik Bitiş Tarihi</span>
                    </div>
                    <div class="membership-info-value">
                        @if($isUnlimited)
                            <span style="color: #10b981; font-weight: 700;">Sınırsız</span>
                        @elseif($licenseExpiresAt)
                            <span>{{ \Carbon\Carbon::parse($licenseExpiresAt)->format('d.m.Y H:i') }}</span>
                        @else
                            <span style="color: #10b981; font-weight: 700;">Sınırsız</span>
                        @endif
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-clock-history"></i>
                        <span>Kalan Süre</span>
                    </div>
                    <div class="membership-info-value">
                        @if($isUnlimited)
                            <span style="color: #10b981; font-weight: 700;">Sınırsız</span>
                        @elseif($licenseExpiresAt)
                            @php
                                $now = \Carbon\Carbon::now();
                                $expires = \Carbon\Carbon::parse($licenseExpiresAt);
                                $daysRemaining = floor($now->diffInDays($expires, false));
                            @endphp
                            @if($daysRemaining < 0)
                                <span style="color: #ef4444; font-weight: 700;">
                                    {{ abs($daysRemaining) }} gün önce doldu
                                </span>
                            @elseif($daysRemaining == 0)
                                <span style="color: #f59e0b; font-weight: 700;">Bugün doluyor</span>
                            @else
                                <span style="color: #10b981; font-weight: 700;">
                                    {{ $daysRemaining }} gün kaldı
                                </span>
                            @endif
                        @else
                            <span style="color: #10b981; font-weight: 700;">Sınırsız</span>
                        @endif
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-person"></i>
                        <span>Kullanıcı Adı</span>
                    </div>
                    <div class="membership-info-value">
                        {{ auth()->user()->name }}
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-envelope"></i>
                        <span>E-posta</span>
                    </div>
                    <div class="membership-info-value">
                        {{ auth()->user()->email }}
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-telephone"></i>
                        <span>Telefon Numarası</span>
                    </div>
                    <div class="membership-info-value">
                        {{ auth()->user()->phone }}
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-shield"></i>
                        <span>Rol</span>
                    </div>
                    <div class="membership-info-value">
                        @if(auth()->user()->role === 'super_admin')
                            <span class="badge bg-danger">Süper Admin</span>
                        @elseif(auth()->user()->role === 'admin')
                            <span class="badge bg-info">Randevucu</span>
                        @else
                            <span class="badge bg-info">Randevucu</span>
                        @endif
                    </div>
                </div>
            </div>
                </div>
                
        <div class="col-lg-4">
            <div class="membership-card" style="border-left-color: #10b981;">
                <h5 class="mb-3" style="color: #1e293b; font-weight: 700;">
                    <i class="bi bi-info-circle me-2" style="color: #10b981;"></i>Bilgilendirme
                </h5>
                <div class="alert alert-info mb-0" style="border-radius: 12px; border: none; background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);">
                    <i class="bi bi-lightbulb me-2"></i>
                    <strong>Lisans Süresi:</strong>
                    <p class="mb-0 mt-2" style="font-size: 14px;">
                        @if($isUnlimited)
                            Üyeliğiniz sınırsızdır. Süper admin tarafından atanan süreye göre otomatik olarak güncellenir.
                        @elseif($licenseExpiresAt)
                            Üyeliğiniz süper admin tarafından atanan süreye göre belirlenmiştir. 
                            @if($daysRemaining !== null && $daysRemaining < 0)
                                <strong class="text-danger">Lisans süreniz dolmuştur.</strong>
                            @elseif($daysRemaining !== null && $daysRemaining <= 7)
                                <strong class="text-warning">Lisans süreniz yakında dolacaktır.</strong>
                            @endif
                        @else
                            Üyeliğiniz sınırsızdır.
                        @endif
                    </p>
                </div>
            </div>
        </div>
        </div>
    </div>
    
    <!-- Şifre Değiştirme Modal -->
    <div class="modal fade" id="changePasswordModal" tabindex="-1" aria-labelledby="changePasswordModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-warning text-dark">
                    <h5 class="modal-title" id="changePasswordModalLabel">
                        <i class="bi bi-key"></i> Şifre Değiştir
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle"></i> Şifrenizi değiştirmek için telefon numaranıza doğrulama kodu gönderilecektir.
                    </div>
                    
                    <form method="POST" action="{{ route('admin.account.change-password') }}" id="modalChangePasswordForm">
                        @csrf
                        
                        <div class="mb-3">
                            <label class="form-label">Telefon Numarası</label>
                            <div class="input-group">
                                <input type="tel" class="form-control" value="{{ auth()->user()->phone }}" readonly>
                                <button type="button" class="btn btn-outline-warning" id="modalSendPasswordOtpBtn" onclick="sendPasswordOtpModal()">
                                    <i class="bi bi-send"></i> Kod Gönder
                                </button>
                            </div>
                            <small class="text-muted" id="modalPasswordOtpStatus"></small>
                        </div>
                        
                        <div class="mb-3" id="modalPasswordOtpField" style="display: none;">
                            <label for="modal_password_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="modal_password_otp_code" name="otp_code" maxlength="6" placeholder="6 haneli kod" required>
                            <small class="text-muted">Telefonunuza gönderilen 6 haneli kodu giriniz.</small>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="modal_new_password" class="form-label">Yeni Şifre <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="modal_new_password" name="password" minlength="8" required>
                                <small class="text-muted">En az 8 karakter olmalıdır.</small>
                            </div>
                            <div class="col-md-6">
                                <label for="modal_new_password_confirmation" class="form-label">Yeni Şifre (Tekrar) <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="modal_new_password_confirmation" name="password_confirmation" minlength="8" required>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-warning" onclick="submitChangePasswordModal()">
                        <i class="bi bi-key"></i> Şifreyi Değiştir
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Telefon Değiştirme Modal -->
    <div class="modal fade" id="changePhoneModal" tabindex="-1" aria-labelledby="changePhoneModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h5 class="modal-title text-dark" id="changePhoneModalLabel">
                        <i class="bi bi-telephone"></i> Telefon Numarası Değiştir
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle"></i> Telefon numaranızı değiştirmek için yeni telefon numaranıza doğrulama kodu gönderilecek ve mevcut şifreniz istenecektir.
                    </div>
                    
                    <form method="POST" action="{{ route('admin.account.change-phone') }}" id="modalChangePhoneForm">
                        @csrf
                        
                        <div class="mb-3">
                            <label class="form-label">Mevcut Telefon Numarası</label>
                            <input type="tel" class="form-control" value="{{ auth()->user()->phone }}" readonly>
                        </div>
                        
                        <div class="mb-3">
                            <label for="modal_new_phone" class="form-label">Yeni Telefon Numarası <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="tel" class="form-control" id="modal_new_phone" name="new_phone" placeholder="05XX XXX XX XX" required>
                                <button type="button" class="btn btn-outline-info" id="modalSendPhoneOtpBtn" onclick="sendPhoneOtpModal()">
                                    <i class="bi bi-send"></i> Kod Gönder
                                </button>
                            </div>
                            <small class="text-muted" id="modalPhoneOtpStatus"></small>
                        </div>
                        
                        <div class="mb-3" id="modalPhoneOtpField" style="display: none;">
                            <label for="modal_phone_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="modal_phone_otp_code" name="otp_code" maxlength="6" placeholder="6 haneli kod" required>
                            <small class="text-muted">Yeni telefon numaranıza gönderilen 6 haneli kodu giriniz.</small>
                        </div>
                        
                        <div class="mb-3">
                            <label for="modal_phone_change_password" class="form-label">Mevcut Şifre <span class="text-danger">*</span></label>
                            <input type="password" class="form-control" id="modal_phone_change_password" name="password" required placeholder="Hesap şifrenizi giriniz">
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-info" onclick="submitChangePhoneModal()">
                        <i class="bi bi-telephone"></i> Telefon Numarasını Değiştir
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Hesap Silme Modal -->
    <div class="modal fade" id="deleteAccountModal" tabindex="-1" aria-labelledby="deleteAccountModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h5 class="modal-title text-dark" id="deleteAccountModalLabel">
                        <i class="bi bi-exclamation-triangle"></i> Hesabı Sil
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="bi bi-info-circle"></i> <strong>Dikkat!</strong> Bu işlem geri alınamaz. Hesabınız ve tüm verileriniz kalıcı olarak silinecektir.
                    </div>
                    
                    <form method="POST" action="{{ route('admin.account.destroy') }}" id="modalDeleteAccountForm">
                        @csrf
                        @method('DELETE')
                        
                        <div class="mb-3">
                            <label for="modal_delete_password" class="form-label">Şifre Doğrulama <span class="text-danger">*</span></label>
                            <input type="password" class="form-control" id="modal_delete_password" name="password" required placeholder="Hesap şifrenizi giriniz">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Telefon Numarası</label>
                            <div class="input-group">
                                <input type="tel" class="form-control" value="{{ auth()->user()->phone }}" readonly>
                                <button type="button" class="btn btn-outline-danger" id="modalSendDeleteOtpBtn" onclick="sendDeleteOtpModal()">
                                    <i class="bi bi-send"></i> Kod Gönder
                                </button>
                            </div>
                            <small class="text-muted" id="modalDeleteOtpStatus"></small>
                        </div>
                        
                        <div class="mb-3" id="modalDeleteOtpField" style="display: none;">
                            <label for="modal_delete_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="modal_delete_otp_code" name="otp_code" maxlength="6" placeholder="6 haneli kod" required>
                            <small class="text-muted">Telefonunuza gönderilen 6 haneli kodu giriniz.</small>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-danger" onclick="submitDeleteAccountModal()">
                        <i class="bi bi-trash"></i> Hesabı Kalıcı Olarak Sil
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
    // Modal açma fonksiyonları
    function openChangePasswordModal() {
        const modalElement = document.getElementById('changePasswordModal');
        if (modalElement) {
            const modal = new bootstrap.Modal(modalElement);
            modal.show();
        } else {
            console.error('changePasswordModal bulunamadı');
        }
    }
    
    function openChangePhoneModal() {
        const modalElement = document.getElementById('changePhoneModal');
        if (modalElement) {
            const modal = new bootstrap.Modal(modalElement);
            modal.show();
        } else {
            console.error('changePhoneModal bulunamadı');
        }
    }
    
    function openDeleteAccountModal() {
        const modalElement = document.getElementById('deleteAccountModal');
        if (modalElement) {
            const modal = new bootstrap.Modal(modalElement);
            modal.show();
        } else {
            console.error('deleteAccountModal bulunamadı');
        }
    }
    
    // Modal içindeki OTP gönderme fonksiyonları
    function sendPasswordOtpModal() {
        const sendBtn = document.getElementById('modalSendPasswordOtpBtn');
        const otpStatus = document.getElementById('modalPasswordOtpStatus');
        const otpField = document.getElementById('modalPasswordOtpField');
        
        if (!sendBtn || !otpStatus || !otpField) {
            console.error('Modal elementleri bulunamadı');
            return;
        }
        
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        otpStatus.textContent = '';
        
        fetch('{{ route("admin.account.send-password-change-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                otpStatus.className = 'text-success';
                otpField.style.display = 'block';
                const otpInput = document.getElementById('modal_password_otp_code');
                if (otpInput) otpInput.focus();
                
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    function sendPhoneOtpModal() {
        const newPhoneInput = document.getElementById('modal_new_phone');
        if (!newPhoneInput || !newPhoneInput.value.trim()) {
            alert('Lütfen yeni telefon numarasını giriniz.');
            return;
        }
        
        const newPhone = newPhoneInput.value.trim();
        const sendBtn = document.getElementById('modalSendPhoneOtpBtn');
        const otpStatus = document.getElementById('modalPhoneOtpStatus');
        const otpField = document.getElementById('modalPhoneOtpField');
        
        if (!sendBtn || !otpStatus || !otpField) {
            console.error('Modal elementleri bulunamadı');
            return;
        }
        
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        otpStatus.textContent = '';
        
        fetch('{{ route("admin.account.send-phone-change-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ new_phone: newPhone })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu yeni telefon numaranıza gönderildi. Lütfen kontrol edin.';
                otpStatus.className = 'text-success';
                otpField.style.display = 'block';
                const otpInput = document.getElementById('modal_phone_otp_code');
                if (otpInput) otpInput.focus();
                
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    function sendDeleteOtpModal() {
        const sendBtn = document.getElementById('modalSendDeleteOtpBtn');
        const otpStatus = document.getElementById('modalDeleteOtpStatus');
        const otpField = document.getElementById('modalDeleteOtpField');
        
        if (!sendBtn || !otpStatus || !otpField) {
            console.error('Modal elementleri bulunamadı');
            return;
        }
        
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        otpStatus.textContent = '';
        
        fetch('{{ route("admin.account.send-delete-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                otpStatus.className = 'text-success';
                otpField.style.display = 'block';
                const otpInput = document.getElementById('modal_delete_otp_code');
                if (otpInput) otpInput.focus();
                
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    // Form gönderme fonksiyonları
    function submitChangePasswordModal() {
        const form = document.getElementById('modalChangePasswordForm');
        const otpCode = document.getElementById('modal_password_otp_code')?.value;
        const password = document.getElementById('modal_new_password')?.value;
        const passwordConfirmation = document.getElementById('modal_new_password_confirmation')?.value;
        
        if (!otpCode || otpCode.length !== 6) {
            alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
            return;
        }
        
        if (!password || password.length < 8) {
            alert('Şifre en az 8 karakter olmalıdır.');
            return;
        }
        
        if (password !== passwordConfirmation) {
            alert('Şifreler eşleşmiyor.');
            return;
        }
        
        if (form) form.submit();
    }
    
    function submitChangePhoneModal() {
        const form = document.getElementById('modalChangePhoneForm');
        const newPhone = document.getElementById('modal_new_phone')?.value.trim();
        const otpCode = document.getElementById('modal_phone_otp_code')?.value;
        const password = document.getElementById('modal_phone_change_password')?.value;
        
        if (!newPhone) {
            alert('Lütfen yeni telefon numarasını giriniz.');
            return;
        }
        
        if (!otpCode || otpCode.length !== 6) {
            alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
            return;
        }
        
        if (!password) {
            alert('Lütfen mevcut şifrenizi giriniz.');
            return;
        }
        
        if (form) form.submit();
    }
    
    function submitDeleteAccountModal() {
        const form = document.getElementById('modalDeleteAccountForm');
        const password = document.getElementById('modal_delete_password')?.value;
        const otpCode = document.getElementById('modal_delete_otp_code')?.value;
        
        if (!password) {
            alert('Lütfen şifrenizi giriniz.');
            return;
        }
        
        if (!otpCode || otpCode.length !== 6) {
            alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
            return;
        }
        
        if (confirm('Hesabınızı silmek istediğinize emin misiniz? Bu işlem geri alınamaz!')) {
            if (form) form.submit();
        }
    }
    
    // OTP kodları sadece rakam girişi
    document.addEventListener('DOMContentLoaded', function() {
        const otpInputs = ['modal_password_otp_code', 'modal_phone_otp_code', 'modal_delete_otp_code'];
        otpInputs.forEach(id => {
            const input = document.getElementById(id);
            if (input) {
                input.addEventListener('input', function(e) {
                    this.value = this.value.replace(/[^0-9]/g, '');
                });
            }
        });
    });
</script>
@endsection
