@extends('layouts.admin')

@section('title', 'Kişisel Faturalar')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.membership') }}">Ayarlar</a></li>
    <li class="breadcrumb-item active">Kişisel Faturalar</li>
@endsection

@section('content')
<style>
    .invoice-hero {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border-radius: 20px;
        padding: 40px;
        color: white;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(236, 72, 153, 0.3);
    }
    
    .invoice-hero h1 {
        font-size: 36px;
        font-weight: 700;
        margin-bottom: 10px;
    }
    
    .invoice-card {
        background: white;
        border-radius: 16px;
        padding: 25px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 20px;
        border-left: 4px solid #ec4899;
        transition: all 0.3s ease;
    }
    
    .invoice-card:hover {
        box-shadow: 0 8px 30px rgba(236, 72, 153, 0.15);
        transform: translateY(-3px);
    }
    
    .invoice-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
        flex-wrap: wrap;
        gap: 15px;
    }
    
    .invoice-title {
        font-size: 20px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }
    
    .invoice-date {
        color: #64748b;
        font-size: 14px;
    }
    
    .invoice-amount {
        font-size: 28px;
        font-weight: 800;
        color: #ec4899;
    }
    
    .invoice-details {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
        margin-top: 20px;
        padding-top: 20px;
        border-top: 1px solid #e2e8f0;
    }
    
    .detail-item {
        display: flex;
        flex-direction: column;
    }
    
    .detail-label {
        font-size: 12px;
        color: #64748b;
        font-weight: 600;
        text-transform: uppercase;
        margin-bottom: 5px;
    }
    
    .detail-value {
        font-size: 16px;
        color: #0f172a;
        font-weight: 600;
    }
    
    .status-badge {
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 600;
        display: inline-block;
    }
    
    .status-pending {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        color: #92400e;
    }
    
    .status-completed {
        background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
        color: #065f46;
    }
    
    .status-failed {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        color: #991b1b;
    }
    
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        background: white;
        border-radius: 20px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    }
    
    .empty-state i {
        font-size: 64px;
        color: #cbd5e1;
        margin-bottom: 20px;
    }
    
    .empty-state h3 {
        color: #1e293b;
        font-weight: 700;
        margin-bottom: 10px;
    }
    
    .empty-state p {
        color: #64748b;
    }
</style>

<div class="container-fluid">
    <div class="invoice-hero d-flex flex-wrap justify-content-between align-items-center gap-3">
        <div>
            <h1><i class="bi bi-receipt me-3"></i>Kişisel Faturalar</h1>
            <p class="mb-0">Paket ve SMS satın alma geçmişiniz</p>
        </div>
        <div class="d-flex gap-2 flex-wrap">
            <a href="{{ route('admin.packages.select') }}" class="btn btn-light text-dark text-decoration-none fw-semibold px-4 py-2 rounded-3" style="border: 2px solid rgba(255,255,255,0.5);">
                <i class="bi bi-box-seam me-2"></i>Paket Satın Al
            </a>
            <a href="{{ route('admin.sms-packages.index') }}" class="btn btn-light text-dark text-decoration-none fw-semibold px-4 py-2 rounded-3" style="border: 2px solid rgba(255,255,255,0.5);">
                <i class="bi bi-chat-dots me-2"></i>SMS Paketleri
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="bi bi-exclamation-circle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if($transactions->count() > 0)
        <div class="row">
            @foreach($transactions as $transaction)
            <div class="col-12 mb-3">
                <div class="invoice-card">
                    <div class="invoice-header">
                        <div>
                            <div class="invoice-title">
                                {{ $transaction->description }}
                            </div>
                            <div class="invoice-date">
                                <i class="bi bi-calendar me-2"></i>{{ $transaction->created_at->format('d.m.Y H:i') }}
                            </div>
                        </div>
                        <div class="text-end">
                            <div class="invoice-amount">
                                {{ number_format($transaction->amount, 2, ',', '.') }} ₺
                            </div>
                            <div class="mt-2">
                                @if(($transaction->status ?? '') === 'pending')
                                    <span class="status-badge status-pending">
                                        <i class="bi bi-clock me-1"></i>Onay Bekliyor
                                    </span>
                                @elseif(($transaction->status ?? '') === 'completed')
                                    <span class="status-badge status-completed">
                                        <i class="bi bi-check-circle me-1"></i>Tamamlandı
                                    </span>
                                @elseif(($transaction->status ?? '') === 'failed')
                                    <span class="status-badge status-failed">
                                        <i class="bi bi-x-circle me-1"></i>Başarısız
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <div class="invoice-details">
                        <div class="detail-item">
                            <span class="detail-label">Ödeme Yöntemi</span>
                            <span class="detail-value">
                                @if(($transaction->payment_method ?? '') === 'paytr')
                                    <i class="bi bi-credit-card me-2"></i>PayTR
                                @elseif(($transaction->payment_method ?? '') === 'bank_transfer')
                                    <i class="bi bi-bank me-2"></i>Havale/EFT
                                @else
                                    <i class="bi bi-question-circle me-2"></i>Bilinmiyor
                                @endif
                            </span>
                        </div>
                        
                        <div class="detail-item">
                            <span class="detail-label">Referans No</span>
                            <span class="detail-value" style="font-size: 13px; font-family: monospace;">
                                {{ $transaction->payment_reference ?? '-' }}
                            </span>
                        </div>
                        
                        <div class="detail-item">
                            <span class="detail-label">Tarih</span>
                            <span class="detail-value">
                                {{ $transaction->date ? $transaction->date->format('d.m.Y') : $transaction->created_at->format('d.m.Y') }}
                            </span>
                        </div>
                        
                        @if(($transaction->status ?? '') === 'pending' && ($transaction->payment_method ?? '') === 'bank_transfer')
                        <div class="detail-item">
                            <span class="detail-label">Durum</span>
                            <span class="detail-value text-warning">
                                <i class="bi bi-hourglass-split me-1"></i>Ödeme onayı bekleniyor
                            </span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        
        <div class="mt-4">
            {{ $transactions->links() }}
        </div>
    @else
        <div class="empty-state">
            <i class="bi bi-inbox"></i>
            <h3>Henüz fatura bulunmuyor</h3>
            <p>Paket veya SMS satın aldığınızda faturalarınız burada görünecektir.</p>
            <a href="{{ route('admin.packages.select') }}" class="btn btn-primary mt-3 px-4 py-3 rounded-3 fw-semibold text-decoration-none">
                <i class="bi bi-box-seam me-2"></i>Paket Satın Al
            </a>
        </div>
    @endif
</div>
@endsection

