@extends('layouts.admin')

@section('title', 'Yeni Salon Ekle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.salons.index') }}">Salon Yönetimi</a></li>
    <li class="breadcrumb-item active">Yeni Salon</li>
@endsection

@section('content')
    @if(isset($isRequired) && $isRequired)
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle-fill me-2"></i>
            <strong>Zorunlu Salon Oluşturma:</strong> Devam edebilmek için en az 1 salon oluşturmanız gerekmektedir.
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>{{ isset($isRequired) && $isRequired ? 'Salon Oluştur (Zorunlu)' : 'Yeni Salon Ekle' }}</h2>
        @if(!isset($isRequired) || !$isRequired)
            <a href="{{ route('admin.settings.salons.index') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Geri
            </a>
        @endif
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header {{ isset($isRequired) && $isRequired ? 'bg-warning text-dark' : 'bg-primary text-white' }}">
            <h5 class="mb-0"><i class="bi bi-building"></i> Salon Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.salons.store') }}">
                @csrf
                @if(isset($isRequired) && $isRequired)
                    <input type="hidden" name="is_required" value="1">
                @endif
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Salon Adı <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control form-control-lg" value="{{ old('name') }}" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Telefon Numarası <span class="text-danger">*</span></label>
                        <input type="text" name="phone" class="form-control form-control-lg" value="{{ old('phone') }}" placeholder="05XX XXX XX XX" required>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Adres <span class="text-danger">*</span></label>
                    <textarea name="address" class="form-control" rows="2" placeholder="Salon adresi" required>{{ old('address') }}</textarea>
                </div>
                
                <input type="hidden" name="is_active" value="1">
                
                <div class="d-flex justify-content-end gap-2">
                    @if(!isset($isRequired) || !$isRequired)
                        <a href="{{ route('admin.settings.salons.index') }}" class="btn btn-lg btn-secondary">
                            <i class="bi bi-x-circle"></i> İptal
                        </a>
                    @endif
                    <button type="submit" class="btn btn-lg {{ isset($isRequired) && $isRequired ? 'btn-warning' : 'btn-primary' }}">
                        <i class="bi bi-check-circle"></i> {{ isset($isRequired) && $isRequired ? 'Salon Oluştur ve Devam Et' : 'Kaydet' }}
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

