@extends('layouts.admin')

@section('title', 'Salon Düzenle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.salons.index') }}">Salon Yönetimi</a></li>
    <li class="breadcrumb-item active">Düzenle</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Salon Düzenle</h2>
        <a href="{{ route('admin.settings.salons.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-pencil-square"></i> Salon Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.salons.update', $salon->id) }}">
                @csrf
                @method('PUT')
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Salon Adı <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control form-control-lg" value="{{ old('name', $salon->name) }}" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Telefon Numarası <span class="text-danger">*</span></label>
                        <input type="text" name="phone" class="form-control form-control-lg" value="{{ old('phone', $salon->phone) }}" placeholder="05XX XXX XX XX" required>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Adres <span class="text-danger">*</span></label>
                    <textarea name="address" class="form-control" rows="2" placeholder="Salon adresi" required>{{ old('address', $salon->address) }}</textarea>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">İl <span class="text-danger">*</span></label>
                        <select name="city" id="edit_salon_city" class="form-select form-select-lg" required>
                            <option value="">İl Seçin</option>
                            @php
                                $cities = [
                                    'Adana', 'Adıyaman', 'Afyonkarahisar', 'Ağrı', 'Aksaray', 'Amasya', 'Ankara', 'Antalya',
                                    'Ardahan', 'Artvin', 'Aydın', 'Balıkesir', 'Bartın', 'Batman', 'Bayburt', 'Bilecik',
                                    'Bingöl', 'Bitlis', 'Bolu', 'Burdur', 'Bursa', 'Çanakkale', 'Çankırı', 'Çorum',
                                    'Denizli', 'Diyarbakır', 'Düzce', 'Edirne', 'Elazığ', 'Erzincan', 'Erzurum', 'Eskişehir',
                                    'Gaziantep', 'Giresun', 'Gümüşhane', 'Hakkari', 'Hatay', 'Iğdır', 'Isparta', 'İstanbul',
                                    'İzmir', 'Kahramanmaraş', 'Karabük', 'Karaman', 'Kars', 'Kastamonu', 'Kayseri', 'Kilis',
                                    'Kırıkkale', 'Kırklareli', 'Kırşehir', 'Kocaeli', 'Konya', 'Kütahya', 'Malatya', 'Manisa',
                                    'Mardin', 'Mersin', 'Muğla', 'Muş', 'Nevşehir', 'Niğde', 'Ordu', 'Osmaniye',
                                    'Rize', 'Sakarya', 'Samsun', 'Siirt', 'Sinop', 'Sivas', 'Şanlıurfa', 'Şırnak',
                                    'Tekirdağ', 'Tokat', 'Trabzon', 'Tunceli', 'Uşak', 'Van', 'Yalova', 'Yozgat', 'Zonguldak'
                                ];
                            @endphp
                            @foreach($cities as $city)
                                <option value="{{ $city }}" {{ old('city', $salon->city) == $city ? 'selected' : '' }}>{{ $city }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">İlçe <span class="text-danger">*</span></label>
                        <select name="district" id="edit_salon_district" class="form-select form-select-lg" required>
                            <option value="">Önce il seçin</option>
                        </select>
                    </div>
                </div>
                
                <input type="hidden" name="is_active" value="1">
                
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.settings.salons.index') }}" class="btn btn-lg btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                    <button type="submit" class="btn btn-lg btn-primary">
                        <i class="bi bi-check-circle"></i> Güncelle
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const citySelect = document.getElementById('edit_salon_city');
    const districtSelect = document.getElementById('edit_salon_district');
    const currentCity = '{{ old('city', $salon->city) }}';
    const currentDistrict = '{{ old('district', $salon->district) }}';
    
    // İl seçildiğinde ilçeleri yükle (tüm ilçeler yerelde)
    const allDistricts = @json(\App\Helpers\DistrictHelper::getAllDistricts());
    if (citySelect) {
        citySelect.addEventListener('change', function() {
            const selectedCity = this.value;
            if (selectedCity) {
                districtSelect.disabled = false;
                districtSelect.innerHTML = '<option value="">İlçe Seçin</option>';
                const cityDistricts = allDistricts[selectedCity] || [];
                cityDistricts.forEach(district => {
                    const option = document.createElement('option');
                    option.value = district;
                    option.textContent = district;
                    if (currentDistrict && district === currentDistrict) {
                        option.selected = true;
                    }
                    districtSelect.appendChild(option);
                });
            } else {
                districtSelect.disabled = true;
                districtSelect.innerHTML = '<option value="">Önce il seçin</option>';
            }
        });
        
        // Sayfa yüklendiğinde mevcut il için ilçeleri yükle
        if (currentCity) {
            citySelect.dispatchEvent(new Event('change'));
        }
    }
});
</script>
@endpush

